/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.netpay.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.netpay.common.bean.Transaction;
import ru.bitel.bgbilling.modules.netpay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.netpay.server.bean.Constants;
import ru.bitel.bgbilling.modules.netpay.server.bean.NetpayUtils;
import ru.bitel.bgbilling.modules.netpay.server.bean.TransactionManager;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Netpay")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("netpay");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        this.setResultParam("gateUrl", this.moduleSetup.get("netpay.gate.url", "https://my.net2pay.ru/billingService/paypage/"));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus(TransactionStatus.ALL.getStatusByCode(this.moduleSetup.get("netpay.status.default", TransactionStatus.ALL.getCode()))));
            this.setResultParam("transactions", searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws BGException {
        this.execute();
    }

    public void fail() throws BGException {
        this.execute();
    }

    public void cancel() throws BGException {
        this.execute();
    }

    @WebOperation(title="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(this.sum)).setContractId(this.contractId)).setCreateDate(new Date())).setTransactionId("")).setParameters("")).build();
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.update(transaction);
        }
        GregorianCalendar date = new GregorianCalendar();
        ((Calendar)date).add(5, this.moduleSetup.getInt("netpay.expired.day", 30));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'V'HH:mm:ss");
        dateFormat.getCalendar().setTimeZone(TimeZone.getTimeZone("Europe/Moscow"));
        String orderDate = dateFormat.format(date.getTime());
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        String description = this.moduleSetup.get("netpay.order.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
        ArrayList<String> params = new ArrayList<String>();
        params.add("description=" + description);
        params.add("amount=" + this.sum.toPlainString().replace(',', '.'));
        params.add("currency=" + this.moduleSetup.get("netpay.order.currency.code", "RUB"));
        params.add("orderID=" + transaction.getId());
        params.add("successUrl=" + this.moduleSetup.get("netpay.order.success.url", ""));
        params.add("failUrl=" + this.moduleSetup.get("netpay.order.fail.url", ""));
        String apiKey = this.moduleSetup.get("netpay.api.key", "js4cucpn4kkc6jl1p95np054g2");
        String auth = this.moduleSetup.get("netpay.auth.signature", "1");
        String cryptoKey = NetpayUtils.getCryptoKey(apiKey, orderDate);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("apiKey: " + apiKey);
            this.getLogger().debug("auth: " + auth);
            this.getLogger().debug("orderDate: " + orderDate);
            this.getLogger().debug("cryptoKey: " + cryptoKey);
        }
        try {
            this.setResultParam("gateUrl", this.moduleSetup.get("netpay.gate.url", "https://my.net2pay.ru/billingService/paypage/"));
            this.setResultParam("formFields", new String[]{"data", "expire", "auth"});
            this.setResultParam("data", URLEncoder.encode(NetpayUtils.encrypt(params, cryptoKey), "utf-8"));
            this.setResultParam("expire", URLEncoder.encode(orderDate, "utf-8"));
            this.setResultParam("auth", auth);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.context.getResponse().setHeader("Pragma", "no-cache");
        this.context.getResponse().setHeader("Cache-Control", "no-cache");
    }
}

