/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import ru.bitel.bgbilling.kernel.module.common.extension.fias.LocationFinder;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;

public class PhoneLocationFinder
extends LocationFinder {
    public PhoneLocationFinder(int modeuleId) {
        super(modeuleId);
    }

    public LocationFinder.AddressData findAddressByNumber(String number) {
        LocationFinder.AddressData result = new LocationFinder.AddressData((LocationFinder)this);
        Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        try {
            String tablePhoneItemNumber = "phone_item_number_" + this.moduleId;
            String tablePhoneClientItem_ = "phone_client_item_" + this.moduleId;
            PreparedStatement ps = this.con.prepareStatement("SELECT t_item.cid,t_item.object_id,t_type.hid,t_type.pod,t_type.flat,t_type.floor FROM " + tablePhoneItemNumber + " as t_num JOIN " + tablePhoneClientItem_ + " AS t_item ON t_item.id=t_num.item_id JOIN contract AS c ON c.id = t_item.cid JOIN contract_parameter_type_2 AS t_type ON t_type.cid = t_item.cid AND ((c.fc=0 AND t_type.pid =?) OR (c.fc=1 AND t_type.pid =?)) WHERE t_num.number=? AND (t_item.date1 IS NULL OR t_item.date1 <= ? ) AND (t_item.date2 IS NULL OR t_item.date1 >= ? )");
            int index = 1;
            ps.setInt(index++, this.getAddressPid(true));
            ps.setInt(index++, this.getAddressPid(false));
            ps.setString(index++, number);
            GregorianCalendar now = new GregorianCalendar();
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)now));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result.setCid(rs.getInt("t_item.cid"));
                int objectId = rs.getInt("t_item.object_id");
                if (objectId > 0) {
                    PreparedStatement psObj = this.con.prepareStatement("select hid,pod,flat,floor from object_param_value_address AS t where t.param_id=? ANd t.object_id = ?");
                    psObj.setInt(1, this.getObjectAddressPid());
                    psObj.setInt(2, objectId);
                    ResultSet rsObj = psObj.executeQuery();
                    if (rsObj.next()) {
                        int houseId = rsObj.getInt("hid");
                        result.setHouseId(String.valueOf(houseId));
                        result.setHouseGuid(this.getHouseGuid(houseId));
                        result.setEntrance(rsObj.getString("pod"));
                        result.setLevel(rsObj.getString("floor"));
                        result.setRoom(rsObj.getString("flat"));
                        result.setFind(true);
                    }
                    rsObj.close();
                    psObj.close();
                } else {
                    int houseId = rs.getInt("t_type.hid");
                    result.setHouseId(String.valueOf(houseId));
                    result.setHouseGuid(this.getHouseGuid(houseId));
                    result.setEntrance(rs.getString("t_type.pod"));
                    result.setLevel(rs.getString("t_type.floor"));
                    result.setRoom(rs.getString("t_type.flat"));
                    result.setFind(true);
                }
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

