/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageBase;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.enums.SmartHousePackageTariffMode;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class SmartHousePackageBaseDao
extends AbstractIdDao<SmartHousePackageBase>
implements Directory<SmartHousePackageBase> {
    private Logger logger = LogManager.getLogger();

    public SmartHousePackageBaseDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_package");
    }

    public void searchPackageBases(SearchResult<SmartHousePackageBase> searchResult, String title, boolean showOld) throws BGException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE true " + (Utils.notBlankString((String)title) ? " AND title LIKE ?" : "") + (page == null ? "" : page.sqlLimit());
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            if (Utils.notBlankString((String)title)) {
                psSelect.setString(parameterIndex++, title);
            }
            try (ResultSet resultSet = psSelect.executeQuery();){
                while (resultSet.next()) {
                    list.add(this.getFromRS(resultSet));
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.con));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    protected SmartHousePackageBase getFromRS(ResultSet rs) throws SQLException, BGException {
        return SmartHousePackageBase.builder().setId(rs.getInt("id")).setTitle(rs.getString("title")).setPeriod(new Period((Date)rs.getDate("date_from"), (Date)rs.getDate("date_to"))).setOptionNames(Optional.ofNullable(rs.getString("option_names")).orElse("[]")).setComment(rs.getString("comment")).setDurationValue(rs.getInt("duration_value")).setDurationUnitCode(rs.getInt("duration_unit_code")).setNpayModuleId(rs.getInt("npay_module_id")).setNpayServiceId(rs.getInt("npay_service_id")).setTariffMode(SmartHousePackageTariffMode.valueOf((String)rs.getString("tariff_mode"))).build();
    }

    protected void updateImpl(SmartHousePackageBase packageBase) throws BGException, SQLException {
        Objects.requireNonNull(packageBase);
        boolean update = packageBase.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, date_from=?, date_to=?, comment=?, tariff_mode=?, npay_module_id=?, npay_service_id=?, duration_value=?, duration_unit_code=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, packageBase.getTitle());
            Period period = packageBase.getPeriod();
            ps.setDate(index++, period == null ? null : TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(index++, period == null ? null : TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            ps.setString(index++, packageBase.getComment());
            ps.setString(index++, packageBase.getTariffMode().toString());
            ps.setInt(index++, packageBase.getNpayModuleId());
            ps.setInt(index++, packageBase.getNpayServiceId());
            ps.setInt(index++, packageBase.getDurationValue());
            ps.setInt(index++, packageBase.getDurationUnitCode());
            this.executeUpdate((Id)packageBase, index, ps);
        }
    }

    public void updateOptions(int packageBaseId, String optionNames) throws BGException {
        String query = "UPDATE " + this.tableName + " SET option_names=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setString(index++, optionNames);
            ps.setInt(index++, packageBaseId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
    }

    public SmartHousePackageBase get(String title) throws BGException {
        return null;
    }

    public List<SmartHousePackageBase> list() throws BGException {
        ArrayList<SmartHousePackageBase> list = new ArrayList<SmartHousePackageBase>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY `title`";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            ResultSet resultSet = psSelect.executeQuery();
            while (resultSet.next()) {
                list.add(this.getFromRS(resultSet));
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e);
            throw new BGException((Throwable)e);
        }
        return list;
    }
}

