/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.sqleditor.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.HistoryKeepPeriodType;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.SqlHistoryRequest;
import ru.bitel.bgbilling.plugins.sqleditor.common.bean.SqlHistoryUserConfig;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;

public class SqlHistoryDao {
    private final String historyConfigTableName = "sql_history_config";
    private final String historyRequestTableName = "sql_history_request";
    private final Connection connection;

    public SqlHistoryDao(Connection connection) {
        this.connection = connection;
    }

    public SqlHistoryUserConfig getHistoryUserConfig(int userId) throws BGException {
        SqlHistoryUserConfig historyUserConfig = null;
        String query = "SELECT * FROM sql_history_config WHERE user_id=?";
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, userId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    historyUserConfig = new SqlHistoryUserConfig();
                    historyUserConfig.setId(rs.getInt("id"));
                    historyUserConfig.setUserId(rs.getInt("user_id"));
                    historyUserConfig.setSaveInDatabase(rs.getInt("save_in_database") == 1);
                    historyUserConfig.setKeepPeriod(HistoryKeepPeriodType.valueOf((int)rs.getInt("keep_period_type")));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return historyUserConfig;
    }

    public void updateHistoryUserConfig(SqlHistoryUserConfig historyUserConfig) throws BGException {
        String query;
        String set = " SET user_id=?, save_in_database=?, keep_period_type=?";
        String string = query = historyUserConfig.getId() > 0 ? "UPDATE sql_history_config" + set : "INSERT INTO sql_history_config" + set;
        if (historyUserConfig.getId() > 0) {
            query = query + " WHERE id=?";
        }
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, historyUserConfig.getUserId());
            ps.setInt(2, historyUserConfig.isSaveInDatabase() ? 1 : 0);
            ps.setInt(3, historyUserConfig.getKeepPeriod() == null ? 0 : historyUserConfig.getKeepPeriod().ordinal());
            if (historyUserConfig.getId() > 0) {
                ps.setInt(4, historyUserConfig.getId());
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<SqlHistoryRequest> getRequestListByUser(int userId, Page page) throws BGException {
        ArrayList<SqlHistoryRequest> result = new ArrayList<SqlHistoryRequest>();
        Object query = "SELECT SQL_CALC_FOUND_ROWS * FROM sql_history_request WHERE user_id=? ORDER BY id DESC";
        if (page != null) {
            query = (String)query + page.sqlLimit();
        }
        try (PreparedStatement ps = this.connection.prepareStatement((String)query);){
            ps.setInt(1, userId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    SqlHistoryRequest request = new SqlHistoryRequest();
                    request.setId(rs.getInt("id"));
                    request.setCreateDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("create_date")));
                    request.setUserId(rs.getInt("user_id"));
                    request.setRequest(rs.getString("request"));
                    result.add(request);
                }
            }
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows((Connection)this.connection));
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void updateRequest(SqlHistoryRequest request) throws BGException {
        String query;
        String set = " SET user_id=?, request=?, create_date=?";
        String string = query = request.getId() > 0 ? "UPDATE sql_history_request" + set : "INSERT INTO sql_history_request" + set;
        if (request.getId() > 0) {
            query = query + " WHERE id=?";
        }
        try (PreparedStatement ps = this.connection.prepareStatement(query);){
            ps.setInt(1, request.getUserId());
            ps.setString(2, request.getRequest());
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)request.getCreateDate()));
            if (request.getId() > 0) {
                ps.setInt(4, request.getId());
            }
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteRequests(List<Integer> requestIds) throws BGException {
        if (Utils.isEmptyCollection(requestIds)) {
            return;
        }
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate("DELETE FROM sql_history_request WHERE id IN(" + Utils.toString(requestIds) + ")");
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void deleteRequest(int historyRequestId) throws BGException {
        this.deleteRequests(Collections.singletonList(historyRequestId));
    }

    public void deleteByQueryInfo(Date requestDate, String queryBody) throws BGException {
        try (PreparedStatement ps = this.connection.prepareStatement("DELETE FROM sql_history_request WHERE request=? AND create_date=?");){
            ps.setString(1, queryBody);
            ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)requestDate));
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

