/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.groupaction.client.ContractGroupOperation;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.tv.client.contract.ProductFormBase;
import ru.bitel.bgbilling.modules.tv.common.service.TvService;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;

public class ContractGroupOperationFactory
implements ContractGroupOperation.ContractGroupOperationFactory {
    public Collection<ContractGroupOperation.ContractGroupOperationItem> getContractGroupOperations(String mid, String title) {
        ArrayList<ContractGroupOperation.ContractGroupOperationItem> result = new ArrayList<ContractGroupOperation.ContractGroupOperationItem>(1);
        result.add(new ActivateProduct(mid, title));
        result.add(new DeactivateProduct(mid, title));
        return result;
    }

    private class ActivateProduct
    extends ContractGroupOperation.ContractGroupOperationItem {
        private final String mid;
        private final String moduleTitle;
        private ActivateProductForm productForm;

        private ActivateProduct(String mid, String title) {
            super(title, Integer.valueOf(mid).intValue(), (LayoutManager)new GridBagLayout());
            this.mid = mid;
            this.moduleTitle = title;
        }

        protected void jbInit() throws Exception {
            JTextArea area = this.getTextArea("\u0418\u0437\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b inv_product, inv_product_period, \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u0435\u0442\u0441\u044f \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430, \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 MW");
            this.productForm = new ActivateProductForm((ClientContext)this.getContext(), Integer.valueOf(this.mid));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)area, "Center");
            panel.setMinimumSize(new Dimension(200, panel.getMinimumSize().height));
            panel.setPreferredSize(new Dimension(200, panel.getPreferredSize().height));
            this.add(panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)((Object)this.productForm), new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 14, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        protected void setData() {
            try {
                this.productForm.setData();
            }
            catch (BGException e) {
                this.processException(e);
            }
        }

        protected boolean doItemOperation(String cids) {
            try {
                return this.productForm.doOperation(cids);
            }
            catch (BGException e) {
                this.processException(e);
                return false;
            }
        }

        protected String getOperationTitle() {
            return this.moduleTitle + ": \u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432";
        }
    }

    private class DeactivateProduct
    extends ContractGroupOperation.ContractGroupOperationItem {
        private final String mid;
        private final String moduleTitle;
        private DeactivateProductForm productForm;

        private DeactivateProduct(String mid, String title) {
            super(title, Integer.valueOf(mid).intValue(), (LayoutManager)new GridBagLayout());
            this.mid = mid;
            this.moduleTitle = title;
        }

        protected void jbInit() throws Exception {
            JTextArea area = this.getTextArea("\u0418\u0437\u043c\u0435\u043d\u044f\u044e\u0442\u0441\u044f \u0442\u0430\u0431\u043b\u0438\u0446\u044b inv_product, inv_product_period, \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441 MW");
            this.productForm = new DeactivateProductForm((ClientContext)this.getContext(), Integer.valueOf(this.mid));
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)area, "Center");
            panel.setMinimumSize(new Dimension(200, panel.getMinimumSize().height));
            panel.setPreferredSize(new Dimension(200, panel.getPreferredSize().height));
            this.add(panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.add((Component)((Object)this.productForm), new GridBagConstraints(1, 0, 1, 1, 0.4, 0.0, 14, 1, new Insets(0, 0, 5, 0), 0, 0));
        }

        protected void setData() {
            try {
                this.productForm.setData();
            }
            catch (BGException e) {
                this.processException(e);
            }
        }

        protected boolean doItemOperation(String cids) {
            try {
                return this.productForm.doOperation(cids);
            }
            catch (BGException e) {
                this.processException(e);
                return false;
            }
        }

        protected String getOperationTitle() {
            return this.moduleTitle + ": \u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432";
        }
    }

    private class DeactivateProductForm
    extends ProductFormBase {
        private int moduleId;

        public DeactivateProductForm(ClientContext context, int moduleId) {
            super(context);
            this.moduleId = moduleId;
        }

        @Override
        protected void jbInit() {
            super.jbInit();
            this.setBorder(null);
            this.dateFrom.setEnabled(false);
            this.timeFrom.setEnabled(false);
            this.comment.setEnabled(false);
            this.description.setEnabled(false);
        }

        private void setData() throws BGException {
            Directory productSpecDirectory = ((ClientContext)this.getContext()).getDirectory(ProductSpec.class, 0);
            this.productSpec.setData(this.toProductOfferingList(productSpecDirectory.list()));
            this.productSpec.setEnabled(true);
        }

        private boolean doOperation(String cids) throws BGIllegalArgumentException, BGMessageException, BGIllegalAccessException, BGException {
            Calendar timeToCalendar;
            if (this.productSpec.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442.", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            int productSpecId = ((ProductOffering)this.productSpec.getSelectedItem()).getProductSpec().getId();
            if (this.activationMode.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438.", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            int productSpecActivationModeId = ((ProductOfferingActivationMode)this.activationMode.getSelectedItem()).getProductSpecActivationMode().getId();
            try {
                timeToCalendar = this.getTimeToCalendar();
            }
            catch (BGMessageException ex) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            if (timeToCalendar == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432\u0440\u0435\u043c\u044f \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043e\u043f\u0446\u0438\u0438.", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            Set contractIds = Utils.toIntegerSet((String)cids);
            TvService tvService = (TvService)((ClientContext)this.getContext()).getPort(TvService.class, this.moduleId);
            try {
                tvService.groupOperationDeactivate(contractIds, timeToCalendar.getTime(), productSpecId, productSpecActivationModeId, true);
            }
            catch (BGException ex) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            return true;
        }
    }

    private class ActivateProductForm
    extends ProductFormBase {
        private int moduleId;

        public ActivateProductForm(ClientContext context, int moduleId) {
            super(context);
            this.moduleId = moduleId;
        }

        @Override
        protected void jbInit() {
            super.jbInit();
            this.setBorder(null);
            this.dateTo.setEnabled(false);
            this.timeTo.setEnabled(false);
        }

        private void setData() throws BGException {
            Directory productSpecDirectory = ((ClientContext)this.getContext()).getDirectory(ProductSpec.class, 0);
            this.productSpec.setData(this.toProductOfferingList(productSpecDirectory.list()));
            this.productSpec.setEnabled(true);
        }

        private boolean doOperation(String cids) throws BGIllegalArgumentException, BGMessageException, BGIllegalAccessException, BGException {
            Calendar timeFromCalendar;
            if (this.productSpec.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442.", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            int productSpecId = ((ProductOffering)this.productSpec.getSelectedItem()).getProductSpec().getId();
            if (this.activationMode.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0414\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438.", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            int productSpecActivationModeId = ((ProductOfferingActivationMode)this.activationMode.getSelectedItem()).getProductSpecActivationMode().getId();
            try {
                timeFromCalendar = this.getTimeFromCalendar();
            }
            catch (BGMessageException ex) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            if (timeFromCalendar == null) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432\u0440\u0435\u043c\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043e\u043f\u0446\u0438\u0438.", "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            Set contractIds = Utils.toIntegerSet((String)cids);
            TvService tvService = (TvService)((ClientContext)this.getContext()).getPort(TvService.class, this.moduleId);
            try {
                tvService.groupOperationActivate(contractIds, timeFromCalendar.getTime(), productSpecId, productSpecActivationModeId, Utils.maskBlank((String)this.description.getText(), (String)""), Utils.maskBlank((String)this.comment.getText(), (String)""));
            }
            catch (BGException ex) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ex.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430", 0);
                return false;
            }
            return true;
        }
    }
}

