/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.task;

import java.sql.Connection;
import java.time.LocalDate;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductDao;
import ru.bitel.oss.systems.inventory.product.server.bean.ProductSpecDao;

public class TvNpayProductSyncTask
extends TaskBase {
    private final Logger logger = LogManager.getLogger();

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try {
            this.executeTaskImpl();
        }
        catch (BGException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c TV. \u0417\u0430\u0434\u0430\u0447\u0430 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u0432 (\u0440\u0435\u0436\u0438\u043c \u0430\u0431\u043e\u043d\u043f\u043b\u0430\u0442). \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId;
    }

    public void executeTaskImpl() throws BGException {
        ServerContext parentContext = (ServerContext)ServerContext.get();
        Connection connection = parentContext.getConnection();
        try (ProductDao productDao = new ProductDao(connection);
             ProductSpecDao productSpecDao = new ProductSpecDao(connection);){
            List<ProductSpec> productSpecs = productSpecDao.list().stream().filter(a -> a.getModeId() == 1).toList();
            List<Integer> productSpecIds = productSpecs.stream().map(a -> a.getId()).toList();
            productDao.listEnd(productSpecIds, LocalDate.now(), 1).forEach(a -> {});
        }
    }
}

