/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;

public class VoiceRecord {
    public String id;
    public Date sessionStart;
    public int duration;
    public int connectionDuration;
    public String callingStationId;
    public String calledStationId;
    public String e164CallingStationId;
    public String e164CalledStationId;
    public String trunkIncoming;
    public String trunkOutgoing;
    public int category;
    public BigDecimal callCost = null;
    public BigDecimal callOperCost = null;
    public String logLine;

    public void recycle() {
        this.id = null;
        this.sessionStart = null;
        this.duration = 0;
        this.connectionDuration = 0;
        this.callingStationId = null;
        this.calledStationId = null;
        this.e164CallingStationId = null;
        this.e164CalledStationId = null;
        this.trunkIncoming = null;
        this.trunkOutgoing = null;
        this.category = 0;
        this.callCost = null;
        this.callOperCost = null;
    }

    public VoiceSession toVoiceSession() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.sessionStart);
        cal.add(13, this.duration);
        return VoiceSession.builder().setCalledStationId(this.calledStationId).setE164CalledStationId(this.e164CalledStationId).setCallingStationId(this.callingStationId).setE164CallingStationId(this.e164CallingStationId).setSessionStart(this.sessionStart).setSessionStop(cal.getTime()).setSessionTime((long)this.duration).setFromPort(this.trunkIncoming).setToPort(this.trunkOutgoing).setCdrCallCost(this.callCost).setCdrCallOperCost(this.callOperCost).build();
    }

    public String validationString() {
        try {
            Long.valueOf(this.e164CallingStationId);
        }
        catch (Exception ex) {
            return this.getErrorString("e164CallingStationId not Long..");
        }
        try {
            Long.valueOf(this.e164CalledStationId);
        }
        catch (Exception ex) {
            return this.getErrorString("e164CalledStationId not Long..");
        }
        if (this.sessionStart == null) {
            return this.getErrorString("sessionStart is null..");
        }
        return "";
    }

    private String getErrorString(String error) {
        return error + "[" + this.logLine + "]:sessionStart=>" + this.sessionStart + ", duration=>" + this.duration + ", connectionDuration=>" + this.connectionDuration + ", callingStationId=>" + this.callingStationId + ", calledStationId=>" + this.calledStationId + ", e164CallingStationId=>" + this.e164CallingStationId + ", e164CalledStationId=>" + this.e164CalledStationId + ", trunkIncoming=>" + this.trunkIncoming + ", trunkOutgoing=>" + this.trunkOutgoing + ", category=>" + this.category;
    }
}

