/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.geocode;

import bitel.billing.module.common.BGTextArea;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.BGUTreeTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.LongFormatTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.voice.client.directory.geocode.VoiceGeographicCodeExportPanel;
import ru.bitel.bgbilling.modules.voice.client.directory.geocode.VoiceGeographicCodeImportPanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDestination;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicRange;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceOperator;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceOperatorService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.SearchResult;

public class VoiceGeographicCodePanel
extends BGUPanel {
    private final VoiceDestination NOT_SELECTED_DESTINATION_ITEM = new VoiceDestination(-1, "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
    private final KeyValue NOT_SELECTED_MOBILE_ITEM = new KeyValue("", "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e");
    private BGUTreeTable codeTable;
    private VoiceGeographicCodeTreeTableModel codeModel = new VoiceGeographicCodeTreeTableModel();
    private VoiceGeographicRandeTableModel rangeModel = new VoiceGeographicRandeTableModel();
    private List<VoiceGeographicRange> rangeList = new ArrayList<VoiceGeographicRange>();
    private List<IdTitle> rangeDestinationList = new ArrayList<IdTitle>();
    private BGTextField codeDestinationFilter;
    private BGTextField rangeDestinationFilter;
    private VoiceGeographicCode root = null;
    private VoiceGeographicCodeImportPanel importPanel;
    private VoiceGeographicCodeExportPanel exportPanel;
    private VoiceOperatorService operatorService;
    private VoiceService voiceService;
    private TreePath[] currentSelectionPaths;
    private TreePath currentSelectionPath;
    private CardLayout cardLayout = new CardLayout();
    private JPanel cardPanel = new JPanel(this.cardLayout);
    private JLabel rangeRecords = new JLabel("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: 0");
    private BGUComboBox<VoiceOperator> operators = new BGUComboBox();

    public VoiceGeographicCodePanel(ClientContext context) {
        super((LayoutManager)new GridBagLayout(), context);
    }

    protected void jbInit() throws Exception {
        this.cardPanel.add((Component)this.getTabbedPane(), "main");
        this.cardPanel.add((Component)new JPanel(), "empty");
        this.add(this.getOperatorPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add(this.cardPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
    }

    private JPanel getOperatorPanel() {
        this.operators.addItemListener(a -> {
            if (a.getStateChange() == 1) {
                VoiceOperator oper = (VoiceOperator)this.operators.getSelectedItem();
                this.cardLayout.show(this.cardPanel, oper.getId() == 0 || oper.isUseCustomGeoDict() ? "main" : "empty");
                this.loadCodeTree();
                this.loadRanges();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041e\u043f\u0435\u0440\u0430\u0442\u043e\u0440:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)this.operators, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        return panel;
    }

    private JTabbedPane getTabbedPane() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432", this.getCodeTreePanel());
        tabbedPane.add("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b", this.getMobileRangePanel());
        return tabbedPane;
    }

    private JPanel getCodeTreePanel() {
        this.codeTable = new BGUTreeTable((BGTreeTableModel)this.codeModel);
        this.codeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VoiceGeographicCodePanel.this.performAction(BGDialogToolBar.ButtonData.EDIT_ITEM.getName());
                }
            }
        });
        this.importPanel = new VoiceGeographicCodeImportPanel(this);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.importPanel), (String)"\u041e\u043f\u0446\u0438\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
        this.importPanel.setVisible(false);
        this.exportPanel = new VoiceGeographicCodeExportPanel(this);
        BGSwingUtilites.wrapBorder((JPanel)((Object)this.exportPanel), (String)"\u041e\u043f\u0446\u0438\u0438 \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430");
        this.exportPanel.setVisible(false);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getGeocodeFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.codeTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)((Object)this.importPanel), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)((Object)this.exportPanel), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getGeocodeFilterPanel() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.performAction("geocode." + e.getActionCommand()), new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.DELETE_ALL_ITEM, BGDialogToolBar.ButtonData.SEPARATOR, BGDialogToolBar.ButtonData.IMPORT, BGDialogToolBar.ButtonData.EXPORT});
        toolBar.setFloatable(false);
        this.codeDestinationFilter = new BGTextField(20);
        this.codeDestinationFilter.setHorizontalAlignment(0);
        this.codeDestinationFilter.setPromptText("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043a\u043e\u0434\u0443", true, true);
        this.codeDestinationFilter.addPropertyChangeListener((PropertyChangeListener)new \u0421odeFilterCaretListener());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        panel.add((Component)this.codeDestinationFilter, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 3), 0, 0));
        return panel;
    }

    private JPanel getMobileRangePanel() {
        BGUTable table = new BGUTable((TableModel)((Object)this.rangeModel));
        BGSwingUtilites.handleEdit((JTable)table, (BGUPanel)this, (String)("range." + BGDialogToolBar.ButtonData.EDIT_ITEM.getName()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getRangeFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getRangeFilterPanel() {
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> this.performAction("range." + e.getActionCommand()), new BGDialogToolBar.ButtonData[]{BGDialogToolBar.ButtonData.NEW_ITEM, BGDialogToolBar.ButtonData.EDIT_ITEM, BGDialogToolBar.ButtonData.DELETE_ITEM, BGDialogToolBar.ButtonData.DELETE_ALL_ITEM, BGDialogToolBar.ButtonData.SEPARATOR, BGDialogToolBar.ButtonData.IMPORT, BGDialogToolBar.ButtonData.EXPORT});
        toolBar.setFloatable(false);
        this.rangeDestinationFilter = new BGTextField(20);
        this.rangeDestinationFilter.setHorizontalAlignment(0);
        this.rangeDestinationFilter.setPromptText("\u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043d\u043e\u043c\u0435\u0440\u0443", true, true);
        this.rangeDestinationFilter.addPropertyChangeListener((PropertyChangeListener)new RangeFilterCaretListener());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        panel.add((Component)this.rangeDestinationFilter, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 20, 0, 3), 0, 0));
        panel.add((Component)this.rangeRecords, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        return panel;
    }

    public BGTreeTableModel<VoiceGeographicCode> getCodeTableModel() {
        return this.codeModel;
    }

    private void refreshOperators() throws BGException {
        int selectedIndex = this.operators.getSelectedIndex();
        if (selectedIndex <= 0) {
            selectedIndex = 0;
        }
        List operList = this.getVoiceOperatorService().voiceOperatorList();
        operList.add(0, new VoiceOperator(0, "\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e"));
        this.operators.setData(operList);
        if (selectedIndex < this.operators.getItemCount()) {
            this.operators.setSelectedIndex(selectedIndex);
        }
    }

    private void loadCodeTree() {
        try {
            String data = this.getVoiceService().getGeographicCodeTree(((VoiceOperator)this.operators.getSelectedItem()).getId());
            this.root = (VoiceGeographicCode)VoiceCommonUtils.readFromHolder((byte[])Base64.getDecoder().decode(data));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        if (this.root == null) {
            return;
        }
        this.codeModel.setData(this.root);
        if (this.currentSelectionPaths != null && this.currentSelectionPaths.length > 0) {
            for (TreePath treePath : this.currentSelectionPaths) {
                this.codeTable.makeVisible(treePath);
            }
            this.currentSelectionPaths = null;
        }
    }

    private void loadRanges() {
        try {
            int operId = ((VoiceOperator)this.operators.getSelectedItem()).getId();
            operId = operId == -1 ? 0 : operId;
            String data = this.getVoiceService().voiceGeographicRangeList(operId);
            this.rangeList = (List)VoiceCommonUtils.readFromHolder((byte[])Base64.getDecoder().decode(data));
            List<Integer> destIds = this.rangeList.stream().map(a -> a.getDestinationId()).toList();
            this.rangeDestinationList = this.getVoiceService().voiceDestinationTitles(destIds);
            this.rangeModel.setData(this.rangeList);
            this.rangeRecords.setText("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)this.rangeList.size()));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.refreshOperators();
            this.loadCodeTree();
            this.loadRanges();
        });
        new AbstractBGUPanel.DefaultAction("geocode." + BGDialogToolBar.ButtonData.NEW_ITEM.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicCode parentVoiceGeographicCode = (VoiceGeographicCode)VoiceGeographicCodePanel.this.codeModel.getSelectedRow();
                if (parentVoiceGeographicCode == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u043a\u043e\u0434 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0435\u043c\u043e\u0433\u043e");
                    return;
                }
                VoiceGeographicCodePanel.this.currentSelectionPaths = VoiceGeographicCodePanel.this.codeTable.getSelectionPaths();
                VoiceGeographicCodePanel.this.currentSelectionPath = VoiceGeographicCodePanel.this.codeTable.getSelectionPath();
                VoiceGeographicCode voiceGeographicCode = new VoiceGeographicCode();
                voiceGeographicCode.setCode(parentVoiceGeographicCode != null ? parentVoiceGeographicCode.getCode() : "");
                voiceGeographicCode.setDestinationId(0);
                voiceGeographicCode.setDestinationTitle("");
                VoiceGeographicCodePanel.this.setVisibleBottomPanels(voiceGeographicCode, false, false);
            }
        };
        new AbstractBGUPanel.DefaultAction("geocode." + BGDialogToolBar.ButtonData.EDIT_ITEM.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedCodes = VoiceGeographicCodePanel.this.codeModel.getSelectedRows();
                if (selectedCodes == null || selectedCodes.size() != 1) {
                    BGToolTip.showErrorMessage((JComponent)VoiceGeographicCodePanel.this.codeTable, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 1 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u0434 \u0432 \u0434\u0435\u0440\u0435\u0432\u0435!");
                    return;
                }
                VoiceGeographicCodePanel.this.currentSelectionPaths = VoiceGeographicCodePanel.this.codeTable.getSelectionPaths();
                VoiceGeographicCodePanel.this.currentSelectionPath = VoiceGeographicCodePanel.this.codeTable.getSelectionPath();
                VoiceGeographicCodePanel.this.setVisibleBottomPanels((VoiceGeographicCode)selectedCodes.get(0), false, false);
            }
        };
        new AbstractBGUPanel.DefaultAction("geocode." + BGDialogToolBar.ButtonData.DELETE_ITEM.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedCodeList = VoiceGeographicCodePanel.this.codeModel.getSelectedRows();
                if (selectedCodeList == null || selectedCodeList.isEmpty()) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043e\u0434\u043e\u0432 \u0432 \u0434\u0435\u0440\u0435\u0432\u0435!");
                    return;
                }
                String confirmMessage = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + (selectedCodeList.size() > 1 ? "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u0434\u044b" : "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u043a\u043e\u0434") + "?";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), confirmMessage, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    List codeIdForDelete = selectedCodeList.stream().map(code -> code.getId()).collect(Collectors.toList());
                    VoiceGeographicCodePanel.this.getVoiceService().deleteGeographicCode(codeIdForDelete);
                    TreePath[] deletedPaths = VoiceGeographicCodePanel.this.codeTable.getSelectionPaths();
                    VoiceGeographicCodePanel.this.currentSelectionPaths = new TreePath[deletedPaths.length];
                    for (int i = 0; i < deletedPaths.length; ++i) {
                        VoiceGeographicCodePanel.this.currentSelectionPaths[i] = deletedPaths[i].getParentPath();
                    }
                    VoiceGeographicCodePanel.this.loadCodeTree();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("geocode." + BGDialogToolBar.ButtonData.DELETE_ALL_ITEM.getName(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u0435 \u0434\u0435\u0440\u0435\u0432\u043e \u0433\u0435\u043e\u043a\u043e\u0434\u043e\u0432?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    VoiceGeographicCodePanel.this.getVoiceService().deleteAllGeographicCode(((VoiceOperator)VoiceGeographicCodePanel.this.operators.getSelectedItem()).getId());
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("geocode." + BGDialogToolBar.ButtonData.IMPORT.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicCodePanel.this.importPanel.performActionOpen();
                VoiceGeographicCodePanel.this.setVisibleBottomPanels(null, true, false);
            }
        };
        new AbstractBGUPanel.DefaultAction("geocode." + BGDialogToolBar.ButtonData.EXPORT.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicCodePanel.this.exportPanel.performActionOpen();
                VoiceGeographicCodePanel.this.setVisibleBottomPanels(null, false, true);
            }
        };
        new AbstractBGUPanel.DefaultAction("range." + BGDialogToolBar.ButtonData.NEW_ITEM.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                VoiceGeographicRange voiceGeographicRange = new VoiceGeographicRange();
                voiceGeographicRange.setOperatorId(((VoiceOperator)VoiceGeographicCodePanel.this.operators.getSelectedItem()).getId() > 0 ? ((VoiceOperator)VoiceGeographicCodePanel.this.operators.getSelectedItem()).getId() : 0);
                new VoiceGeographicRangeEditor(voiceGeographicRange.getId() > 0 ? "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430" : "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d", voiceGeographicRange).open();
            }
        };
        new AbstractBGUPanel.DefaultAction("range." + BGDialogToolBar.ButtonData.EDIT_ITEM.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedRanges = VoiceGeographicCodePanel.this.rangeModel.getSelectedRows();
                if (selectedRanges == null || selectedRanges.size() != 1) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 1 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435");
                    return;
                }
                new VoiceGeographicRangeEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430", (VoiceGeographicRange)selectedRanges.get(0)).open();
            }
        };
        new AbstractBGUPanel.DefaultAction("range." + BGDialogToolBar.ButtonData.DELETE_ITEM.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                List selectedRanges = VoiceGeographicCodePanel.this.rangeModel.getSelectedRows();
                if (selectedRanges == null || selectedRanges.isEmpty()) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u0434\u0438\u043d \u0438\u043b\u0438 \u0431\u043e\u043b\u0435\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435");
                    return;
                }
                String confirmMessage = "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c " + (selectedRanges.size() > 1 ? "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b" : "\u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d") + "?";
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), confirmMessage, "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    List idForDelete = selectedRanges.stream().map(code -> code.getId()).collect(Collectors.toList());
                    VoiceGeographicCodePanel.this.getVoiceService().voiceGeographicRangeDelete(idForDelete);
                    VoiceGeographicCodePanel.this.loadRanges();
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("range." + BGDialogToolBar.ButtonData.IMPORT.getName(), ""){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                new VoiceGeographicRangeImportDiaolog().open();
            }
        };
    }

    public void setVisibleBottomPanels(VoiceGeographicCode voiceGeographicCode, boolean hideImport, boolean hideExport) {
        if (voiceGeographicCode != null) {
            new VoiceGeographicCodeEditor(voiceGeographicCode.getId() > 0 ? "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0433\u0435\u043e\u043a\u043e\u0434\u043e\u0432" : "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0433\u0435\u043e\u043a\u043e\u0434", voiceGeographicCode).open();
        }
        this.importPanel.setVisible(hideImport);
        this.exportPanel.setVisible(hideExport);
    }

    public int getOperatorId() {
        return ((VoiceOperator)this.operators.getSelectedItem()).getId();
    }

    private VoiceOperatorService getVoiceOperatorService() {
        if (this.operatorService == null) {
            this.operatorService = (VoiceOperatorService)((ClientContext)this.getContext()).getPort(VoiceOperatorService.class);
        }
        return this.operatorService;
    }

    private VoiceService getVoiceService() {
        if (this.voiceService == null) {
            this.voiceService = (VoiceService)((ClientContext)this.getContext()).getPort(VoiceService.class);
        }
        return this.voiceService;
    }

    private void filterTree(String text, VoiceGeographicCode fromCode, VoiceGeographicCode toCode) {
        String code = fromCode.getCode();
        if (code.length() <= text.length() && code.equals(text.substring(0, code.length())) || code.length() >= text.length() && code.startsWith(text)) {
            VoiceGeographicCode copyCode = new VoiceGeographicCode();
            fromCode.copyTo(copyCode);
            toCode.addChild(copyCode);
            if (fromCode.getChildren() != null) {
                for (VoiceGeographicCode checkCode : fromCode.getChildren()) {
                    this.filterTree(text, checkCode, copyCode);
                }
            }
        }
    }

    void loadDestinations(List<VoiceDestination> destinationList, Map<Integer, VoiceDestination> destinationsMap) {
        try {
            destinationList.clear();
            destinationsMap.clear();
            SearchResult data = ((VoiceService)((ClientContext)this.getContext()).getWebService(VoiceService.class)).voiceDestinationList(this.getOperatorId(), null, null);
            destinationList.addAll(data.getList());
            if (destinationList != null && !destinationList.isEmpty()) {
                destinationsMap.putAll(VoiceDestination.getDestinationMap(destinationList));
                destinationList.add(0, this.NOT_SELECTED_DESTINATION_ITEM);
                return;
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    class VoiceGeographicCodeTreeTableModel
    extends BGTreeTableModel<VoiceGeographicCode> {
        public VoiceGeographicCodeTreeTableModel() {
            super(VoiceGeographicCodeTreeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041a\u043e\u0434", VoiceGeographicCode.class, -1, 300, 300, null, false);
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", -1, -1, -1, "destinationTitle");
        }

        public Object getValue(VoiceGeographicCode val, int column) throws BGException {
            if (column == 0 && val == this.root) {
                return val.getTitle();
            }
            switch (column) {
                case 0: {
                    return val;
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class VoiceGeographicRandeTableModel
    extends BGTableModel<VoiceGeographicRange> {
        public VoiceGeographicRandeTableModel() {
            super(VoiceGeographicRandeTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", 100, 150, 150, "rangeFrom", true, (TableCellRenderer)new LongFormatTableCellRenderer("(\\d)(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3 $4", 4));
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", 100, 150, 150, "rangeTo", true, (TableCellRenderer)new LongFormatTableCellRenderer("(\\d)(\\d{3})(\\d{3})(\\d{4})", "$1 $2 $3 $4", 4));
            this.addColumn("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435", 200, 300, -1, "destinationId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440", 200, 300, 400, "mobileIdId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumnId();
        }

        public Object getValue(VoiceGeographicRange val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("destinationId".equals(identifier)) {
                return VoiceGeographicCodePanel.this.rangeDestinationList.stream().filter(a -> a.getId() == val.getDestinationId()).findFirst().map(a -> a.getTitle()).orElse("#" + String.valueOf(val.getDestinationId()));
            }
            return super.getValue((Object)val, column);
        }
    }

    private class \u0421odeFilterCaretListener
    implements PropertyChangeListener {
        private \u0421odeFilterCaretListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("textChange".equals(evt.getPropertyName())) {
                String filterText = VoiceGeographicCodePanel.this.codeDestinationFilter.getText();
                VoiceGeographicCode filterRoot = VoiceGeographicCodePanel.this.root;
                if (!filterText.isEmpty()) {
                    filterRoot = new VoiceGeographicCode();
                    VoiceGeographicCodePanel.this.root.copyTo(filterRoot);
                    for (VoiceGeographicCode checkCode : VoiceGeographicCodePanel.this.root.getChildren()) {
                        VoiceGeographicCodePanel.this.filterTree(filterText, checkCode, filterRoot);
                    }
                }
                VoiceGeographicCodePanel.this.codeModel.setData(filterRoot);
                VoiceGeographicCodePanel.this.codeTable.expand(filterText.length());
            }
        }
    }

    private class RangeFilterCaretListener
    implements PropertyChangeListener {
        private RangeFilterCaretListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("textChange".equals(evt.getPropertyName())) {
                List<Object> filterList = new ArrayList();
                String filterText = VoiceGeographicCodePanel.this.rangeDestinationFilter.getText();
                if (filterText.isEmpty()) {
                    filterList = VoiceGeographicCodePanel.this.rangeList;
                } else if (filterText.matches("^\\d{1,11}$")) {
                    long a1 = Utils.parseLong((String)(filterText + "0".repeat(11 - filterText.length())));
                    long a2 = Utils.parseLong((String)(filterText + "9".repeat(11 - filterText.length())));
                    filterList.addAll(VoiceGeographicCodePanel.this.rangeList.stream().filter(a -> a.getRangeFrom() <= a2 && a.getRangeTo() >= a1).toList());
                }
                VoiceGeographicCodePanel.this.rangeModel.setData(filterList);
                VoiceGeographicCodePanel.this.rangeRecords.setText("\u0417\u0430\u043f\u0438\u0441\u0435\u0439: " + Utils.formatInteger((int)filterList.size()));
            }
        }
    }

    class VoiceGeographicCodeEditor
    extends BGEditorDialog<VoiceGeographicCode> {
        private BGTextField code;
        private BGControlPanelPeriodNoB codePeriod;
        private BGUComboBox<VoiceDestination> destinations;
        private List<VoiceDestination> destinationList;
        private Map<Integer, VoiceDestination> destinationsMap;

        public VoiceGeographicCodeEditor(String title, VoiceGeographicCode data) {
            super(title, (Object)data);
            this.code = new BGTextField();
            this.codePeriod = new BGControlPanelPeriodNoB();
            this.destinations = new BGUComboBox();
            this.destinationList = new ArrayList<VoiceDestination>();
            this.destinationsMap = new HashMap<Integer, VoiceDestination>();
        }

        public void doDialogPanel() {
            this.code.setHorizontalAlignment(0);
            this.code.setFont(this.code.getFont().deriveFont(this.code.getFont().getSize2D() * 1.5f));
            this.panel.add((Component)new JLabel("\u0413\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u043a\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.panel.add((Component)this.code, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
            this.panel.add((Component)this.destinations, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 3, 3), 0, 0));
            VoiceGeographicCodePanel.this.loadDestinations(this.destinationList, this.destinationsMap);
            this.destinations.setData(this.destinationList);
            this.destinations.setSelectedItem((Object)VoiceGeographicCodePanel.this.NOT_SELECTED_DESTINATION_ITEM);
            this.code.setText(((VoiceGeographicCode)this.data).getCode());
            this.code.setEnabled(((VoiceGeographicCode)this.data).getId() == 0);
            this.codePeriod.setDateFrom(((VoiceGeographicCode)this.data).getDateFrom());
            this.codePeriod.setDateTo(((VoiceGeographicCode)this.data).getDateTo());
            this.destinations.setSelectedItem((Object)this.destinationList.stream().filter(a -> a.getId() == ((VoiceGeographicCode)this.data).getDestinationId()).findFirst().orElse(VoiceGeographicCodePanel.this.NOT_SELECTED_DESTINATION_ITEM));
        }

        public boolean doApply() throws Exception {
            String codeString = this.code.getText();
            if (Utils.isBlankString((String)codeString)) {
                BGToolTip.showErrorMessage((JComponent)this.code, (String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0430!");
                return false;
            }
            VoiceDestination selectedDestination = (VoiceDestination)this.destinations.getSelectedItem();
            if (selectedDestination == null || selectedDestination.equals((Object)VoiceGeographicCodePanel.this.NOT_SELECTED_DESTINATION_ITEM)) {
                BGToolTip.showErrorMessage(this.destinations, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435!");
                return false;
            }
            ((VoiceGeographicCode)this.data).setCode(codeString);
            ((VoiceGeographicCode)this.data).setOperatorId(VoiceGeographicCodePanel.this.getOperatorId());
            ((VoiceGeographicCode)this.data).setDestinationId(((VoiceDestination)this.destinations.getSelectedItem()).getId());
            ((VoiceGeographicCode)this.data).setDestinationTitle(this.destinationsMap.get(((VoiceGeographicCode)this.data).getDestinationId()).getTitle());
            ((VoiceGeographicCode)this.data).setDateFrom(this.codePeriod.getDateFrom());
            ((VoiceGeographicCode)this.data).setDateTo(this.codePeriod.getDateTo());
            int id = ((VoiceService)((ClientContext)VoiceGeographicCodePanel.this.getContext()).getWebService(VoiceService.class)).updateGeographicCode((VoiceGeographicCode)this.data);
            if (((VoiceGeographicCode)this.data).getId() == 0) {
                VoiceGeographicCodePanel.this.loadCodeTree();
            }
            ((VoiceGeographicCode)this.data).setId(id);
            VoiceGeographicCodePanel.this.codeModel.fireTableDataChanged();
            VoiceGeographicCodePanel.this.codeTable.makeVisible(VoiceGeographicCodePanel.this.currentSelectionPath);
            return true;
        }
    }

    class VoiceGeographicRangeImportDiaolog
    extends BGEditorDialog<VoiceGeographicRange> {
        private BGTextArea importData;
        private JCheckBox addDestination;

        public VoiceGeographicRangeImportDiaolog() {
            super("\u0418\u043c\u043f\u043e\u0440\u0442 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u0432", null);
            this.importData = new BGTextArea(20, 50);
            this.addDestination = new JCheckBox("\u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a");
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.importData, (int)800, (int)500), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a: \u043d\u0430\u0447\u0430\u043b\u043e<TAB>\u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435<TAB>\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435[<TAB>mobileId]"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.addDestination, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            if (this.importData.getText().isEmpty()) {
                BGToolTip.showErrorMessage((JComponent)this.importData, (String)"\u041d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430");
                return false;
            }
            int operId = ((VoiceOperator)VoiceGeographicCodePanel.this.operators.getSelectedItem()).getId();
            VoiceGeographicCodePanel.this.getVoiceService().voiceGeographicRangeImport(operId < 0 ? 0 : operId, this.importData.getText(), this.addDestination.isSelected());
            VoiceGeographicCodePanel.this.loadRanges();
            return true;
        }
    }

    class VoiceGeographicRangeEditor
    extends BGEditorDialog<VoiceGeographicRange> {
        private BGTextField rangeFrom;
        private BGTextField rangeTo;
        private BGUComboBox<KeyValue> mobiles;
        private BGUComboBox<VoiceDestination> destinations;
        private List<KeyValue> mobuleList;
        private List<VoiceDestination> destinationList;
        private Map<Integer, VoiceDestination> destinationsMap;

        public VoiceGeographicRangeEditor(String title, VoiceGeographicRange data) {
            super(title, (Object)data);
            this.rangeFrom = new BGTextField(30);
            this.rangeTo = new BGTextField(30);
            this.mobiles = new BGUComboBox();
            this.destinations = new BGUComboBox();
            this.mobuleList = new ArrayList<KeyValue>();
            this.destinationList = new ArrayList<VoiceDestination>();
            this.destinationsMap = new HashMap<Integer, VoiceDestination>();
        }

        public void doDialogPanel() {
            this.rangeFrom.setHorizontalAlignment(0);
            this.rangeFrom.setFont(this.rangeFrom.getFont().deriveFont(this.rangeFrom.getFont().getSize2D() * 1.3f));
            this.rangeTo.setHorizontalAlignment(0);
            this.rangeTo.setFont(this.rangeTo.getFont().deriveFont(this.rangeTo.getFont().getSize2D() * 1.3f));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.rangeFrom, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.rangeTo, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.destinations, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.mobiles, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 0), 0, 0));
            VoiceGeographicCodePanel.this.loadDestinations(this.destinationList, this.destinationsMap);
            this.destinations.setData(this.destinationList);
            this.loadMobileList();
            this.mobiles.setData(this.mobuleList);
            this.rangeFrom.setText(String.valueOf(((VoiceGeographicRange)this.data).getRangeFrom()));
            this.rangeTo.setText(String.valueOf(((VoiceGeographicRange)this.data).getRangeTo()));
            this.destinations.setSelectedItem((Object)this.destinationList.stream().filter(a -> a.getId() == ((VoiceGeographicRange)this.data).getDestinationId()).findFirst().orElse(VoiceGeographicCodePanel.this.NOT_SELECTED_DESTINATION_ITEM));
            this.mobiles.setSelectedItem((Object)this.mobuleList.stream().filter(a -> a.getKey().equals(((VoiceGeographicRange)this.data).getMobileId())).findFirst().orElse(VoiceGeographicCodePanel.this.NOT_SELECTED_MOBILE_ITEM));
        }

        public boolean doApply() throws Exception {
            long r2;
            String from = this.rangeFrom.getText();
            if (!from.matches("^\\d{11}$")) {
                BGToolTip.showErrorMessage((JComponent)this.rangeFrom, (String)"\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u0443 (11 \u0446\u0438\u0444\u0440)");
                return false;
            }
            String to = this.rangeTo.getText();
            if (!to.matches("^\\d{11}$")) {
                BGToolTip.showErrorMessage((JComponent)this.rangeTo, (String)"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0444\u043e\u0440\u043c\u0430\u0442\u0443 (11 \u0446\u0438\u0444\u0440)");
                return false;
            }
            int destId = ((VoiceDestination)this.destinations.getSelectedItem()).getId();
            if (destId < 1) {
                BGToolTip.showErrorMessage(this.destinations, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435");
                return false;
            }
            long r1 = Utils.parseLong((String)from);
            if (r1 > (r2 = Utils.parseLong((String)to))) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0430\u0447\u0430\u043b\u043e \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u0430 \u0431\u043e\u043b\u044c\u0448\u0435 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f");
                return false;
            }
            ((VoiceGeographicRange)this.data).setRangeFrom(r1);
            ((VoiceGeographicRange)this.data).setRangeTo(r2);
            ((VoiceGeographicRange)this.data).setDestinationId(destId);
            ((VoiceGeographicRange)this.data).setMobileId(((KeyValue)this.mobiles.getSelectedItem()).getKey());
            ((VoiceGeographicRange)this.data).setId(VoiceGeographicCodePanel.this.getVoiceService().voiceGeographicRangeUpdate((VoiceGeographicRange)this.data));
            VoiceGeographicCodePanel.this.loadRanges();
            return true;
        }

        void loadMobileList() {
            this.mobuleList.add(0, VoiceGeographicCodePanel.this.NOT_SELECTED_MOBILE_ITEM);
        }
    }
}

