/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.action;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voiceip.server.action.base.ActionBase;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Page;

public class ActionGetDestTable
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        Page page = this.getPage();
        int id = this.getIntParameter("id", -1);
        int mid = this.getIntParameter("mid", -1);
        String mask = this.getParameter("mask", null);
        if (id > 0 && mid > 0) {
            Element table = this.createElement(this.rootNode, "table");
            Element data = this.createElement(table, "data");
            int records = this.getDests(data, mid, id, page, mask);
            page.setRecordCount(records);
            this.setPageAttribute(table, page);
        }
    }

    private int getDests(Element data, int mid, int tariff_id, Page page, String mask) throws SQLException {
        int records = 0;
        String tableName = "voiceip_outgoing_tariff_" + mid;
        if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
            StringBuffer fromBuf = new StringBuffer();
            fromBuf.append(tableName);
            fromBuf.append(" AS t1, voiceip_dest_" + mid + " AS t2 ");
            fromBuf.append("WHERE t1.dest=t2.id and t1.tariff=" + tariff_id);
            if (mask != null && mask.length() > 0) {
                fromBuf.append(" AND t1.prefix REGEXP '" + mask + "' ");
            }
            StringBuffer buf = new StringBuffer();
            buf.append("SELECT COUNT(t1.id) FROM ");
            buf.append(fromBuf.toString());
            PreparedStatement ps = this.con.prepareStatement(buf.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                records = rs.getInt(1);
            }
            rs.close();
            ps.close();
            buf = new StringBuffer();
            buf.append("SELECT t1.id, t2.title, t1.date1, t1.date2, t1.cost, t1.prefix FROM ");
            buf.append(fromBuf.toString());
            buf.append(" ORDER BY t2.title ");
            buf.append(page.sqlLimit());
            ps = this.con.prepareStatement(buf.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                Element element = this.createElement(data, "row");
                element.setAttribute("f0", rs.getString(1));
                element.setAttribute("f1", rs.getString(2));
                element.setAttribute("f2", rs.getString(6));
                element.setAttribute("f3", TimeUtils.formatPeriod((Date)rs.getDate(3), (Date)rs.getDate(4)));
                element.setAttribute("f4", rs.getString(5));
            }
            rs.close();
            ps.close();
        }
        return records;
    }
}

