#!/bin/bash

cd ${0%${0##*/}}.
. ./conf.sh


################################### NAT TABLE
/sbin/iptables -F -t nat
/sbin/iptables --delete-chain $WIFI_CHAIN_NAME -t nat
/sbin/iptables -N $WIFI_CHAIN_NAME -t nat

 
#before wifi chain we must add redirects for authorized users
/sbin/iptables -A PREROUTING  -t nat -p tcp --dport 80 -d $EXTERNAL_IP -j REDIRECT --to-ports $PORTAL_HTTP_PORT 
/sbin/iptables -A PREROUTING  -t nat -p tcp --dport 443 -d $EXTERNAL_IP -j REDIRECT --to-ports $PORTAL_HTTPS_PORT 


#chain for  WiFi  (accept rules for authorized users)
/sbin/iptables -A PREROUTING  -j $WIFI_CHAIN_NAME -t nat

#below is rules for internal not authorized users :

#http
/sbin/iptables -A PREROUTING  -t nat -p tcp --dport 80 -j REDIRECT --to-ports $PORTAL_HTTP_PORT

#https
/sbin/iptables -A PREROUTING -t nat -p tcp --dport 443 -j REDIRECT --to-ports $PORTAL_HTTPS_PORT

#SNAT
iptables -A POSTROUTING -o $EXTERNAL_INTERFACE  -s $WIFI_NET -j SNAT -t nat --to-source $EXTERNAL_IP


################################### FILTER TABLE
/sbin/iptables -F -t filter


############# forward ############################
#here portal inserts rules for each ip

#dns
/sbin/iptables -A FORWARD -t filter -p udp --dport 53 -j ACCEPT
/sbin/iptables -A FORWARD -t filter -p udp --sport 53 -j ACCEPT

#statistics 
/sbin/iptables -A FORWARD -t filter -p tcp --dport 8080 -d $EXTERNAL_IP -j ACCEPT
/sbin/iptables -A FORWARD -t filter -p tcp --sport 8080 -s $EXTERNAL_IP -j ACCEPT


#RST packets for dropping estblished connections
/sbin/iptables -A FORWARD -t filter -p tcp  -j REJECT --reject-with tcp-reset


#deny all
/sbin/iptables -A FORWARD -t filter -j REJECT

############# end of forward ############################
