/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCategory;

public class RegisterCategoryManager {
    private static final String tableName = "register_category";
    private Connection con;

    public RegisterCategoryManager(Connection con) {
        this.con = con;
    }

    public Map<Integer, RegisterCategory> getCategoryMap() throws BGException {
        HashMap<Integer, RegisterCategory> result = new HashMap<Integer, RegisterCategory>();
        String query = "SELECT * FROM register_category";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                RegisterCategory registerCategory = this.getCategoryFromRs(rs);
                result.put(registerCategory.getId(), registerCategory);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<RegisterCategory> list() throws BGException {
        ArrayList<RegisterCategory> categories = new ArrayList<RegisterCategory>();
        String query = "SELECT * FROM register_category ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                categories.add(this.getCategoryFromRs(rs));
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return categories;
    }

    private RegisterCategory getCategoryFromRs(ResultSet rs) throws Exception {
        return new RegisterCategory(rs.getInt("id"), rs.getString("title"));
    }
}

