/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.contract;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractPanel;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.documents.client.contract.DocumentsEditorPanel;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentJournal;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentType;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Period;

public class ContractPanel_Documents
extends ContractPanel {
    private JPanel filterPanel = new JPanel(new GridBagLayout());
    private BGTextField titleFilterTextfield = new BGTextField();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private JButton resetButton = new JButton("\u0421\u0431\u0440\u043e\u0441");
    private JPanel generatePanel = new JPanel(new GridBagLayout());
    private BGComboBox<DocumentPattern> patternComboBox = new BGComboBox();
    private BGComboBox<DocumentJournal> journalComboBox = new BGComboBox();
    private BGComboBox<DocumentType> typeComboBox = new BGComboBox();
    private JButton generateButton = new JButton("\u0421\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c");
    private DocumentTableModel documentsTableModel;
    private DocumentsEditorPanel editorPanel;
    private Directory<UserInfo> userDirectory;
    private Directory<DocumentJournal> journalDirectory;
    private Directory<DocumentType> typeDirectory;
    private ClientContext clientContext = null;

    public ContractPanel_Documents() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.userDirectory = this.getContext().getDirectory(UserInfo.class, 0);
        this.journalDirectory = this.getContext().getDirectory(DocumentJournal.class);
        this.typeDirectory = this.getContext().getDirectory(DocumentType.class);
        this.journalComboBox.setModel(new DefaultComboBoxModel<DocumentJournal>(this.journalDirectory.list().toArray(new DocumentJournal[0])));
        this.typeComboBox.setModel(new DefaultComboBoxModel<DocumentType>(this.typeDirectory.list().toArray(new DocumentType[0])));
        this.editorPanel = new DocumentsEditorPanel(this.getContext(), this);
        this.editorPanel.setVisible(false);
        this.documentsTableModel = new DocumentTableModel(DocumentTableModel.class.getName());
        BGUTable documentsTable = new BGUTable((TableModel)((Object)this.documentsTableModel));
        this.filterPanel.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        this.filterPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.titleFilterTextfield, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.periodPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.filterPanel.add((Component)this.resetButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.generatePanel.setBorder((Border)new BGTitleBorder("\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043f\u043e \u0448\u0430\u0431\u043b\u043e\u043d\u0443"));
        this.generatePanel.add((Component)new JLabel("\u0428\u0430\u0431\u043b\u043e\u043d:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.generatePanel.add((Component)this.patternComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.generatePanel.add((Component)new JLabel("\u0416\u0443\u0440\u043d\u0430\u043b:"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.generatePanel.add((Component)this.journalComboBox, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.generatePanel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.generatePanel.add((Component)this.typeComboBox, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.generatePanel.add((Component)this.generateButton, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(this.filterPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.generatePanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(new JScrollPane((Component)documentsTable), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)((Object)this.editorPanel), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.titleFilterTextfield.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ContractPanel_Documents.this.setData();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ContractPanel_Documents.this.setData();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ContractPanel_Documents.this.setData();
            }
        });
        this.periodPanel.addPropertyChangeListener(evt -> this.setData());
        this.generateButton.addActionListener(actionEvent -> {
            DocumentPattern pattern = (DocumentPattern)this.patternComboBox.getSelectedItem();
            DocumentJournal journal = (DocumentJournal)this.journalComboBox.getSelectedItem();
            DocumentType type = (DocumentType)this.typeComboBox.getSelectedItem();
            if (pattern == null || journal == null || type == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u043e\u0434\u043d\u043e \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439, \u043e\u0442\u043c\u0435\u0447\u0435\u043d\u043d\u044b\u0445 '*'!");
            }
            try {
                List notFillParams = ((DocumentsService)this.getContext().getPort(DocumentsService.class)).checkNotFillParams(this.getContext().getContractId(), pattern.getId(), journal.getId(), type.getId());
                if (notFillParams != null && notFillParams.size() != 0) {
                    Object information = "C\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b: \n";
                    for (int i = 0; i < notFillParams.size(); ++i) {
                        if (i != 0) {
                            information = (String)information + ", \n";
                        }
                        information = (String)information + (String)notFillParams.get(i);
                    }
                    information = (String)information + ". \n\u041f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c?";
                    BGTextArea informationField = new BGTextArea();
                    informationField.setText((String)information);
                    informationField.setEditable(false);
                    informationField.setSize(800, 150);
                    int continueFlag = JOptionPane.showConfirmDialog(this.getRootPane(), new JScrollPane((Component)informationField), "\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043d\u0435\u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u044b", 0);
                    if (continueFlag != 0) {
                        return;
                    }
                }
                ((DocumentsService)this.getContext().getPort(DocumentsService.class)).generateDocument(this.getContext().getContractId(), pattern.getId(), journal.getId(), type.getId());
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        this.resetButton.addActionListener(actionEvent -> {
            this.titleFilterTextfield.setText("");
            this.periodPanel.setPeriod(null);
        });
        documentsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractPanel_Documents.this.editItem();
                }
            }
        });
    }

    public ClientContext getContext() {
        if (this.clientContext == null) {
            this.clientContext = new ClientContext(super.getContext(), "ru.bitel.bgbilling.plugins.documents", -1, null);
        }
        return this.clientContext;
    }

    public void init(ContractEditor editor) {
        super.init(editor);
    }

    public void setData() {
        try {
            Date dateTo;
            Period period = this.periodPanel.getPeriod();
            Date dateFrom = period.getDateFrom();
            if (dateFrom != null) {
                period.setDateFrom(TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)dateFrom));
            }
            if ((dateTo = period.getDateTo()) != null) {
                period.setDateTo(TimeUtils.moveToEndDay((Date)dateTo));
            }
            String title = this.titleFilterTextfield.getText();
            this.documentsTableModel.setData(((DocumentsService)this.getContext().getPort(DocumentsService.class)).getDocumentList(this.getContext().getContractId(), title, period));
            ArrayList<DocumentPattern> availablePatternList = new ArrayList<DocumentPattern>();
            for (DocumentPattern documentPattern : ((DocumentsPatternService)this.getContext().getPort(DocumentsPatternService.class)).getPatternList(this.getContext().getContractId())) {
                if (!documentPattern.isVisibleInPlugin()) continue;
                availablePatternList.add(documentPattern);
            }
            this.patternComboBox.setModel(new DefaultComboBoxModel<DocumentPattern>(availablePatternList.toArray(new DocumentPattern[0])));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void newItem() {
        this.editorPanel.setContractId(this.getContext().getContractId());
        this.editorPanel.setData(null);
        this.editorPanel.setVisible(true);
    }

    public void editItem() {
        this.editorPanel.setContractId(this.getContext().getContractId());
        Document selectedDocument = (Document)this.documentsTableModel.getSelectedRow();
        if (selectedDocument != null) {
            this.editorPanel.setData(selectedDocument);
            this.editorPanel.setVisible(true);
        } else {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
        }
    }

    public void deleteItem() {
        List selectedDocumentList = this.documentsTableModel.getSelectedRows();
        if (selectedDocumentList != null && !selectedDocumentList.isEmpty()) {
            ArrayList<Integer> docIds = new ArrayList<Integer>();
            for (Document doc : selectedDocumentList) {
                docIds.add(doc.getId());
            }
            try {
                if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442(\u044b)?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 0) == 0) {
                    ((DocumentsService)this.getContext().getPort(DocumentsService.class)).deleteDocument(docIds);
                    this.setData();
                    this.editorPanel.setVisible(false);
                }
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
        }
    }

    class DocumentTableModel
    extends BGTableModel<Document> {
        public DocumentTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumn("\u0416\u0443\u0440\u043d\u0430\u043b", 50, 100, 250, "journal", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", -1, 200, 500, "type", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f", 100, 150, 200, "createDate", false, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss", 0));
            this.addColumn("\u0414\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", 100, 200, 250, "lastModifyDate", false, (TableCellRenderer)new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss", 0));
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 50, 150, 200, "user", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }

        public Object getValue(Document val, int column) {
            Object result = null;
            try {
                switch (column) {
                    case 0: {
                        DocumentJournal journal = (DocumentJournal)ContractPanel_Documents.this.journalDirectory.get(val.getJournalId());
                        result = journal != null ? journal.getTitle() : "<\u0416\u0443\u0440\u043d\u0430\u043b \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                        break;
                    }
                    case 1: {
                        DocumentType type = (DocumentType)ContractPanel_Documents.this.typeDirectory.get(val.getTypeId());
                        result = type != null ? type.getTitle() : "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                        break;
                    }
                    case 5: {
                        UserInfo user = (UserInfo)ContractPanel_Documents.this.userDirectory.get(val.getUserId());
                        result = user != null ? user.getName() : "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>";
                        break;
                    }
                    default: {
                        result = super.getValue((Object)val, column);
                        break;
                    }
                }
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            return result;
        }
    }
}

