/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.tasks;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.CostSum;
import bitel.billing.server.contract.bean.ServiceCostCache;
import bitel.billing.server.tariff.TariffModuleTree;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.bgbilling.modules.drweb.common.bean.TariffAVD;
import ru.bitel.bgbilling.modules.drweb.server.bean.AgentAVDManager;
import ru.bitel.bgbilling.modules.drweb.server.bean.TariffAVDManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Calculator
extends TaskBase {
    private Calendar startMonth;
    private Calendar endMonth;
    private String cids;
    private PeriodicErrorManager errorManager;

    protected boolean initTask() {
        this.startMonth = (Calendar)this.getOperatingTime().clone();
        this.startMonth.add(11, -1);
        this.startMonth.set(5, 1);
        this.startMonth.set(11, 0);
        this.endMonth = TimeUtils.getEndMonth((Calendar)this.startMonth);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try (BalanceUtils bu = new BalanceUtils(con);
             ContractManager contractManager = new ContractManager(con);
             TariffAVDManager tariffAVDManager = new TariffAVDManager(con, this.moduleId);){
            AgentAVDManager agentAVDManager = new AgentAVDManager(con, this.moduleId);
            this.errorManager = new PeriodicErrorManager(con);
            this.errorManager.initErrorMessage(this.moduleId, "drweb", String.valueOf(this.moduleId), this.startMonth.getTime());
            ServiceCostCache costCache = new ServiceCostCache();
            List<AgentAVD> agentList = this.getAgentList(agentAVDManager);
            for (AgentAVD agent : agentList) {
                if (agent.isGraceperiod()) continue;
                TariffAVD tariffAVD = (TariffAVD)tariffAVDManager.get(agent.getTariffId());
                if (tariffAVD == null) {
                    this.getLogger().error("Not find drweb tariff => " + agent.getTariffId() + " for agent => " + agent.getId());
                    continue;
                }
                TariffRequest request = new TariffRequest();
                int sid = agent.isNewAgent() && tariffAVD.getSidForNew() != -1 ? tariffAVD.getSidForNew() : tariffAVD.getSid();
                request.setRequestParam("sid", (Object)sid);
                request.setRequestParam("tariff_id", (Object)tariffAVD.getId());
                Float cost = null;
                Calendar startDate = (Calendar)this.startMonth.clone();
                Calendar endDate = TimeUtils.getEndMonth((Calendar)this.startMonth);
                TariffTreeSet tariffTreeSet = contractManager.getRealtimeTariffTreeSet(agent.getContractId(), this.endMonth, "drweb", this.moduleId, true);
                while (TimeUtils.dateBeforeOrEq((Calendar)startDate, (Calendar)endDate)) {
                    request.setRequestParam("time", (Object)startDate);
                    for (TariffModuleTree tree : tariffTreeSet.getTreeList(startDate)) {
                        tree.processRequest(request);
                        cost = (Float)request.getResponseParam("cost");
                        if (cost == null) continue;
                        break;
                    }
                    if (cost != null) break;
                    startDate.add(6, 1);
                }
                if (cost == null) {
                    if (this.errorManager.isCapReached()) continue;
                    String subject = "\u041e\u0448\u0438\u0431\u043a\u0430! \u0426\u0435\u043d\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u0435!";
                    String text = "\u0412\u043e\u0437\u043d\u0438\u043a\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0435\u0440\u0435\u043e\u0431\u0441\u0447\u0435\u0442\u0435 (\u0434\u043e\u0433\u043e\u0432\u043e\u0440 " + agent.getContractId() + " agentId=" + agent.getId() + " ):  \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d. \n" + request.toString();
                    this.errorManager.addErrorToList(subject, text);
                    this.getLogger().error("Wrong tariff response: " + request.toString());
                    continue;
                }
                this.getLogger().debug("getContractId=>" + agent.getContractId() + "; agentId=>" + agent.getId() + "; cost=" + cost);
                CostSum costSum = new CostSum(agent.getContractId(), sid, BigDecimal.valueOf(cost.floatValue()));
                costCache.addAmount(costSum);
            }
            String moduleServices = ModuleCache.getInstance().getModuleServicesString(this.moduleId);
            bu.setAccount(con, this.getLogger(), this.startMonth, costCache, moduleServices, this.cids, null);
        }
        catch (Exception e) {
            this.getLogger().error((Object)e);
            this.error = e;
        }
        finally {
            this.errorManager.deleteErrorsByMarker(String.valueOf(this.moduleId), this.startMonth.getTime());
            this.errorManager.processErrors();
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private List<AgentAVD> getAgentList(AgentAVDManager agentAVDManager) throws BGException {
        ArrayList<AgentAVD> agentList;
        if (this.cids == null) {
            agentList = agentAVDManager.getListWithStatus(1, this.startMonth);
        } else {
            agentList = new ArrayList();
            Iterator iterator = Utils.toIntegerList((String)this.cids).iterator();
            while (iterator.hasNext()) {
                int cid = (Integer)iterator.next();
                List<AgentAVD> list = agentAVDManager.getListById(cid, this.startMonth);
                for (AgentAVD agent : list) {
                    if (agent.getStatus() != 1) continue;
                    agentList.add(agent);
                }
            }
        }
        return agentList;
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c DrWeb. \u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ". \u0417\u0430 \u043c\u0435\u0441\u044f\u0446: " + TimeUtils.format((Calendar)this.startMonth, (String)"yyyy.MM");
    }

    public void setCids(String cids) {
        this.cids = cids;
    }
}

