/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.fias.server.service;

import jakarta.jws.WebService;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.plugins.fias.common.bean.Constant;
import ru.bitel.bgbilling.plugins.fias.common.bean.Region;
import ru.bitel.bgbilling.plugins.fias.common.bean.StartData;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.City;
import ru.bitel.bgbilling.plugins.fias.common.bean.bgbean.Street;
import ru.bitel.bgbilling.plugins.fias.common.service.FiasService;
import ru.bitel.bgbilling.plugins.fias.server.bean.AddressLoadManager;
import ru.bitel.bgbilling.plugins.fias.server.task.RegionLoadTask;
import ru.bitel.bgbilling.plugins.fias.server.util.FiasUtil;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.fias.common.service.FiasService")
public class FiasServiceImpl
extends AbstractService
implements FiasService {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static Map<Integer, Future<Integer>> futures = new HashMap<Integer, Future<Integer>>();

    void destroy() {
    }

    private AddressLoadManager getFiasAddressManager(Connection con) {
        return new AddressLoadManager(con);
    }

    public Result<Region> getRegions() throws BGMessageException, BGException {
        try {
            Path dir = FiasUtil.getFiasPath("");
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new BGMessageException("\u041f\u0443\u0442\u044c \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442 \u043d\u0435 \u043d\u0430 \u043a\u0430\u0442\u0430\u043b\u043e\u0433 ");
            }
            List<Object> list = new ArrayList();
            try (DirectoryStream<Path> directoryStream2 = Files.newDirectoryStream(dir);){
                for (Path path : directoryStream2) {
                    if (!path.getFileName().toString().startsWith("ADDROB")) continue;
                    String regStr = path.getFileName().toString().substring(6, 8);
                    list.add(new Region(regStr, "[" + regStr + "]" + (String)Constant.stateCod.get(regStr)));
                }
            }
            catch (IOException directoryStream2) {
                // empty catch block
            }
            list = list.stream().sorted((f1, f2) -> Integer.compare(Integer.parseInt(f1.getNumber()), Integer.parseInt(f2.getNumber()))).collect(Collectors.toList());
            Result res2 = new Result();
            res2.setList(list);
            return res2;
        }
        catch (Exception ex) {
            throw new BGException(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public String loadRegion(String regionId) throws BGMessageException, BGException {
        int rId = Integer.parseInt(regionId);
        Future<Integer> loadTask = futures.get(rId);
        if (loadTask != null && !loadTask.isDone()) {
            return "\u0412\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u0430 \u043d\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 " + regionId + " \u0440\u0435\u0433\u0438\u043e\u043d\u0430";
        }
        futures.put(rId, executor.submit(new RegionLoadTask(regionId)));
        return "\u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0443 " + regionId + " \u0440\u0435\u0433\u0438\u043e\u043d\u0430 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c.";
    }

    public StartData getStartData() throws BGMessageException, BGException {
        StartData res = new StartData();
        List<Region> regionList = FiasUtil.getLoadedRegion();
        res.setRegionList(regionList);
        AddressLoadManager fm = this.getFiasAddressManager(this.getConnection());
        List<City> cityList = fm.getCityFromBG();
        res.setCityList(cityList);
        return res;
    }

    public Result<City> getRegionCity(String regionId, String cityTitle) throws BGMessageException, BGException {
        List<City> list = FiasUtil.getRegionCity(regionId, cityTitle);
        return new Result(list);
    }

    public Result<Street> startSync(String regionId, City city, boolean newLoad) throws BGMessageException, BGException {
        AddressLoadManager fm = this.getFiasAddressManager(this.getConnection());
        Result result = new Result(new ArrayList());
        if (fm.loadInProcess() && !newLoad) {
            result.setAttribute("loadInProgress", (Object)true);
            return result;
        }
        fm.clearFiasTable();
        result.setAttribute("loadInProgress", (Object)false);
        FiasUtil.setParentsForCity(city);
        fm.updateCity(city);
        FiasUtil.createTempStreetTable(regionId, city, fm);
        return result;
    }

    public Result<Street> streetSync(int cityId, Street street) throws BGMessageException, BGException {
        List<Street> find;
        Street nextStreet;
        try {
            Connection con = this.getConnection();
            AddressLoadManager fm = this.getFiasAddressManager(con);
            if (street != null) {
                fm.updateStreet(street);
            }
            while (true) {
                if ((nextStreet = fm.getNextEmptyBillingStreet(cityId)) == null) {
                    con.commit();
                    throw new BGMessageException("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0443\u043b\u0438\u0446 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u0430");
                }
                find = fm.findStreetInFias(nextStreet);
                if (find.size() == 1) {
                    Street fiasStreet = find.get(0);
                    nextStreet.setStreet(fiasStreet);
                    fm.updateStreet(nextStreet);
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new BGException(e.getLocalizedMessage(), (Throwable)e);
        }
        Result result = new Result(find);
        result.setAttribute("street", (Object)nextStreet);
        return result;
    }

    public String loadAllStreet(City city) throws BGMessageException, BGException {
        String result = "\u0423\u043b\u0438\u0446\u044b \u043d\u0435 \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u044b";
        try {
            Connection con = this.getConnection();
            AddressLoadManager fm = this.getFiasAddressManager(con);
            fm.addAllTempStreet(city);
        }
        catch (SQLException e) {
            throw new BGException(e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }
}

