/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common.cache;

import bitel.billing.common.cache.CacheItem;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.common.XMLUtils;

public class CacheManagerClient {
    private static CacheManagerClient cacheManager = null;
    private Map<String, CacheItem> cacheMap = new HashMap<String, CacheItem>();

    private CacheManagerClient() {
    }

    public static CacheManagerClient getCacheManager() {
        if (cacheManager == null) {
            cacheManager = new CacheManagerClient();
        }
        return cacheManager;
    }

    public long getVersion(String key) {
        CacheItem item = this.get(key);
        if (item != null) {
            return item.getVersion();
        }
        return 0L;
    }

    public boolean removeDocument(String key) {
        boolean result = false;
        if (key != null) {
            CacheItem cacheItem = this.cacheMap.remove(key);
            result = cacheItem != null;
        }
        return result;
    }

    private CacheItem get(String key) {
        CacheItem cacheItem = null;
        if (key != null) {
            cacheItem = this.cacheMap.get(key);
        }
        return cacheItem;
    }

    private void put(CacheItem cacheItem) {
        if (cacheItem != null) {
            this.cacheMap.put(cacheItem.getKey(), cacheItem);
        }
    }

    public Document getDocument(Document doc, String key) {
        if (doc == null) {
            return this.get(key).getDocument();
        }
        long ourVersion = this.getVersion(key);
        for (Element item : XMLUtils.selectElements(doc.getDocumentElement(), "cache_directory/document")) {
            String itemKey = item.getAttribute("key");
            if (!itemKey.equals(key)) continue;
            long version = Long.valueOf(item.getAttribute("version"));
            if (ourVersion != version) {
                CacheItem cacheItem = new CacheItem();
                cacheItem.setKey(key);
                cacheItem.setVersion(version);
                Node cacheData = item.getFirstChild();
                Document cacheDoc = XMLUtils.newDocument();
                cacheDoc.appendChild(cacheDoc.importNode(cacheData, true));
                cacheItem.setDocument(cacheDoc);
                this.put(cacheItem);
            }
            return this.get(key).getDocument();
        }
        return null;
    }
}

