/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.CalendarPanelWithTime;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.BGUAction;
import ru.bitel.common.client.LookAndFeelUtils;

public class BGCalendarWithTimeButton
extends JToggleButton
implements PropertyChangeListener,
PopupMenuListener {
    private Calendar oldDateCalendar;
    private int columns = 0;
    private int columnWidth = 0;
    private Calendar calendar;
    private DateFormat df = new SimpleDateFormat("dd.MM.yyyy HH:mm");
    private static Popup popup;
    private final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Calendar calendar;
            int amount;
            int field;
            if ("common.calendarButton.date.next".equals(e.getActionCommand())) {
                field = 5;
                amount = 1;
            } else if ("common.calendarButton.date.prev".equals(e.getActionCommand())) {
                field = 5;
                amount = -1;
            } else if ("common.calendarButton.month.next".equals(e.getActionCommand())) {
                field = 2;
                amount = 1;
            } else if ("common.calendarButton.month.prev".equals(e.getActionCommand())) {
                field = 2;
                amount = -1;
            } else if ("common.calendarButton.year.next".equals(e.getActionCommand())) {
                field = 1;
                amount = 1;
            } else if ("common.calendarButton.year.prev".equals(e.getActionCommand())) {
                field = 1;
                amount = -1;
            } else {
                if ("common.calendarButton.now".equals(e.getActionCommand())) {
                    BGCalendarWithTimeButton.this.setCalendar(new GregorianCalendar());
                    BGCalendarWithTimeButton.this.repaint();
                    return;
                }
                if ("common.calendarButton.clear".equals(e.getActionCommand())) {
                    BGCalendarWithTimeButton.this.setCalendar(null);
                    BGCalendarWithTimeButton.this.repaint();
                    return;
                }
                return;
            }
            if (BGCalendarWithTimeButton.this.calendar == null) {
                calendar = new GregorianCalendar();
            } else {
                calendar = (Calendar)BGCalendarWithTimeButton.this.calendar.clone();
                calendar.add(field, amount);
            }
            BGCalendarWithTimeButton.this.setCalendar(calendar);
            BGCalendarWithTimeButton.this.repaint();
        }
    };

    public BGCalendarWithTimeButton() {
        try {
            this.setMargin(new Insets(2, 5, 2, 5));
            this.setColumns(11);
            this.jbInit();
            this.setFocusPainted(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() {
        this.setActionCommand("popup");
        this.addActionListener(e -> this.setPopupVisible(true));
        ActionMap actionMap = this.getActionMap();
        actionMap.put("common.calendarButton.date.next", new BGUAction("common.calendarButton.date.next", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGCalendarWithTimeButton.this.actionListener.actionPerformed(e);
            }
        });
        actionMap.put("common.calendarButton.date.prev", new BGUAction("common.calendarButton.date.prev", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGCalendarWithTimeButton.this.actionListener.actionPerformed(e);
            }
        });
        actionMap.put("common.calendarButton.month.next", new BGUAction("common.calendarButton.month.next", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGCalendarWithTimeButton.this.actionListener.actionPerformed(e);
            }
        });
        actionMap.put("common.calendarButton.month.prev", new BGUAction("common.calendarButton.month.prev", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGCalendarWithTimeButton.this.actionListener.actionPerformed(e);
            }
        });
        actionMap.put("common.calendarButton.now", new BGUAction("common.calendarButton.now", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGCalendarWithTimeButton.this.actionListener.actionPerformed(e);
            }
        });
        actionMap.put("common.calendarButton.clear", new BGUAction("common.calendarButton.clear", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGCalendarWithTimeButton.this.actionListener.actionPerformed(e);
            }
        });
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(39, 128), "common.calendarButton.date.next");
        inputMap.put(KeyStroke.getKeyStroke(37, 128), "common.calendarButton.date.prev");
        inputMap.put(KeyStroke.getKeyStroke(38, 128), "common.calendarButton.month.next");
        inputMap.put(KeyStroke.getKeyStroke(40, 128), "common.calendarButton.month.prev");
        inputMap.put(KeyStroke.getKeyStroke(155, 128), "common.calendarButton.now");
        inputMap.put(KeyStroke.getKeyStroke(127, 128), "common.calendarButton.clear");
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("updateCalendar".equals(propertyName)) {
            this.setPopupVisible(false);
            this.setCalendar(popup.getCalendar() == null ? null : (Calendar)popup.getCalendar().clone());
            this.firePropertyChange("updateCalendar", this.oldDateCalendar, this.calendar);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.getModel().setSelected(false);
        this.getModel().setPressed(false);
        BGCalendarWithTimeButton.popup.calendarPanel.removePropertyChangeListener(this);
        popup.removePopupMenuListener(this);
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        int oldVal = this.columns;
        if (columns != oldVal) {
            this.columns = columns;
            this.invalidate();
        }
    }

    protected int getColumnWidth() {
        if (this.columnWidth == 0) {
            FontMetrics metrics = this.getFontMetrics(this.getFont());
            this.columnWidth = metrics.charWidth('m');
        }
        return this.columnWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.columns != 0) {
            Insets insets = this.getInsets();
            size.width = this.columns * this.getColumnWidth() + insets.left + insets.right;
        }
        size.height = LookAndFeelUtils.BUTTON_HEIGHT.get();
        return size;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setPopupVisible(boolean visible) {
        if (visible) {
            Calendar c;
            Calendar calendar = c = this.calendar != null ? this.calendar : new GregorianCalendar();
            if (popup.getCalendar() == null || !BGCalendarWithTimeButton.dateEqual(c, popup.getCalendar())) {
                popup.setCalendar(c);
            }
            BGCalendarWithTimeButton.popup.calendarPanel.addPropertyChangeListener(this);
            popup.addPopupMenuListener(this);
            popup.show(this, 0, this.getHeight() + 1);
            Component comp = BGCalendarWithTimeButton.popup.calendarPanel.getDateField().getComponent(1);
            if (comp != null) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().downFocusCycle();
                comp.requestFocus();
            }
        } else {
            popup.setVisible(false);
        }
    }

    public void setCalendar(Calendar calendar) {
        this.oldDateCalendar = this.calendar == null ? null : (Calendar)this.calendar.clone();
        this.setOnlyCalendar(calendar);
    }

    @Override
    public void setText(String text) {
        this.setCalendar(TimeUtils.convertStringToCalendar(text, "dd.MM.yyyy HH:mm"));
        BGCalendarWithTimeButton.popup.calendarPanel.setCalendarView();
    }

    private void setOnlyCalendar(Calendar calendar) {
        this.calendar = calendar;
        if (calendar != null) {
            super.setText(this.df.format(calendar.getTime()));
        } else {
            super.setText("");
        }
    }

    public void undoCalendar() {
        this.setOnlyCalendar(this.oldDateCalendar);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public String getText() {
        return this.calendar != null ? this.df.format(this.calendar.getTime()) : " ";
    }

    private static boolean dateEqual(Calendar date1, Calendar date2) {
        return date1.get(6) == date2.get(6) && date1.get(1) == date2.get(1) && date1.get(0) == date2.get(0);
    }

    static {
        Popup cp = null;
        try {
            cp = new Popup();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        popup = cp;
        UIManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("lookAndFeel".equals(evt.getPropertyName())) {
                    SwingUtilities.updateComponentTreeUI(popup);
                }
            }
        });
    }

    private static class Popup
    extends JPopupMenu {
        private CalendarPanelWithTime calendarPanel = new CalendarPanelWithTime();

        public Popup() {
            try {
                this.calendarPanel.setVisibleLabelDate(false);
                this.calendarPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.setLayout(new BorderLayout());
                this.add("Center", this.calendarPanel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Calendar getCalendar() {
            return this.calendarPanel.getCalendar();
        }

        public void setCalendar(Calendar calendar) {
            this.calendarPanel.setCalendar(calendar);
        }
    }
}

