/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common;

import bitel.billing.module.common.BGPopup;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.Document;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class BGControlPanelMonthAndDays
extends JPanel {
    private DateTimeFormatter format = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private int maxDay = 1;
    private LocalDate date = LocalDate.now();
    private LocalDate beginDate;
    private LocalDate endDate;
    private int beginDay;
    private int endDay;
    private IntTextField fromDay = new IntTextField();
    private IntTextField toDay = new IntTextField();
    private BGButton decMonth = new BGButton();
    private BGButton addMonth = new BGButton();
    private BGButton monthYearButton = new BGButton();
    private boolean inRow = false;
    private BGPopup popup = null;
    private Vector<ActionListener> listeners = new Vector();

    public BGControlPanelMonthAndDays() {
        this(false);
    }

    public BGControlPanelMonthAndDays(boolean inRow) {
        this.inRow = inRow;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDate(LocalDate.now());
        Dimension dimension = this.monthYearButton.getPreferredSize();
        dimension.width = 150;
        this.monthYearButton.setPreferredSize(dimension);
        this.monthYearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BGControlPanelMonthAndDays.this.setPopupVisible(true);
            }
        });
    }

    private void jbInit() throws Exception {
        ActionListener monthActionListener = e -> this.month_actionPerformed(Integer.parseInt(e.getActionCommand()));
        this.addMonth.setIcon(ClientUtils.getIcon("to_next.gif"));
        this.addMonth.setText("");
        this.addMonth.setActionCommand("1");
        this.addMonth.addActionListener(monthActionListener);
        this.decMonth.setIcon(ClientUtils.getIcon("to_prev.gif"));
        this.decMonth.setText("");
        this.decMonth.setActionCommand("-1");
        this.decMonth.addActionListener(monthActionListener);
        this.fromDay.setColumns(5);
        this.fromDay.setHorizontalAlignment(0);
        this.fromDay.setMaxValue(31L);
        this.fromDay.setMinValue(1L);
        this.toDay.setColumns(5);
        this.toDay.setHorizontalAlignment(0);
        this.toDay.setMaxValue(31L);
        this.toDay.setMinValue(1L);
        JPanel daysPanel = new JPanel(new GridBagLayout());
        daysPanel.add((Component)new JLabel("\u0434\u043d\u0438: c "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        daysPanel.add((Component)this.fromDay, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        daysPanel.add((Component)new JLabel(" \u043f\u043e "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        daysPanel.add((Component)this.toDay, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        if (this.inRow) {
            this.add((Component)this.decMonth, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.monthYearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.addMonth, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)daysPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.add((Component)this.decMonth, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.add((Component)this.monthYearButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)this.addMonth, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            this.add((Component)daysPanel, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 13, 3, new Insets(5, 0, 5, 0), 0, 0));
        }
    }

    private void month_actionPerformed(int step) {
        if (step != 0) {
            this.date = this.date.plusMonths(step);
            this.setDate(this.date);
            this.fireActionPerformed();
        }
    }

    public void setBeginDay(int beginDay) {
        int n = this.beginDay = beginDay >= 1 && beginDay <= this.maxDay ? beginDay : 1;
        if (this.beginDay == 1) {
            try {
                Document doc = this.fromDay.getDocument();
                doc.remove(0, doc.getLength());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.fromDay.setValue(this.beginDay);
        }
    }

    public void setEndDay(int endDay) {
        int n = this.endDay = endDay >= this.beginDay && endDay <= this.maxDay ? endDay : this.maxDay;
        if (this.endDay == this.maxDay) {
            try {
                Document doc = this.toDay.getDocument();
                doc.remove(0, doc.getLength());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.toDay.setValue(this.endDay);
        }
    }

    public LocalDate getBeginDate() {
        if (this.date != null) {
            int value = Utils.parseInt(this.fromDay.getText(), 0);
            this.beginDay = value >= 1 && value <= this.maxDay ? value : 1;
            this.beginDate = this.date;
            this.beginDate = this.beginDate.withDayOfMonth(this.beginDay);
        }
        return this.beginDate;
    }

    public String getBeginDateToString(DateTimeFormatter dateFormat) {
        return this.getDateToString(this.getBeginDate(), dateFormat);
    }

    public LocalDate getEndDate() {
        if (this.date != null) {
            int value = Utils.parseInt(this.toDay.getText(), 0);
            this.endDay = value >= this.beginDay && value <= this.maxDay ? value : this.maxDay;
            this.endDate = this.date;
            this.endDate = this.endDate.withDayOfMonth(this.endDay);
        }
        return this.endDate;
    }

    public String getEndDateToString(DateTimeFormatter dateFormat) {
        return this.getDateToString(this.getEndDate(), dateFormat);
    }

    public String getDateString1() {
        LocalDate date = this.getBeginDate();
        return date == null ? "" : this.format.format(date);
    }

    public String getDateString2() {
        LocalDate date = this.getEndDate();
        return date == null ? "" : this.format.format(date);
    }

    public void setDate(LocalDate date) {
        this.date = date;
        if (date != null) {
            this.maxDay = date.plusMonths(1L).withDayOfMonth(1).minusDays(1L).getDayOfMonth();
            this.monthYearButton.setText(DateTimeFormatter.ofPattern("LLLL yyyy").format(date));
        }
    }

    protected String getDateToString(LocalDate date, DateTimeFormatter dateFormat) {
        String result = null;
        if (dateFormat != null && date != null) {
            result = dateFormat.format(date);
        }
        return result;
    }

    public void addActionListener(ActionListener l) {
        this.fromDay.addActionListener(l);
        this.toDay.addActionListener(l);
        this.listeners.addElement(l);
    }

    private void fireActionPerformed() {
        ActionEvent e = new ActionEvent(this, 0, "");
        for (ActionListener l : this.listeners) {
            l.actionPerformed(e);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.fromDay.removeActionListener(l);
        this.toDay.removeActionListener(l);
        this.listeners.remove(l);
    }

    public Period getPeriod() {
        return new Period(this.getBeginDate(), this.getEndDate());
    }

    public void setPopupVisible(boolean visible) {
        if (visible) {
            this.popup = new BGPopup();
            this.popup.addPropertyChangeListener(new MYPropertyChangeListener());
            this.popup.setLocalDate(this.date == null ? LocalDate.now() : this.date);
            this.popup.show(this.decMonth, 0, this.decMonth.getHeight() + 1);
        } else if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup = null;
        }
    }

    private class MYPropertyChangeListener
    implements PropertyChangeListener {
        private MYPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getPropertyName();
            if ("currentSelectDate".equals(propertyName)) {
                BGControlPanelMonthAndDays.this.setDate((LocalDate)event.getNewValue());
            } else if ("selectDate".equals(propertyName)) {
                BGControlPanelMonthAndDays.this.setDate((LocalDate)event.getNewValue());
                BGControlPanelMonthAndDays.this.fireActionPerformed();
            }
        }
    }
}

