/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import javax.swing.text.TextAction;
import ru.bitel.common.Utils;

public class BGMaskTextField
extends JPanel
implements SwingConstants {
    private static final int TAB_NEXT = 1;
    private static final int TAB_PREVIOUS = -1;
    private static final Color DEFAULT_MASK_COLOR = Color.gray;
    private static final boolean DEFAULT_DISPLAY_PARTIAL_MASK = true;
    protected String delimiters;
    private boolean showToolTip = false;
    private Color maskColor = DEFAULT_MASK_COLOR;
    private boolean displayPartialMask = true;
    private MaskTextFieldItem firstField = null;
    private MaskTextFieldItem lastField = null;
    protected List<MaskTextFieldItem> maskTextFields = new ArrayList<MaskTextFieldItem>();
    private StringBuilder text = new StringBuilder(16);
    private int compCount = 0;
    private int fieldCount = 0;

    public BGMaskTextField(String mask, String delimiters) {
        this(mask, delimiters, (FieldValidator[])null, (Format[])null);
    }

    public BGMaskTextField(String mask, String delimiters, FieldValidator validator) {
        this(mask, delimiters, validator, null);
    }

    public BGMaskTextField(String mask, String delimiters, FieldValidator ... validators) {
        this(mask, delimiters, (FieldValidator)null, validators, (Format[])null);
    }

    public BGMaskTextField(String mask, String delimiters, FieldValidator[] validators, Format[] constraints) {
        this(mask, delimiters, null, validators, constraints);
    }

    protected void createLeftBox(int gridx) {
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createRightBox(int gridx) {
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public BGMaskTextField(String mask, String delimiters, FieldValidator validator, FieldValidator[] validators, Format[] constraints) {
        this.setLayout(new GridBagLayout());
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.createLeftBox(this.compCount++);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                e.consume();
                int x = e.getX();
                JComponent prev = null;
                for (MaskTextFieldItem item : BGMaskTextField.this.maskTextFields) {
                    if (item.getX() >= x) {
                        if (prev != null && x <= prev.getX() + prev.getWidth()) {
                            prev.requestFocus();
                        } else {
                            item.requestFocus();
                        }
                        return;
                    }
                    prev = item;
                }
                prev.requestFocus();
            }
        });
        this.delimiters = delimiters;
        this.setBorder(null);
        this.setBackground(null);
        StringTokenizer st = new StringTokenizer(mask, delimiters, true);
        int tokenCount = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (delimiters.indexOf(token) == -1) {
                Format gbc = constraints != null && tokenCount < constraints.length ? constraints[tokenCount] : null;
                FieldValidator fv = validator != null ? validator : (validators != null && tokenCount < validators.length ? validators[tokenCount] : null);
                this.addTextField(token, fv, gbc);
                ++tokenCount;
                continue;
            }
            this.addLabel(token);
        }
        this.createRightBox(this.compCount++);
        Dimension dim = this.getPreferredSize();
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("PressEnterByMaskTextField")) {
                    BGMaskTextField.this.firePropertyChange("PressEnterByMaskTextField", null, null);
                }
            }
        };
        for (MaskTextFieldItem item : this.maskTextFields) {
            item.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void setCopyPasteCutAll(final String dataOnCut) {
        TextAction actionCopy = new TextAction("copy-to-clipboard"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection contents = new StringSelection(BGMaskTextField.this.getText());
                BGMaskTextField.this.getToolkit().getSystemClipboard().setContents(contents, null);
            }
        };
        TextAction actionPast = new TextAction("paste-from-clipboard"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    BGMaskTextField.this.setText((String)BGMaskTextField.this.getToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                FocusManager.getCurrentManager().focusNextComponent(BGMaskTextField.this.lastField);
            }
        };
        TextAction actionCut = new TextAction("cut-to-clipboard"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StringSelection contents = new StringSelection(BGMaskTextField.this.getText());
                BGMaskTextField.this.getToolkit().getSystemClipboard().setContents(contents, null);
                BGMaskTextField.this.setText(dataOnCut);
                BGMaskTextField.this.firstField.requestFocus();
            }
        };
        for (MaskTextFieldItem item : this.maskTextFields) {
            item.getActionMap().put("copy-to-clipboard", actionCopy);
            item.getActionMap().put("paste-from-clipboard", actionPast);
            item.getActionMap().put("cut-to-clipboard", actionCut);
        }
    }

    public void setHorizontalAlignment(int aligment) {
        for (MaskTextFieldItem item : this.maskTextFields) {
            item.setHorizontalAlignment(aligment);
        }
    }

    public void setHorizontalAlignment(int fieldNum, int aligment) {
        this.maskTextFields.get(fieldNum).setHorizontalAlignment(aligment);
    }

    @Override
    public void setBorder(Border b) {
        super.setBorder(UIManager.getBorder("TextField.border"));
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(UIManager.getColor("TextField.background"));
    }

    @Override
    public Dimension getPreferredSize() {
        Insets ins;
        Dimension dim = super.getPreferredSize();
        Border border = this.getBorder();
        if (border != null && (ins = this.getBorder().getBorderInsets(this)) != null) {
            dim.width += ins.left + ins.right;
        }
        return dim;
    }

    @Override
    public final Component add(Component comp) {
        return this.add(comp, null);
    }

    public final Component add(Component comp, Format constraints) {
        if (comp instanceof MaskTextFieldItem) {
            MaskTextFieldItem m = (MaskTextFieldItem)comp;
            if (this.firstField == null) {
                this.firstField = m;
                this.firstField.setFont(this.getFont());
            }
            this.lastField = m;
            this.lastField.setFont(this.getFont());
            if (constraints != null) {
                m.setHorizontalAlignment(constraints.align);
            }
            if (constraints == null) {
                super.add(comp, new GridBagConstraints(this.compCount++, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                super.add(comp, new GridBagConstraints(this.compCount++, 0, 1, 1, constraints.weightx, constraints.weighty, 10, constraints.fill == 0 ? 3 : constraints.fill, constraints.insets == null ? new Insets(0, 0, 0, 0) : constraints.insets, 0, 0));
            }
        } else {
            super.add(comp, new GridBagConstraints(this.compCount++, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }
        return comp;
    }

    private MaskTextFieldItem addTextField(String mask, FieldValidator validator, Format constraints) {
        MaskTextFieldItem textField = new MaskTextFieldItem(mask.length(), mask, this.fieldCount++, validator, constraints != null ? constraints.autoSize : false);
        textField.setParent(this);
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                JTextField textField = (JTextField)e.getSource();
                if ((e.getModifiersEx() & 0x280) == 0) {
                    switch (e.getKeyCode()) {
                        case 38: {
                            BGMaskTextField.this.tab(textField, 1);
                            break;
                        }
                        case 40: {
                            BGMaskTextField.this.tab(textField, -1);
                            break;
                        }
                        case 39: {
                            if (textField.getCaretPosition() != textField.getDocument().getLength()) break;
                            BGMaskTextField.this.tab(textField, 1);
                            e.consume();
                            break;
                        }
                        case 37: {
                            if (textField.getCaretPosition() != 0) break;
                            BGMaskTextField.this.tab(textField, -1);
                            e.consume();
                        }
                    }
                }
            }
        });
        if (this.maskTextFields.size() == 0) {
            textField.setFocusTraversable(true);
        }
        this.maskTextFields.add(textField);
        this.add((Component)textField, constraints);
        return textField;
    }

    private JLabel addLabel(String delimiter) {
        JLabel label = new JLabel(delimiter);
        this.add(label);
        label.setFont(null);
        return label;
    }

    public void setText(String delimitedData) {
        if (Utils.isEmptyString(delimitedData)) {
            this.clear();
        } else {
            StringTokenizer st = new StringTokenizer(delimitedData, this.delimiters, true);
            int tokenCount = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (this.delimiters.indexOf(token) != -1) continue;
                if (tokenCount < this.maskTextFields.size()) {
                    this.setText(tokenCount, token);
                }
                ++tokenCount;
            }
            for (MaskTextFieldItem item : this.maskTextFields) {
                item.filled = item.getText().length() > 0 && item.isFieldValid();
            }
        }
    }

    public void clear() {
        for (MaskTextFieldItem m : this.maskTextFields) {
            m.setText("");
        }
    }

    public void setText(int position, String text) {
        if (position < this.maskTextFields.size()) {
            this.maskTextFields.get(position).setText(text);
        }
    }

    public String getText() {
        if (this.isFieldValid()) {
            return this.getComponentText(true);
        }
        return null;
    }

    public boolean isFieldValid() {
        for (MaskTextFieldItem item : this.maskTextFields) {
            if (item.isFieldValid()) continue;
            return false;
        }
        return true;
    }

    public String getText(int position) {
        if (position < this.maskTextFields.size()) {
            return this.maskTextFields.get(position).getText();
        }
        return "";
    }

    public String getData() {
        return this.getComponentText(false);
    }

    public void setMaskColor(Color color) {
        this.maskColor = color;
    }

    public Color getMaskColor() {
        return this.maskColor;
    }

    public void setDisplayPartialMask(boolean value) {
        this.displayPartialMask = value;
    }

    public boolean isDisplayPartialMask() {
        return this.displayPartialMask;
    }

    private String getComponentText(boolean delimiterRequired) {
        this.text.setLength(0);
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JTextField) {
                JTextField textField = (JTextField)components[i];
                this.text.append(textField.getText());
            }
            if (!delimiterRequired || !(components[i] instanceof JLabel)) continue;
            JLabel label = (JLabel)components[i];
            this.text.append(label.getText());
        }
        return this.text.toString();
    }

    private void tab(JTextField textField, int direction) {
        Component[] components = this.getComponents();
        int i = 0;
        while (components[i] != textField) {
            ++i;
        }
        while (!(components[i = (i + direction + components.length) % components.length] instanceof JTextField)) {
        }
        components[i].requestFocus();
    }

    public void _focusGained(FocusEvent e) {
        Component c = e.getOppositeComponent();
        int size = this.getComponentCount();
        for (int i = 0; i < size; ++i) {
            if (c != this.getComponent(i)) continue;
            return;
        }
        this.focusGained(e);
    }

    public void focusGained(FocusEvent e) {
    }

    public void _focusLost(FocusEvent e) {
        Component c = e.getOppositeComponent();
        int size = this.getComponentCount();
        for (int i = 0; i < size; ++i) {
            if (c != this.getComponent(i)) continue;
            return;
        }
        this.focusLost(e);
    }

    public void focusLost(FocusEvent e) {
    }

    public boolean isShowToolTip() {
        return this.showToolTip;
    }

    public void setShowToolTip(boolean showToolTip) {
        this.showToolTip = showToolTip;
    }

    @Override
    public void addKeyListener(KeyListener l) {
        for (MaskTextFieldItem i : this.maskTextFields) {
            i.addKeyListener(l);
        }
    }

    public void addActionListener(final ActionListener l) {
        for (MaskTextFieldItem i : this.maskTextFields) {
            i.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    l.actionPerformed(new ActionEvent(this, 0, null));
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    l.actionPerformed(new ActionEvent(this, 0, null));
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    l.actionPerformed(new ActionEvent(this, 0, null));
                }
            });
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.firstField != null) {
            this.firstField.setFont(font);
        }
        if (this.lastField != null) {
            this.lastField.setFont(font);
        }
        if (this.maskTextFields != null) {
            for (MaskTextFieldItem item : this.maskTextFields) {
                item.setFont(font);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.firstField != null) {
            this.firstField.setEnabled(enabled);
        }
        if (this.lastField != null) {
            this.lastField.setEnabled(enabled);
        }
        if (this.maskTextFields != null) {
            for (MaskTextFieldItem item : this.maskTextFields) {
                item.setEnabled(enabled);
            }
        }
    }

    public static abstract class FieldValidator {
        public abstract boolean isValid(String var1, int var2, int var3);

        public abstract boolean isFull(String var1, int var2, int var3);

        public String getMessage() {
            return null;
        }
    }

    public static final class Format {
        public boolean autoSize = false;
        public int align = 2;
        public double weightx = 0.0;
        public double weighty = 0.0;
        public int fill = 0;
        public Insets insets = null;

        public Format(boolean autoSize, int align, double weightx, double weighty, int fill, Insets insets) {
            this.autoSize = autoSize;
            this.align = align;
            this.weightx = weightx;
            this.weighty = weighty;
            this.fill = fill;
            this.insets = insets;
        }
    }

    protected static final class MaskTextFieldItem
    extends JTextField
    implements DocumentListener,
    FocusListener,
    KeyListener {
        private BGMaskTextField parent;
        private String mask;
        private Color maskColor = DEFAULT_MASK_COLOR;
        private boolean displayPartialMask = true;
        private boolean isFocusTraversable = true;
        private FieldValidator validator;
        private StringBuffer textBuffer = new StringBuffer();
        public boolean filled = false;
        private int num;
        private boolean autoSize;
        private int size;

        public MaskTextFieldItem(int size, String mask, int num, FieldValidator validator, boolean autoSize) {
            super(size);
            this.size = size;
            this.autoSize = autoSize;
            if (mask.trim().length() == 0) {
                this.setMask(null);
            } else {
                this.setMask(mask);
            }
            this.validator = validator;
            this.num = num;
            this.getDocument().addDocumentListener(this);
            this.addFocusListener(this);
            this.addKeyListener(this);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setOpaque(false);
            this.setForeground(null);
            this.setMinimumSize(this.getPreferredSize());
        }

        public boolean isFieldValid() {
            if (this.validator != null) {
                return this.validator.isValid(this.getText(), this.num, this.size);
            }
            return true;
        }

        public void setParent(BGMaskTextField parent) {
            this.parent = parent;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            dim.width += 2;
            return dim;
        }

        public void setMask(String mask) {
            this.mask = mask;
        }

        public Color getMaskColor() {
            if (this.parent != null) {
                return this.parent.getMaskColor();
            }
            return this.maskColor;
        }

        public final boolean isDisplayPartialMask() {
            if (this.parent != null) {
                return this.parent.isDisplayPartialMask();
            }
            return this.displayPartialMask;
        }

        @Override
        public final boolean isFocusTraversable() {
            return this.isFocusTraversable;
        }

        public void setFocusTraversable(boolean value) {
            this.isFocusTraversable = value;
        }

        @Override
        public final void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.mask == null || this.filled) {
                return;
            }
            int length = this.getDocument().getLength();
            if (this.isDisplayPartialMask() && length < this.mask.length()) {
                g.setColor(this.getMaskColor());
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int y = this.getInsets().top + fm.getAscent();
                int x = this.getInsets().left + fm.stringWidth(this.getText());
                g.drawString(this.mask.substring(length), x, y);
                return;
            }
            if (!this.isDisplayPartialMask() && length == 0) {
                g.setColor(this.getMaskColor());
                FontMetrics fm = this.getFontMetrics(this.getFont());
                int y = this.getInsets().top + fm.getAscent();
                int x = this.getInsets().left;
                g.drawString(this.mask, x, y);
                return;
            }
        }

        @Override
        protected Document createDefaultModel() {
            return new SizeDocument(this.getColumns());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.filled = false;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTextField textField = (JTextField)e.getSource();
            textField.selectAll();
            textField.setToolTipText(null);
            this.parent._focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.filled = this.getText().length() > 0 && this.isFieldValid();
            this.repaint();
            this.parent._focusLost(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() == '\n') {
                this.firePropertyChange("PressEnterByMaskTextField", null, null);
            }
            switch (e.getKeyChar()) {
                case '\b': 
                case '\t': 
                case '\u001b': 
                case '\u007f': {
                    return;
                }
            }
            String possibleText = this.getPossibleText(e);
            if (this.validator != null) {
                this.setToolTipText(null);
                if (!this.validator.isValid(possibleText, this.num, this.size)) {
                    if (this.parent.isShowToolTip()) {
                        this.setToolTipText(this.validator.getMessage());
                        Component c = (Component)e.getSource();
                        c.dispatchEvent(new KeyEvent(c, 401, 0L, 2, 112, 'f'));
                    }
                    e.consume();
                }
            }
            if (!this.autoSize && possibleText.length() == this.size || this.validator != null && this.validator.isFull(possibleText, this.num, this.size)) {
                FocusManager.getCurrentManager().focusNextComponent(this);
                this.filled = true;
            } else {
                this.filled = false;
            }
        }

        @Override
        public final void keyPressed(KeyEvent e) {
        }

        @Override
        public final void keyReleased(KeyEvent e) {
        }

        private String getPossibleText(KeyEvent e) {
            JTextField textField = (JTextField)e.getSource();
            this.textBuffer.setLength(0);
            this.textBuffer.append(textField.getText());
            int start = textField.getSelectionStart();
            int end = textField.getSelectionEnd();
            this.textBuffer.delete(start, end);
            this.textBuffer.insert(start, e.getKeyChar());
            return this.textBuffer.toString();
        }

        class SizeDocument
        extends PlainDocument {
            private int maximumFieldLength = 0;

            public SizeDocument(int maximumFieldLength) {
                this.maximumFieldLength = maximumFieldLength;
            }

            @Override
            public void insertString(int offset, String text, AttributeSet a) throws BadLocationException {
                if (text == null) {
                    return;
                }
                if (MaskTextFieldItem.this.autoSize || this.getLength() + text.length() <= this.maximumFieldLength) {
                    super.insertString(offset, text, a);
                }
            }
        }
    }

    public static class IntegerValidator
    extends FieldValidator {
        public static final int NEVER = 0;
        public static final int OPTIONAL = 1;
        public static final int ALWAYS = 2;
        protected long minimum;
        protected long maximum;
        protected int rangeCheckDigits;
        protected int signRequired;
        protected String message;

        public IntegerValidator() {
            this(Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
        }

        public IntegerValidator(long minimum, long maximum) {
            this(minimum, maximum, 0);
            int min = Long.toString(Math.abs(minimum)).length();
            int max = Long.toString(Math.abs(maximum)).length();
            this.startRangeCheckAt(Math.min(min, max));
        }

        public IntegerValidator(long minimum, long maximum, int rangeCheckDigits) {
            this.minimum = minimum;
            this.maximum = maximum;
            this.startRangeCheckAt(rangeCheckDigits);
        }

        @Override
        public boolean isValid(String text, int num, int size) {
            int value;
            int textLength = text.length();
            if (textLength == 0) {
                return false;
            }
            int multiplier = 1;
            boolean signEntered = false;
            char firstCharacter = text.charAt(0);
            if (firstCharacter == '+' || firstCharacter == '-') {
                signEntered = true;
                text = text.substring(1);
                if (firstCharacter == '-') {
                    multiplier = -1;
                }
            }
            if (this.signRequired == 0 && signEntered) {
                this.message = "\u041f\u043e\u043b\u0435 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0437\u043d\u0430\u043a (+ \u0438\u043b\u0438 -)";
                return false;
            }
            if (this.signRequired == 2 && !signEntered) {
                this.message = "\u041f\u043e\u043b\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0437\u043d\u0430\u043a (+ \u0438\u043b\u0438 -)";
                return false;
            }
            try {
                value = Integer.parseInt(text) * multiplier;
            }
            catch (Exception e) {
                this.message = "\u041f\u043e\u043b\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0447\u0438\u0441\u043b\u043e";
                return false;
            }
            if (textLength < this.rangeCheckDigits) {
                return true;
            }
            if ((long)value < this.minimum || (long)value > this.maximum) {
                this.message = "\u041f\u043e\u043b\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u0447\u0438\u0441\u043b\u043e \u0432 \u043f\u0440\u0435\u0434\u0435\u043b\u0430\u0445 \u043e\u0442 " + this.minimum + " \u0434\u043e " + this.maximum;
                return false;
            }
            return true;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public void startRangeCheckAt(int rangeCheckDigits) {
            this.rangeCheckDigits = rangeCheckDigits;
        }

        public void setSignRequired(int signRequired) {
            this.signRequired = signRequired;
        }

        @Override
        public boolean isFull(String text, int num, int size) {
            return text.length() == size || (long)num > this.maximum;
        }
    }
}

