/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.tree;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.table.tree.AbstractTreeTableModel;
import ru.bitel.bgbilling.client.common.table.tree.JTreeTable;
import ru.bitel.bgbilling.client.common.table.tree.TreeNode;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class DefaultTreeTableModel<N extends TreeNode<N>>
extends AbstractTreeTableModel {
    protected String[] cNames = new String[0];
    protected Class<?>[] cTypes = new Class[0];
    protected JTreeTable.TreeTableCellRenderer tree = null;
    protected GetTreeNodeFromElement<N> getTreeNodeFromElement;

    public DefaultTreeTableModel(TreeNode root, String[] cNames, Class<?>[] cTypes, GetTreeNodeFromElement<N> getTreeNodeFromElement) {
        super(root);
        this.getTreeNodeFromElement = getTreeNodeFromElement;
        this.cNames = cNames;
        this.cTypes = cTypes;
    }

    @Override
    public int getColumnCount() {
        return this.cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return column >= 0 && column < this.cTypes.length ? this.cNames[column] : null;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return column >= 0 && column < this.cTypes.length ? this.cTypes[column] : null;
    }

    @Override
    public void init(JTree tree) {
        this.tree = (JTreeTable.TreeTableCellRenderer)tree;
        tree.setRootVisible(true);
    }

    @Override
    public boolean isCellEditable(Object node, int column) {
        if (node == this.root) {
            return false;
        }
        return super.isCellEditable(node, column);
    }

    protected N getFromElement(Element el) {
        return (N)((TreeNode)this.getTreeNodeFromElement.getFromElement(el));
    }

    protected TreeNode getById(int id) {
        if (id == this.root.id) {
            return this.root;
        }
        return this.getById(id, this.root.child);
    }

    protected TreeNode<?> getById(int id, List<TreeNode> nodes) {
        if (nodes != null) {
            for (TreeNode node : nodes) {
                if (id == node.id) {
                    return node;
                }
                TreeNode<?> result = this.getById(id, node.child);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public void load(Object el) {
        Enumeration<TreePath> e = this.tree.getExpandedDescendants(new TreePath(this.root));
        this.root.clear();
        this.tree.clearToggledPaths();
        if (!(el instanceof Node)) {
            throw new IllegalArgumentException();
        }
        this.loadNode(this.root, (Node)el);
        this.root.loaded = true;
        if (this.root != null) {
            TreePath path = new TreePath(this.getPathToRoot(this.root));
            this.tree.expandPath(path);
            this.tree.setSelectionPath(path);
        }
        if (e != null) {
            while (e.hasMoreElements()) {
                TreePath t = e.nextElement();
                TreeNode node = this.getById(((TreeNode)t.getLastPathComponent()).id);
                if (node == null) continue;
                this.tree.expandPath(new TreePath(this.getPathToRoot(node)));
            }
        }
    }

    public void load(Object el, String selected, boolean firstChild) {
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        this.tree.clearSelection();
        this.load(el);
        if (selected != null) {
            int _id = Utils.parseInt(selected);
            TreeNode node = this.getById(_id);
            if (node != null) {
                if (firstChild) {
                    if (!node.isLeaf()) {
                        TreePath t = new TreePath(this.getPathToRoot((TreeNode)node.getChild(0)));
                        this.tree.expandPath(t);
                        this.tree.setSelectionPath(t);
                    }
                } else {
                    TreePath t = new TreePath(this.getPathToRoot(node));
                    this.tree.expandPath(t);
                    this.tree.setSelectionPath(t);
                }
            }
        } else if (selectedPaths != null && selectedPaths.length > 0) {
            for (TreePath t : selectedPaths) {
                TreeNode node = this.getById(((TreeNode)t.getLastPathComponent()).id);
                if (node == null) continue;
                this.tree.setSelectionPath(new TreePath(this.getPathToRoot(node)));
            }
        }
        this.tree.updateUI();
    }

    public void expandAndSelectFirstChild(String id) {
        int _id = Utils.parseInt(id);
        TreeNode node = this.getById(_id);
        if (node != null && !node.isLeaf()) {
            TreePath t = new TreePath(this.getPathToRoot((TreeNode)node.getChild(0)));
            this.tree.expandPath(t);
            this.tree.setSelectionPath(t);
        }
    }

    public void expandAndSelect(String id) {
        int _id = Utils.parseInt(id);
        TreeNode node = this.getById(_id);
        if (node != null) {
            TreePath t = new TreePath(this.getPathToRoot(node));
            this.tree.expandPath(t);
            this.tree.setSelectionPath(t);
        }
    }

    public void expand(N node) {
        TreePath t;
        if (node != null && !this.tree.isExpanded(t = new TreePath(this.getPathToRoot((TreeNode)node)))) {
            this.tree.expandPath(t);
        }
    }

    protected void loadNode(TreeNode<N> n, Node el) {
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            N child = this.getFromElement((Element)node);
            this.loadNode((TreeNode<N>)child, node);
            n.addChild(child);
        }
    }

    public N getSelectedNode() {
        TreePath path = this.tree.getSelectionPath();
        return (N)(path != null ? (TreeNode)path.getLastPathComponent() : null);
    }

    public List<N> getSelectedNodes() {
        TreePath[] path;
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        for (TreePath t : path = this.tree.getSelectionPaths()) {
            result.add((TreeNode)t.getLastPathComponent());
        }
        return result;
    }

    public String getSelectedId() {
        TreePath path = this.tree.getSelectionPath();
        TreeNode node = path != null ? (TreeNode)path.getLastPathComponent() : null;
        return node != null && node != this.root ? String.valueOf(node.id) : null;
    }

    public String getSelectedId(Component comp, String msg) {
        TreeNode node;
        TreePath path = this.tree.getSelectionPath();
        TreeNode treeNode = node = path != null ? (TreeNode)path.getLastPathComponent() : null;
        if (node == null) {
            ClientUtils.showErrorMessageDialog(msg);
        }
        return node != null && node != this.root ? String.valueOf(node.id) : null;
    }

    public int getSelectedIdInt() {
        TreePath path = this.tree.getSelectionPath();
        TreeNode node = path != null ? (TreeNode)path.getLastPathComponent() : null;
        return node != null ? node.id : -1;
    }

    public void expandAll(Set<Integer> exclude) {
        this.expandAll(exclude, this.root.child);
    }

    protected void expandAll(Set<Integer> exclude, List<TreeNode> nodes) {
        if (nodes != null) {
            for (TreeNode node : nodes) {
                if (exclude != null && exclude.contains(node.id) || node.isLeaf()) continue;
                this.tree.expandPath(new TreePath(this.getPathToRoot(node)));
                this.expandAll(exclude, node.child);
            }
        }
    }

    public static interface GetTreeNodeFromElement<N> {
        public N getFromElement(Element var1);
    }
}

