/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.server.service;

import jakarta.jws.WebService;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.common.bean.FieldNameSQL;
import ru.bitel.bgbilling.kernel.admin.common.service.AdminService;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.PeriodicProcessErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.bean.PeriodicErrorManager;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.admin.common.service.AdminService")
public class AdminServiceImpl
extends AbstractService
implements AdminService {
    @Override
    public List<IdTitle> getContractEntries(String values, boolean byTitle) throws BGException, BGMessageException {
        List<Object> result = new ArrayList();
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            result = byTitle ? contractDao.getContractsByTitles(Utils.toList(values, "\n")) : contractDao.getContracts(Utils.toIntegerList(values));
        }
        return result.stream().map(a -> new IdTitle(a.getId(), a.getTitle())).toList();
    }

    @Override
    public List<BGModule> getModules() throws BGException, BGMessageException {
        return ModuleCache.getInstance().getModulesList();
    }

    @Override
    public List<String> getContractEntriesFromSqlQuery(String query, FieldNameSQL fieldNameSQL) throws BGException, BGMessageException {
        if (query == null) {
            throw new BGMessageException("query == null");
        }
        if (fieldNameSQL == null) {
            throw new BGMessageException("fieldNameSQL == null");
        }
        if (query.isEmpty() || !query.toUpperCase().startsWith("SELECT ")) {
            throw new BGMessageException("\u043f\u0443\u0441\u0442\u043e\u0439 \u0437\u0430\u043f\u0440\u043e\u0441 \u0438\u043b\u0438 \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u043d\u0435 \u0441 'SELECT '");
        }
        ArrayList<String> result = new ArrayList<String>();
        try (Statement st = this.getConnection().createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                result.add(rs.getString(fieldNameSQL.name().toLowerCase()));
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    @Override
    public void periodicErrorDelete(List<Integer> periodicErrorIds) throws BGException, BGMessageException {
        if (periodicErrorIds == null || periodicErrorIds.isEmpty()) {
            throw new BGIllegalArgumentException();
        }
        new PeriodicErrorManager(this.getConnection()).deleteErrorsByIds(periodicErrorIds);
    }

    @Override
    public SearchResult<PeriodicProcessErrorMessage> periodicProcessErrorMessageSearch(String contains, Date month, Period period, Page page) throws BGException, BGMessageException {
        if (page == null || month == null) {
            throw new BGIllegalArgumentException();
        }
        if (period != null && period.getDateFrom() == null && period.getDateTo() == null) {
            period = null;
        }
        PeriodicErrorManager manager = new PeriodicErrorManager(this.getConnection());
        SearchResult<PeriodicProcessErrorMessage> searchResult = new SearchResult<PeriodicProcessErrorMessage>(period, page);
        manager.getErrors(searchResult, month, contains);
        return searchResult;
    }
}

