/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.object.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ObjectParam;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ParamValueManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntitySpecAttrType;

public class ParamManager {
    private Connection con;
    private static final String TABLE_NAME = "object_param";

    public ParamManager(Connection con) {
        this.con = con;
    }

    public List<ObjectParam> getParamList() throws BGException {
        ArrayList<ObjectParam> result = new ArrayList<ObjectParam>();
        String query = "SELECT * FROM object_param ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(this.getParamFromRs(rs));
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public List<ObjectParam> getParamList(int typeId) throws BGException {
        ArrayList<ObjectParam> result = new ArrayList<ObjectParam>();
        String query = "SELECT * FROM object_param WHERE type=? ORDER BY title";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, ParamManager.toParameterType(typeId));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getParamFromRs(rs));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public Map<Integer, ObjectParam> getParamMap() throws BGException {
        HashMap<Integer, ObjectParam> result = new HashMap<Integer, ObjectParam>();
        String query = "SELECT * FROM object_param";
        try (PreparedStatement ps = this.con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                ObjectParam param = this.getParamFromRs(rs);
                result.put(param.getId(), param);
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void updateParam(ObjectParam value) {
        boolean update = value.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + "object_param SET title=?, type=?, comment=?, flags=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            boolean flags = value.isHistory();
            ps.setString(1, value.getTitle());
            ps.setInt(2, ParamManager.toParameterType(value.getTypeId()));
            ps.setString(3, value.getComment());
            ps.setByte(4, (byte)(flags ? 1 : 0));
            if (update) {
                ps.setInt(5, value.getId());
            }
            ps.executeUpdate();
            if (!update) {
                value.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ParamValueManager.resetParametersHistoryMap();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteParam(int id) throws BGException {
        String query = "DELETE FROM object_param WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public ObjectParam getParameter(int parameterId) throws BGException {
        ObjectParam result = null;
        String query = "SELECT * FROM object_param WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, parameterId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = this.getParamFromRs(rs);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    private ObjectParam getParamFromRs(ResultSet rs) throws SQLException {
        byte flags = rs.getByte("flags");
        return new ObjectParam().setId(rs.getInt("id")).setTitle(rs.getString("title")).setTypeId(ParamManager.toEntityType(rs.getInt("type"))).setComment(rs.getString("comment")).setHistory((flags & 1) > 0);
    }

    private static int toEntityType(int pt) {
        switch (pt) {
            case 1: {
                return EntitySpecAttrType.TEXT.getCode();
            }
            case 2: {
                return EntitySpecAttrType.LIST.getCode();
            }
            case 3: {
                return EntitySpecAttrType.DATE.getCode();
            }
            case 4: {
                return EntitySpecAttrType.ADDRESS.getCode();
            }
            case 5: {
                return EntitySpecAttrType.BOOLEAN.getCode();
            }
        }
        return 0;
    }

    private static int toParameterType(int entitySpecAttrTypeId) {
        switch ((EntitySpecAttrType)EntitySpecAttrType.optEntitySpecAttrType((int)entitySpecAttrTypeId).get()) {
            case TEXT: {
                return 1;
            }
            case LIST: {
                return 2;
            }
            case DATE: {
                return 3;
            }
            case ADDRESS: {
                return 4;
            }
            case BOOLEAN: {
                return 5;
            }
        }
        return 0;
    }
}

