/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.pattern.server.service;

import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPattern;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPatternNamedNumber;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractPatternNamedNumberDao;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractParameterData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractPatternInfo;
import ru.bitel.bgbilling.kernel.contract.pattern.common.dto.ContractTariffData;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.bgbilling.kernel.contract.pattern.server.bean.ContractPatternDao;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffGroup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService")
public class ContractPatternServiceImpl
extends AbstractService
implements ContractPatternService {
    @Override
    public List<ContractPatternNamedNumber> numedNumberPatternList() throws BGException {
        try (ContractPatternNamedNumberDao numberDao = new ContractPatternNamedNumberDao(this.getConnection());){
            List<ContractPatternNamedNumber> list = numberDao.list();
            return list;
        }
    }

    @Override
    public void updateNamedNumber(ContractPatternNamedNumber namedNumber) throws BGException {
        try (ContractPatternNamedNumberDao numberDao = new ContractPatternNamedNumberDao(this.getConnection());){
            numberDao.update(namedNumber);
        }
    }

    @Override
    public int getNextNamedNumberIndex(String title) throws BGException {
        try (ContractPatternNamedNumberDao numberDao = new ContractPatternNamedNumberDao(this.getConnection());){
            int n = numberDao.getNextNamedNumberIndex(title);
            return n;
        }
    }

    @Override
    public void deleteNamedNumber(int id) throws BGException {
        try (ContractPatternNamedNumberDao numberDao = new ContractPatternNamedNumberDao(this.getConnection());){
            numberDao.delete(id);
        }
    }

    @Override
    public List<ContractPatternInfo> contractPatternlist(String nondef) throws BGException, BGMessageException {
        ArrayList<ContractPatternInfo> patterns = new ArrayList<ContractPatternInfo>();
        Set domainIds = null;
        if (!PermissionOfRoles.isAdmin(this.userId)) {
            Optional<Role> role = PermissionOfRoles.getRoleByUserId(this.userId);
            if (role.isEmpty()) {
                return patterns;
            }
            List<PermissionKit> kits = role.get().getPermissionKits();
            if (Utils.isEmptyCollection(kits)) {
                return patterns;
            }
            HashSet<Integer> domainsInKits = new HashSet<Integer>();
            for (PermissionKit kit : kits) {
                domainsInKits.addAll(kit.getDomenIds());
            }
            domainIds = DomainRuntimeMap.getInstance().getAllDescendantDomainIds(domainsInKits);
        }
        if (nondef == null && Setup.getSetup().getBoolean("contract.template.default.enable", true)) {
            patterns.add(ContractPatternInfo.builder().setId(0).setTitle("\u041f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e").setPatternMode("").setTitlePattern("").build());
        }
        patterns.addAll(new ContractPatternDao(this.getConnection()).getContractPatternList(domainIds));
        return patterns;
    }

    @Override
    public List<ContractParameterData> contractPatternContractParameterList(int contractPatternId) throws BGException, BGMessageException {
        return new ContractPatternDao(this.getConnection()).contractParameterDataList(contractPatternId);
    }

    @Override
    public List<ContractTariffData> contractPatternTariffList(int contractPatternId) throws BGException, BGMessageException {
        ContractPattern contractPattern = new ContractPatternDao(this.getConnection()).getPattern(contractPatternId);
        if (contractPattern != null) {
            String tariffMode;
            switch (tariffMode = contractPattern.getMasterTariffMode()) {
                case "selectTariffFromGroup": {
                    List<Integer> tariffGroupIds = contractPattern.getTariffGroupList();
                    if (tariffGroupIds == null || tariffGroupIds.isEmpty()) {
                        return null;
                    }
                    Integer tariffGroupId = tariffGroupIds.get(0);
                    TariffGroup tariffGroup = this.context.getDirectory(TariffGroup.class, 0).get(tariffGroupId);
                    return tariffGroup == null ? null : tariffGroup.getPlanList().stream().filter(a -> TimeUtils.dateInRange(new Date(), a.getDate1(), a.getDate2())).map(a -> ContractTariffData.builder().setId(a.getId()).setTitle(a.getTitle()).setTariffGroupId(0).build()).toList();
                }
            }
        }
        return null;
    }
}

