/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.bushe.swing.event.EventBus;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.event.UpdateContractTreeEvent;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.emuns.BGEntityType;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractStatusService;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractEditor;
import ru.bitel.bgbilling.kernel.contract.base.client.ContractSubPanel;
import ru.bitel.bgbilling.kernel.contract.status.client.ClientStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusControlPanel;
import ru.bitel.bgbilling.kernel.contract.status.client.StatusLogPanel;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.ContractStatus;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.task.common.bean.BGFutureTask;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Period;

public class ContractSubPanel_Status
extends ContractSubPanel {
    private BGUTable statusTable = null;
    private List<Status> statusList = null;
    private JLabel recordCountLabel = new JLabel();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private StatusLogPanel statusLogPanel = new StatusLogPanel();
    private BGControlPanelPages panelPages = new BGControlPanelPages();
    private StatusControlPanel statusControlPanel = new StatusControlPanel();
    private BGDataSourceTableModel statusTableModel = new BGDataSourceTableModel("ContractStatus");
    private StatusFutureTaskTableModel statusFutureTaskTableModel = new StatusFutureTaskTableModel();
    private ContractStatusService contractStatusService = null;

    public ContractSubPanel_Status() {
        this.jbInit();
    }

    private void jbInit() {
        this.tabbedPane.add((Component)this.getStatusPanel(), "\u0421\u0442\u0430\u0442\u0443\u0441");
        this.tabbedPane.add((Component)this.statusLogPanel, "\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439");
        this.tabbedPane.addChangeListener(e -> this.setData());
        this.setLayout(new GridBagLayout());
        this.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getStatusPanel() {
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(0, this.getStatusPeriodPanel(), (Component)this.getStatusFutureTaskPanel(), 600L);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)splitPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getStatusPeriodPanel() {
        this.statusTable = new BGUTable(this.statusTableModel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getStatusFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(this.statusTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getStatusFilterPanel() {
        this.statusControlPanel.addActionListener(e -> {
            this.panelPages.setPageIndex(1);
            this.changeStatus();
        });
        this.panelPages.addPropertyChangeListener(e -> {
            String name = e.getPropertyName();
            if (name != null && name.startsWith("to")) {
                this.setData();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.statusControlPanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)this.recordCountLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 0, 15), 0, 0));
        panel.add((Component)this.panelPages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getStatusFutureTaskPanel() {
        final BGUTable table = new BGUTable(this.statusFutureTaskTableModel);
        table.setSelectionMode(0);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) && table.rowAtPoint(event.getPoint()) == ContractSubPanel_Status.this.statusFutureTaskTableModel.getSelectedRowIndex()) {
                    ContractSubPanel_Status.this.getPopupMenu().show(table, event.getX(), event.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new BGTitleLabel("\u0417\u0430\u0434\u0430\u0447\u0438 \u043d\u0430 \u0441\u043c\u0435\u043d\u0443 \u0441\u0442\u0430\u0442\u0443\u0441\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public void init(ContractEditor editor) {
        super.init(editor);
    }

    @Override
    public void setData() {
        if (this.statusList == null) {
            try {
                this.statusList = this.getContractStatusService().getStatusList(false);
                this.statusLogPanel.setStatusList(this.statusList);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }
        if (this.tabbedPane.getSelectedIndex() == 0) {
            Async.ofWithTry(() -> this.statusControlPanel.setStatusList(this.getContractStatusService().getStatusList(true)));
            Async.ofWithTry(() -> this.statusFutureTaskTableModel.setData(this.getContractStatusService().statusFutureTasks(BGEntityType.CONTRACT, this.getContractId())));
            Async.ofWithTry(() -> {
                BGUTableParams tableParams = new BGUTableParams(this.getContractId()).setSort(this.statusTable.getSort()).setPage(this.panelPages.getPage());
                this.statusTableModel.loadData(this.getKernelContext(), tableParams, this.panelPages, this.recordCountLabel);
            });
        } else {
            this.statusLogPanel.performAction("refresh");
        }
    }

    private JPopupMenu getPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem cancelItem = new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443");
        cancelItem.addActionListener(e -> {
            try {
                this.getContractStatusService().statusFutureTaskCancel(this.getContractId(), ((BGFutureTask)this.statusFutureTaskTableModel.getSelectedRow()).getId());
                Async.ofWithTry(() -> this.statusFutureTaskTableModel.setData(this.getContractStatusService().statusFutureTasks(BGEntityType.CONTRACT, this.getContractId())));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
        popupMenu.add(cancelItem);
        return popupMenu;
    }

    private void changeStatus() {
        if (this.statusControlPanel.getDateFrom() == null) {
            ClientUtils.showErrorMessageDialog("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
            return;
        }
        int[] cids = new int[]{this.getContractId()};
        ClientStatusUtil.changeStatusOnServer(this, this.getContext(), cids, 0, this.statusControlPanel.getStatusId(), this.statusControlPanel.getDateFrom(), this.statusControlPanel.getDateTo(), this.statusControlPanel.getComment());
        this.setData();
        EventBus.publish((Object)new UpdateContractTreeEvent(this.getModuleId(), this.getContractId()));
    }

    private ContractStatusService getContractStatusService() {
        if (this.contractStatusService == null) {
            this.contractStatusService = this.getContext().getWebService(ContractStatusService.class, 0);
        }
        return this.contractStatusService;
    }

    class StatusFutureTaskTableModel
    extends BGTableModel<BGFutureTask> {
        Directory<UserInfo> userInfoDirectory;

        public StatusFutureTaskTableModel() {
            super(StatusFutureTaskTableModel.class.getName());
            this.userInfoDirectory = null;
            try {
                this.userInfoDirectory = ContractSubPanel_Status.this.getContext().getDirectory(UserInfo.class, 0);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 100, 200, 200, "period", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 100, 200, 300, "status", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", -1, -1, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043d\u043e", 200, 200, 200, "createTime", false, new DatetimeTableCellRenderer("dd.MM.yyyy HH:mm:ss"));
            this.addColumn("\u0421\u043e\u0437\u0434\u0430\u043b", 100, 200, 250, "userName", false, HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValueAt(BGFutureTask val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            ContractStatus contractStatus = ContractStatus.fromJson(new JSONObject(val.getData()));
            if ("status".equals(identifier)) {
                return ContractSubPanel_Status.this.statusList.stream().filter(a -> a.getId() == contractStatus.getStatus()).map(a -> a.getGuiTitle()).findFirst().orElse("#" + contractStatus.getStatus());
            }
            if ("period".equals(identifier)) {
                return new Period(contractStatus.getDateFrom(), contractStatus.getDateTo());
            }
            if ("userName".equals(identifier)) {
                return Optional.ofNullable(this.userInfoDirectory.get(val.getCreateUserId())).map(UserInfo::getName).orElse("??? [ID#" + val.getCreateUserId() + "]");
            }
            if ("comment".equals(identifier)) {
                return new JSONObject(val.getData()).optString("comment");
            }
            return super.getValueAt(val, column);
        }
    }
}

