/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.customer.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.CellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyNameValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerAccount;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.customer.CustomerContract;
import ru.bitel.bgbilling.kernel.customer.client.CustomerManagerPanel;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class CustomerEditor
extends BGEditorDialog<Customer> {
    private int accountLength = 8;
    private CustomerManagerPanel customerManagerPanel;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private ParamTableModel paramTableModel = new ParamTableModel();
    private CustomerAccountTableModel accountTableModel = new CustomerAccountTableModel();
    private CustomerContractTableModel contractTableModel = new CustomerContractTableModel();
    private List<CustomerContract> contracts = Collections.emptyList();

    public CustomerEditor(String title, Customer customer, CustomerManagerPanel customerManagerPanel) {
        super(title, customer);
        this.customerManagerPanel = customerManagerPanel;
        this.accountLength = ClientSetup.getInstance().getInt("dbinfo.customer.account.length", this.accountLength);
    }

    @Override
    public void doDialogPanel() {
        this.tabbedPane.add((Component)this.getParameterPanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.tabbedPane.add((Component)this.getAccountContractPanel(), "\u041b\u0438\u0446\u0435\u0432\u044b\u0435 \u0441\u0447\u0435\u0442\u0430, \u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b");
        this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        try {
            this.contracts = this.customerManagerPanel.getCustomerService().customerContracts(((Customer)this.data).getId(), null);
            this.accountTableModel.setData(this.customerManagerPanel.getCustomerService().customerAccounts(((Customer)this.data).getId()));
            this.accountTableModel.setSelectedRow(this.accountTableModel.getRows().stream().filter(a -> a.getContractCount() > 0).findFirst().orElse((CustomerAccount)this.accountTableModel.getRows().get(0)));
            ArrayList<KeyNameValue> values = new ArrayList<KeyNameValue>();
            JSONObject json = new JSONObject(((Customer)this.data).getData());
            if (((Customer)this.data).getCustomerType() == Customer.CustomerType.JUR_CUSTOMER) {
                this.addValue(Customer.CustomerJur.NAME, json, values);
                this.addValue(Customer.CustomerJur.INN, json, values);
                this.addValue(Customer.CustomerJur.KPP, json, values);
                this.addValue(Customer.CustomerJur.OGRN, json, values);
                this.addValue(Customer.CustomerJur.ADDRESS, json, values);
            }
            if (((Customer)this.data).getCustomerType() == Customer.CustomerType.FIZ_CUSTOMER) {
                this.addValue(Customer.CustomerFiz.LAST_NAME, json, values);
                this.addValue(Customer.CustomerFiz.FIRST_NAME, json, values);
                this.addValue(Customer.CustomerFiz.MIDDLE_NAME, json, values);
                this.addValue(Customer.CustomerFiz.INN, json, values);
                this.addValue(Customer.CustomerFiz.GENDER, json, values);
                this.addValue(Customer.CustomerFiz.BIRTHDAY, json, values);
            }
            this.paramTableModel.setData(values);
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    @Override
    public boolean doApply() throws Exception {
        this.customerManagerPanel.performAction("refresh");
        return super.doApply();
    }

    private void addValue(Customer.CustomerJur customerJur, JSONObject json, List<KeyNameValue> values) {
        values.add(new KeyNameValue(customerJur.key(), customerJur.description(), (String)json.optQuery(customerJur.key())));
    }

    private void addValue(Customer.CustomerFiz customerFiz, JSONObject json, List<KeyNameValue> values) {
        values.add(new KeyNameValue(customerFiz.key(), customerFiz.description(), (String)json.optQuery(customerFiz.key())));
    }

    private JPanel getParameterPanel() {
        final BGUTable table = new BGUTable(this.paramTableModel);
        table.setAutoRowHeight(true);
        table.setSelectionMode(0);
        table.setFont(table.getFont().deriveFont(table.getFont().getSize2D() * 1.3f));
        table.getDefaultEditor(String.class).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                KeyNameValue keyNameValue = (KeyNameValue)CustomerEditor.this.paramTableModel.getRows().get(table.getSelectedRow());
                String value = (String)((CellEditor)changeEvent.getSource()).getCellEditorValue();
                try {
                    CustomerEditor.this.customerManagerPanel.getCustomerService().customerParameterUpdate(((Customer)CustomerEditor.this.data).getId(), keyNameValue.getKey(), value);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane(table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getAccountContractPanel() {
        BGUTable accountTable = new BGUTable(this.accountTableModel);
        accountTable.setSelectionMode(0);
        accountTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                try {
                    this.accountTableModel.optSelectedRow().ifPresent(account -> this.contractTableModel.setData(this.contracts.stream().filter(a -> a.getAccount() == account.getAccount()).toList()));
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog(ex);
                }
            }
        });
        BGUTable contratTable = new BGUTable(this.contractTableModel);
        contratTable.setSelectionMode(0);
        contratTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    CustomerEditor.this.contractTableModel.optSelectedRow().ifPresent(c -> BGClientBase.getFrame().getTabbedPane().addContractEditorTab(c.getContractId()));
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041b\u0438\u0446\u0435\u0432\u044b\u0435 \u0441\u0447\u0435\u0442\u0430:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u044b:"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(accountTable, 300, 400), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(contratTable, 700, 400), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 5, 0, 0), 0, 0));
        return panel;
    }

    class ParamTableModel
    extends BGTableModel<KeyNameValue> {
        public ParamTableModel() {
            super(ParamTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 200, 250, 300, "name", true, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", String.class, 200, 300, -1, "value", true, true, HorizontalAlignmentTableCellRenderer.LEFT());
        }

        @Override
        public Object getValue(KeyNameValue val, int column) throws BGException {
            return super.getValue(val, column);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            super.setValueAt(value, rowIndex, columnIndex);
        }
    }

    class CustomerAccountTableModel
    extends BGTableModel<CustomerAccount> {
        private DecimalFormat decimalFormat;

        public CustomerAccountTableModel() {
            super(CustomerAccountTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u0421\u0447\u0435\u0442", 100, 100, -1, "account", true, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 100, 100, 100, "contractCount", false, DecimalTableCellRenderer.INTEGER());
        }

        @Override
        public Object getValue(CustomerAccount val, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("account".equals(identifier)) {
                return val.getAccount() > 0L ? this.getDecimalFormat().format(val.getAccount()) : "#".repeat(CustomerEditor.this.accountLength);
            }
            return super.getValue(val, column);
        }

        private DecimalFormat getDecimalFormat() {
            if (this.decimalFormat == null) {
                this.decimalFormat = new DecimalFormat("0".repeat(CustomerEditor.this.accountLength));
            }
            return this.decimalFormat;
        }
    }

    class CustomerContractTableModel
    extends BGTableModel<CustomerContract> {
        public CustomerContractTableModel() {
            super(CustomerContractTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumn("\u041d\u043e\u043c\u0435\u0440", 150, 150, 150, "title", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 200, 200, -1, "comment", false, HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

