/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.dynamic.server;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationMessage;
import ru.bitel.bgbilling.kernel.dynamic.common.bean.CompilationResult;
import ru.bitel.bgbilling.kernel.dynamic.server.bean.DynamicCodeDao;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Pair;

public final class CompilerWrapper {
    private static final Logger logger = LogManager.getLogger();
    private File outputdirRoot;
    private File outputdir;
    private File srcdir;
    private Pattern patternPackage = Pattern.compile("^\\s*package\\s+([^;\\s]+)\\s*;");
    private static String classpath = null;

    public CompilerWrapper(File srcdir, File outputdirRoot) {
        this.srcdir = srcdir;
        this.outputdirRoot = outputdirRoot;
    }

    private void checkSource(File srcFile, CompilationResult compilationResult) {
        try {
            File srcDirExpected;
            String javapackage = "";
            for (String line : Files.readAllLines(srcFile.toPath())) {
                Matcher matcher = this.patternPackage.matcher(line);
                if (!matcher.find()) continue;
                javapackage = matcher.group(1);
                break;
            }
            File srcDirFact = srcFile.getParentFile();
            File file = srcDirExpected = Utils.notBlankString(javapackage) ? new File(this.srcdir, javapackage.replace('.', File.separatorChar)) : this.srcdir;
            if (!srcDirFact.equals(srcDirExpected)) {
                CompilationMessage compilationMessage = new CompilationMessage();
                compilationMessage.setSource(srcFile.getAbsolutePath());
                compilationMessage.setMessage("source package \"" + javapackage + "\": expected dir is " + srcDirExpected.getAbsolutePath());
                compilationResult.getErrors().add(compilationMessage);
            }
        }
        catch (IOException e) {
            CompilationMessage compilationMessage = new CompilationMessage();
            compilationMessage.setSource(srcFile.getAbsolutePath());
            compilationMessage.setMessage("io error: " + e.toString());
            compilationResult.getErrors().add(compilationMessage);
        }
    }

    public Pair<CompilationResult, List<CompiledUnit>> compile(List<File> srcFiles) throws CompilationFailedException, BGException {
        DiagnosticListenerImpl listener = new DiagnosticListenerImpl();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            CompilationMessage compilationMessage = new CompilationMessage();
            compilationMessage.setSource("System error");
            compilationMessage.setMessage("No Java compiler found on this platform!");
            listener.getCompilationResult().getErrors().add(compilationMessage);
            throw new CompilationFailedException(listener.getCompilationResult());
        }
        for (File srcFile : srcFiles) {
            this.checkSource(srcFile, listener.getCompilationResult());
        }
        if (!listener.getCompilationResult().getErrors().isEmpty()) {
            throw new CompilationFailedException(listener.getCompilationResult());
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(listener, null, null);
        Iterable<? extends JavaFileObject> fileObjects = fileManager.getJavaFileObjectsFromFiles(srcFiles);
        String outputdirPath = this.outputdirRoot.getAbsoluteFile() + File.separator + UUID.randomUUID().toString();
        this.outputdir = new File(outputdirPath);
        if (!this.outputdir.mkdirs()) {
            throw new BGException("error create javac-output directory " + outputdirPath);
        }
        String[] options = new String[]{"-classpath", CompilerWrapper.getClasspath(), "-sourcepath", this.srcdir.getAbsolutePath(), "-encoding", "UTF-8", "-d", this.outputdir.getAbsolutePath(), "-verbose", "-Xlint:deprecation", "-g:vars,lines,source", "-parameters"};
        StringWriter sw = new StringWriter();
        JavaCompiler.CompilationTask task = compiler.getTask(sw, fileManager, listener, Arrays.asList(options), null, fileObjects);
        boolean callResult = task.call();
        CompilationResult result = listener.getCompilationResult();
        if (!callResult) {
            throw new CompilationFailedException(result);
        }
        return new Pair<CompilationResult, List<CompiledUnit>>(result, this.compiledFiles(this.outputdir));
    }

    private static String getClasspath() {
        String[] classpathEntries;
        if (classpath != null) {
            return classpath;
        }
        StringBuilder sb = new StringBuilder(300);
        String classpath1 = System.getProperty("java.class.path");
        for (String classPath : classpathEntries = classpath1.split(File.pathSeparator)) {
            sb.append(new File(classPath)).append(File.pathSeparator);
        }
        classpath = sb.toString();
        return classpath;
    }

    private static void getRecursively(StringBuilder sb, URLClassLoader urlClassLoader) {
        for (URL url : urlClassLoader.getURLs()) {
            sb.append(url.getFile().replaceAll("%20", " ")).append(File.pathSeparator);
        }
        if (urlClassLoader.getParent() != null && urlClassLoader.getParent() instanceof URLClassLoader) {
            CompilerWrapper.getRecursively(sb, (URLClassLoader)urlClassLoader.getParent());
        }
    }

    private List<CompiledUnit> compiledFiles(File directory) {
        ArrayList<CompiledUnit> result = new ArrayList<CompiledUnit>();
        for (File tmpdirFile : directory.listFiles()) {
            if (tmpdirFile.isFile()) {
                File compiledFile = tmpdirFile;
                String filePath = compiledFile.getAbsolutePath();
                String className = filePath.substring(this.outputdir.getAbsolutePath().length() + 1).replace(File.separatorChar, '.');
                className = className.substring(0, className.length() - 6);
                if (logger.isDebugEnabled()) {
                    logger.debug("Found compiled unit: " + className + " with file " + compiledFile.getAbsolutePath());
                }
                CompiledUnit unit = new CompiledUnit();
                unit.className = className;
                unit.classFile = compiledFile;
                unit.srcFile = DynamicCodeDao.getClassFile(className);
                result.add(unit);
                continue;
            }
            if (!tmpdirFile.isDirectory()) continue;
            result.addAll(this.compiledFiles(tmpdirFile));
        }
        return result;
    }

    public void deleteClassDir() {
        if (this.outputdir != null && this.outputdir.exists()) {
            this.deleteDirWithFiles(this.outputdir);
        }
    }

    private void deleteDirWithFiles(File dir) {
        for (File tmpdirFile : dir.listFiles()) {
            if (tmpdirFile.isFile()) {
                tmpdirFile.delete();
                continue;
            }
            if (!tmpdirFile.isDirectory()) continue;
            this.deleteDirWithFiles(tmpdirFile);
        }
        dir.delete();
    }

    private class DiagnosticListenerImpl
    implements DiagnosticListener<JavaFileObject> {
        private CompilationResult result = new CompilationResult();

        private DiagnosticListenerImpl() {
        }

        private CompilationResult getCompilationResult() {
            return this.result;
        }

        @Override
        public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
            CompilationMessage message = new CompilationMessage();
            message.setMessage(diagnostic.getMessage(Locale.ENGLISH));
            message.setLine(diagnostic.getLineNumber());
            message.setColumn(diagnostic.getColumnNumber());
            message.setSource(diagnostic.getSource() != null ? diagnostic.getSource().getName() : null);
            switch (diagnostic.getKind()) {
                case ERROR: {
                    this.result.getErrors().add(message);
                    break;
                }
                case WARNING: 
                case MANDATORY_WARNING: {
                    this.result.getWarnings().add(message);
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("%s (%s) %s : %s [%d, %d]", new Object[]{diagnostic.getKind(), diagnostic.getCode(), diagnostic.getMessage(Locale.ENGLISH), diagnostic.getSource() != null ? diagnostic.getSource().getName() : null, diagnostic.getLineNumber(), diagnostic.getColumnNumber()}));
            }
        }
    }

    public static class CompilationFailedException
    extends BGException {
        private CompilationResult result;

        public CompilationResult getCompilationResult() {
            return this.result;
        }

        public CompilationFailedException(CompilationResult result) {
            this.result = result;
        }
    }

    static class CompiledUnit {
        String className;
        File classFile;
        File srcFile;

        CompiledUnit() {
        }

        public String toString() {
            return this.className + " [" + this.classFile + ", " + this.srcFile + "]";
        }
    }
}

