/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server;

import java.sql.Connection;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.alarmtask.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.application.server.Application;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ScheduledTaskReloadEvent;
import ru.bitel.bgbilling.kernel.event.processors.CommonKernelEventProcessor;
import ru.bitel.bgbilling.kernel.event.processors.ScriptEventProcessor;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.server.TaskRunProcessor;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.kernel.task.server.bean.TaskData;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.logging.BGNestedContext;
import ru.bitel.common.logging.Log4j2;
import ru.bitel.common.logging.LoggingPrintStream;

public class TaskExecuter
extends Thread {
    private static Logger log;
    public static int STATUS_WORK;
    public static int STATUS_SUSPENDED;
    public static int STATUS_FINISHED;
    private Calendar last_start_date = null;
    private Setup setup;
    private Map<Integer, TaskData> tasks = new HashMap<Integer, TaskData>();
    private int status = STATUS_WORK;
    private static final String THREAD_COUNT_KEY = "scheduler.periodic.thread.count";
    private ThreadPoolExecutor pool;
    private TaskRunProcessor proccesor = null;
    private boolean needReloadTasks = false;

    public TaskExecuter() throws BGException {
        Log4j2.init("data");
        BGNestedContext.push("scheduler");
        log = LogManager.getLogger();
        LoggingPrintStream.assignToOutput();
        this.setup = Setup.getSetup();
        Application.getInstance().getCommandPortListener().setApplicationBean(this);
        System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
        log.info("Start TaskExecuter");
        this.init();
        new ScriptEventProcessor(this.setup).start();
        new CommonKernelEventProcessor(this.setup);
        this.proccesor = new TaskRunProcessor(this.setup);
        this.clearCurrentPeriodic();
        AlarmSender.initSender((DefaultServerSetup)this.setup);
        AlarmSender.registerAlarmTask(new DatabaseCheckTask());
        try {
            Utils.checkJava();
        }
        catch (BGException e) {
            AlarmSender.sendAlarm(new AlarmErrorMessage("bad.java", "\u041f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f Java", e.getMessage()), System.currentTimeMillis());
        }
        int schedulerThreadCount = this.setup.getInt(THREAD_COUNT_KEY, 5);
        this.pool = new ThreadPoolExecutor(schedulerThreadCount, schedulerThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        if (this.setup.getInt("scheduler.only.run", 0) == 0) {
            this.start();
        }
        try {
            EventProcessor.getInstance().addListener(new EventListener<ScheduledTaskReloadEvent>(){

                @Override
                public void notify(ScheduledTaskReloadEvent e, EventListenerContext ctx) {
                    TaskExecuter.this.needReloadTasks = true;
                }
            }, ScheduledTaskReloadEvent.class);
        }
        catch (BGException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void init() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            UserMap.initUserMap((Connection)con);
            BGPluginManagerServer.getManager().init(con, "scheduler");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.status == STATUS_FINISHED) {
                        this.finishTE();
                    }
                    if (this.status == STATUS_WORK) {
                        GregorianCalendar now = new GregorianCalendar();
                        if (this.needReloadTasks || this.last_start_date == null || now.get(6) != this.last_start_date.get(6)) {
                            this.reloadTasks();
                        }
                        if (this.last_start_date == null || now.get(12) != this.last_start_date.get(12)) {
                            log.debug("Looking tasks");
                            for (Integer key : this.tasks.keySet()) {
                                try {
                                    TaskData taskData = this.tasks.get(key);
                                    if (!taskData.canWork(now)) continue;
                                    if (this.pool.getActiveCount() == this.pool.getMaximumPoolSize()) {
                                        String alarmKey = "scheduler.periodic.task.run.skip";
                                        long alarmTime = System.currentTimeMillis();
                                        if (!AlarmSender.needAlarmSend(alarmKey, alarmTime, 30000L)) continue;
                                        String message = "\u0412 \u0440\u0430\u043c\u043a\u0430\u0445 \u043e\u0442\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 scheduler.periodic.thread.count \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0447\u0438\u0441\u043b\u0430 \u043e\u0434\u043d\u043e\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0442\u043e\u043a\u043e\u0432 (" + this.pool.getMaximumPoolSize() + ") \u043f\u043b\u0430\u043d\u0438\u0440\u043e\u0432\u0449\u0438\u043a \u043d\u0435 \u0441\u043c\u043e\u0433 \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0437\u0430\u0434\u0430\u0447\u0443 \u0441 \u043a\u043e\u0434\u043e\u043c #" + taskData.getId() + ".\n\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u044f\u0441\u043d\u0438\u0442\u044c \u043f\u0440\u0438\u0447\u0438\u043d\u0443 \u043c\u0435\u0434\u043b\u0435\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0437\u0430\u0434\u0430\u0447, \u0437\u0430\u043f\u0443\u0449\u0435\u043d\u043d\u044b\u0445 \u0440\u0430\u043d\u0435\u0435.";
                                        log.warn("task #" + taskData.getId() + " was skipped! for details see alarms.");
                                        AlarmSender.sendAlarm(new AlarmErrorMessage(alarmKey, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0443\u044e \u0437\u0430\u0434\u0430\u0447\u0443", message), alarmTime);
                                        continue;
                                    }
                                    log.info("Starting periodic task #" + taskData.getId() + ": " + taskData.getClassName());
                                    taskData.init(now, this.setup);
                                    this.pool.execute(taskData);
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                            this.last_start_date = now;
                        }
                    }
                    TaskExecuter.sleep(5000L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadTasks() {
        log.info("TaskExecuter => reloadTasks()");
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            this.tasks.clear();
            for (TaskData taskData : new RunTaskDataManager(con).getTaskDataForReload()) {
                Integer task_id = taskData.getId();
                this.tasks.put(task_id, taskData);
                Object info = taskData.getClassName();
                List<DependentTask> list = taskData.getDependentTasks();
                if (Utils.isBlankString((String)info) && list != null) {
                    if (list.size() == 1) {
                        info = list.get(0).getClassName();
                    } else {
                        info = "\u041f\u0430\u043a\u0435\u0442\u043d\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u0430 (\u0437\u0430\u0434\u0430\u0447 " + list.size() + "):";
                        for (DependentTask dependentTask : list) {
                            info = (String)info + "\n\t" + dependentTask.getClassName();
                        }
                    }
                }
                log.info("Task #" + task_id + ": " + (String)info);
            }
        }
        catch (Exception ex) {
            log.error("error reload tasks", (Throwable)ex);
        }
        finally {
            this.needReloadTasks = false;
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void clearCurrentPeriodic() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            new RunTaskDataManager(con).clearCurrentPeriodic();
        }
        catch (Exception ex) {
            log.error("error clear current periodic", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }

    private void finishTE() {
        log.info("Finishing TaskExecuter");
        System.exit(0);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int value) {
        this.status = value;
        log.info("TaskExecuter => setStatus() : " + this.status);
    }

    public String getStatusString() {
        StringBuffer result = new StringBuffer();
        result.append("TaskExecuter").append(this.status == STATUS_WORK ? " working" : (this.status == STATUS_SUSPENDED ? " suspend" : " undef")).append("\n");
        result.append("Periodic tasks executed: " + this.pool.getCompletedTaskCount() + "; ").append("active: " + this.pool.getActiveCount()).append("\n");
        if (this.proccesor != null) {
            result.append(this.proccesor.getStatusString());
        }
        return result.toString();
    }

    public String getPoolStackTrace() {
        return this.setup.getPoolStackTrace();
    }

    public String executeCommand(String command, String param) {
        Object result = "";
        if (command.equals("status")) {
            result = this.getStatusString();
        } else if (command.equals("resume")) {
            this.setStatus(STATUS_WORK);
            result = "ok";
        } else if (command.equals("pause")) {
            this.setStatus(STATUS_SUSPENDED);
            result = "ok";
        } else if (command.equals("stop")) {
            this.setStatus(STATUS_FINISHED);
            result = "ok";
        } else if (command.equals("reload")) {
            int status = this.getStatus();
            this.setStatus(STATUS_SUSPENDED);
            this.needReloadTasks = true;
            result = "ok";
            this.setStatus(status);
        } else if (command.equals("gc")) {
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            result = " System.gc() was invoked";
        } else if (command.equals("debug=on")) {
            TaskExecuter.setDebug(true);
            result = "ok";
        } else if (command.equals("debug=off")) {
            TaskExecuter.setDebug(false);
            result = "ok";
        } else {
            result = command.equals("sysvar") ? Utils.getSystemVariables() : (command.equals("javavar") ? Utils.getJavaProperties() : (command.equals("conpool") ? this.getPoolStackTrace() : "TEProccessManager => Unknown command : " + command));
        }
        return result;
    }

    public static void setDebug(boolean value) {
        Configurator.setLevel((String)log.getName(), (Level)(value ? Level.DEBUG : Level.INFO));
    }

    @MBeanAttribute
    public int getActiveTaskCount() {
        return this.pool.getActiveCount();
    }

    @MBeanAttribute
    public int getMaxActiveTaskCount() {
        return this.pool.getMaximumPoolSize();
    }

    static {
        STATUS_WORK = 0;
        STATUS_SUSPENDED = 1;
        STATUS_FINISHED = 2;
    }
}

