/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.client.table.AbstractBGUTable;
import ru.bitel.common.client.treetable.BGTreeTableModel;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.TreeNode;

public class AbstractBGUTreeTable<C>
extends AbstractBGUTable<C> {
    protected final TreeTableCellRenderer<?> tree;

    public <N extends TreeNode<N>> AbstractBGUTreeTable(BGTreeTableModel<N> model) {
        super(model);
        TreeTableCellRenderer<N> treeCellRenderer = new TreeTableCellRenderer<N>(model);
        this.tree = treeCellRenderer;
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.tree.setRootVisible(true);
        this.setDefaultRenderer(TreeNode.class, treeCellRenderer);
        this.setDefaultEditor(TreeNode.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(18);
        this.tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                ((AbstractTableModel)AbstractBGUTreeTable.this.getModel()).fireTableDataChanged();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                ((AbstractTableModel)AbstractBGUTreeTable.this.getModel()).fireTableDataChanged();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TreePath path = AbstractBGUTreeTable.this.tree.getSelectionPath();
                    if (path.getPathCount() > 1) {
                        if (AbstractBGUTreeTable.this.tree.isExpanded(path)) {
                            AbstractBGUTreeTable.this.tree.collapsePath(path);
                        } else {
                            AbstractBGUTreeTable.this.tree.expandPath(path);
                        }
                        AbstractBGUTreeTable.this.tree.setSelectionPath(path);
                    }
                    e.consume();
                }
            }
        });
        this.setFillsViewportHeight(true);
    }

    public void clearToggledPaths() {
        this.tree.clearToggledPaths();
    }

    @Override
    public TableCellRenderer getDefaultRenderer(Class<?> columnClass) {
        if (TreeNode.class.isAssignableFrom(columnClass)) {
            return super.getDefaultRenderer(TreeNode.class);
        }
        return super.getDefaultRenderer(columnClass);
    }

    @Override
    public TableCellEditor getDefaultEditor(Class<?> columnClass) {
        if (TreeNode.class.isAssignableFrom(columnClass)) {
            return super.getDefaultEditor(TreeNode.class);
        }
        return super.getDefaultEditor(columnClass);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean retValue = super.editCellAt(row, column, e);
        if (retValue && TreeNode.class.isAssignableFrom(this.getColumnClass(column))) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return retValue;
    }

    @Override
    public int getEditingRow() {
        return TreeNode.class.isAssignableFrom(this.getColumnClass(this.editingColumn)) ? -1 : this.editingRow;
    }

    @Override
    public void sizeColumnsToFit(int resizingColumn) {
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && TreeNode.class.isAssignableFrom(this.getColumnClass(this.editingColumn))) {
            Rectangle cellRect = this.getCellRect(this.editingRow, this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setDefaultEditor(TreeNode.class, new TreeTableCellEditor());
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public void addTreeWillExpandListener(TreeWillExpandListener l) {
        this.tree.addTreeWillExpandListener(l);
    }

    public void addSelectionPath(TreePath path) {
        this.tree.addSelectionPath(path);
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.tree.addTreeExpansionListener(tel);
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.tree.addTreeSelectionListener(tsl);
    }

    public void collapsePath(TreePath path) {
        this.tree.collapsePath(path);
    }

    public void collapseRow(int row) {
        this.tree.collapseRow(row);
    }

    public void collapse() {
        TreeModel model = (TreeModel)((Object)this.getModel());
        this.collapse(model.getRoot(), new Object[20], 0);
    }

    private void collapse(Object parent, Object[] path, int level) {
        TreeModel model = (TreeModel)((Object)this.getModel());
        path[level] = parent;
        boolean collapsed = false;
        int size = model.getChildCount(parent);
        for (int i = 0; i < size; ++i) {
            Object child = model.getChild(parent, i);
            if (model.isLeaf(child)) {
                if (collapsed) continue;
                collapsed = true;
                this.tree.collapsePath(new TreePath(path, level + 1){});
                continue;
            }
            this.collapse(child, path, level + 1);
        }
    }

    public void expandPath(TreePath path) {
        this.tree.expandPath(path);
    }

    public void expand() {
        TreeModel model = (TreeModel)((Object)this.getModel());
        this.expand(model.getRoot(), new Object[20], 0, 20);
    }

    public void expand(int level) {
        TreeModel model = (TreeModel)((Object)this.getModel());
        this.expand(model.getRoot(), new Object[20], 0, level);
    }

    private void expand(Object parent, Object[] path, int level, int limit) {
        if (level > limit) {
            return;
        }
        TreeModel model = (TreeModel)((Object)this.getModel());
        path[level] = parent;
        boolean expanded = false;
        int size = model.getChildCount(parent);
        for (int i = 0; i < size; ++i) {
            Object child = model.getChild(parent, i);
            if (model.isLeaf(child)) {
                if (expanded) continue;
                expanded = true;
                this.tree.expandPath(new TreePath(path, level + 1){});
                continue;
            }
            if (level < limit) {
                this.expand(child, path, level + 1, limit);
                continue;
            }
            if (expanded) continue;
            expanded = true;
            this.tree.expandPath(new TreePath(path, level + 1){});
        }
    }

    public void expandRow(int row) {
        this.tree.expandRow(row);
    }

    public void setSelectionPath(TreePath path) {
        if (this.tree.getExpandsSelectedPaths()) {
            this.tree.makeVisible(path);
        }
        this.tree.setSelectionPath(path);
    }

    public void setSelectionPaths(TreePath[] paths) {
        if (this.tree.getExpandsSelectedPaths()) {
            for (TreePath path : paths) {
                this.tree.makeVisible(path);
            }
        }
        this.tree.setSelectionPaths(paths);
    }

    public void addSelectionPaths(TreePath[] paths) {
        if (this.tree.getExpandsSelectedPaths()) {
            for (TreePath path : paths) {
                this.tree.makeVisible(path);
            }
        }
        this.tree.addSelectionPaths(paths);
    }

    public Enumeration<TreePath> getExpandedDescendants(TreePath parent) {
        return this.tree.getExpandedDescendants(parent);
    }

    public TreePath getSelectionPath() {
        return this.tree.getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.tree.getSelectionPaths();
    }

    public int[] getSelectionRows() {
        return this.tree.getSelectionRows();
    }

    public void makeVisible(TreePath path) {
        this.tree.makeVisible(path);
    }

    public void scrollPathToVisible(TreePath path) {
        this.tree.scrollPathToVisible(path);
    }

    public class TreeTableCellRenderer<N extends TreeNode<N>>
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected Border highlightBorder;
        protected BGTreeTableModel<N> model;

        @Override
        public void scrollPathToVisible(TreePath path) {
            super.scrollPathToVisible(path);
            Rectangle bounds = this.getPathBounds(path);
            if (bounds != null) {
                AbstractBGUTreeTable.this.scrollRectToVisible(bounds);
            }
        }

        public TreeTableCellRenderer(final BGTreeTableModel<N> model) {
            super(model);
            this.model = model;
            this.setRootVisible(false);
            DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Icon icon;
                    Component result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (value instanceof TreeNode && (icon = model.getIcon((TreeNode)value)) != null) {
                        this.setIcon(icon);
                    }
                    return result;
                }
            };
            cellRenderer.setOpenIcon(ClientUtils.getIcon("node"));
            cellRenderer.setClosedIcon(ClientUtils.getIcon("node"));
            cellRenderer.setLeafIcon(ClientUtils.getIcon("leaf"));
            this.setCellRenderer(cellRenderer);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (AbstractBGUTreeTable.this != null && AbstractBGUTreeTable.this.getRowHeight() != rowHeight) {
                    AbstractBGUTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, AbstractBGUTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foreground;
            Color background;
            if (isSelected) {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            } else {
                background = table.getBackground();
                foreground = table.getForeground();
            }
            this.highlightBorder = null;
            if (AbstractBGUTreeTable.super.getEditingRow() == row && AbstractBGUTreeTable.this.getEditingColumn() == column) {
                background = UIManager.getColor("Table.focusCellBackground");
                foreground = UIManager.getColor("Table.focusCellForeground");
            } else if (hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = row;
            this.setBackground(background);
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (isSelected) {
                    dtcr.setTextSelectionColor(foreground);
                    dtcr.setBackgroundSelectionColor(background);
                } else {
                    dtcr.setTextNonSelectionColor(foreground);
                    dtcr.setBackgroundNonSelectionColor(background);
                }
            }
            return this;
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            try {
                Object sValue;
                if (value != null && this.model != null && (sValue = this.model.getValue((TreeNode)value, 0)) != null) {
                    if (sValue instanceof GuiTitlable) {
                        return ((GuiTitlable)sValue).getGuiTitle();
                    }
                    return sValue.toString();
                }
                return "";
            }
            catch (BGException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void clearToggledPaths() {
            super.clearToggledPaths();
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    ArrayList<TreePath> paths = new ArrayList<TreePath>();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = AbstractBGUTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            paths.add(selPath);
                        }
                    }
                    this.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new TreeTableTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, r, c);
            TreeTableCellRenderer<?> t = AbstractBGUTreeTable.this.tree;
            boolean rv = t.isRootVisible();
            int offsetRow = rv ? r : r - 1;
            Rectangle bounds = t.getRowBounds(offsetRow);
            int offset = bounds.x;
            TreeCellRenderer tcr = t.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                Object node = t.getPathForRow(offsetRow).getLastPathComponent();
                Icon icon = t.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (AbstractBGUTreeTable.this.tree.isExpanded(offsetRow) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
                if (icon != null) {
                    offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
                }
            }
            ((TreeTableTextField)this.getComponent()).offset = offset;
            return component;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                    for (int counter = AbstractBGUTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                        if (!TreeNode.class.isAssignableFrom(AbstractBGUTreeTable.this.getColumnClass(counter))) continue;
                        MouseEvent newME = new MouseEvent(AbstractBGUTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - AbstractBGUTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                        AbstractBGUTreeTable.this.tree.dispatchEvent(newME);
                        break;
                    }
                }
                return false;
            }
            return e == null;
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        @Override
        public void reshape(int x, int y, int w, int h) {
            int newX = Math.max(x, this.offset);
            super.setBounds(newX, y, w - (newX - x), h);
        }
    }
}

