/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.product.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.EventHandler;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;

public class ProductSpecActivationModePanel
extends BGUPanel {
    private ProductSpecActivationModeTableModel model = new ProductSpecActivationModeTableModel();

    public ProductSpecActivationModePanel() {
        super(new GridBagLayout());
    }

    @Override
    protected void jbInit() {
        BGUTable table = new BGUTable(this.model);
        BGSwingUtilites.handleEdit(table, this);
        BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setFloatable(false);
        this.add((Component)toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 0), 0, 0));
        this.add((Component)new JScrollPane(table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.addPropertyChangeListener("edit", EventHandler.create(PropertyChangeListener.class, table, "enabled", "oldValue"));
        BGSwingUtilites.buildToolBar(toolBar, this);
        toolBar.compact();
    }

    public void setData(List<ProductSpecActivationMode> modeList) {
        this.model.setData(modeList);
    }

    public List<ProductSpecActivationMode> getData() {
        return this.model.getRows();
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ProductSpecActivationMode mode = ProductSpecActivationMode.builder().setModuleId(((ClientContext)ProductSpecActivationModePanel.this.getContext()).getModuleId()).setDateFrom(new Date()).build();
                new EditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0440\u0435\u0436\u0438\u043c", mode, true).open();
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ProductSpecActivationMode mode = (ProductSpecActivationMode)ProductSpecActivationModePanel.this.model.getSelectedRow();
                if (mode == null) {
                    return;
                }
                new EditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0440\u0435\u0436\u0438\u043c", mode, false).open();
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0440\u0435\u0436\u0438\u043c"){

            @Override
            public void actionPerformedImpl(ActionEvent e) throws BGException {
                ProductSpecActivationModePanel.this.model.deleteSelectedRows();
            }

            @Override
            public void setEnabled(boolean newValue) {
                super.setEnabled(true);
            }
        };
    }

    private class ProductSpecActivationModeTableModel
    extends BGTableModel<ProductSpecActivationMode> {
        public ProductSpecActivationModeTableModel() {
            super(ProductSpecActivationModeTableModel.class.getName());
        }

        @Override
        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 100, 150, -1, "title", false, HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 300, 300, 300, "deak", false, HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 150, 150, 150, "reak", false, HorizontalAlignmentTableCellRenderer.CENTER());
        }

        @Override
        public Object getValue(ProductSpecActivationMode productSpecActivationMode, int column) throws BGException {
            String identifier = this.getIdentifier(column);
            if ("period".equals(identifier)) {
                return TimeUtils.formatPeriod(productSpecActivationMode.getDateFrom(), productSpecActivationMode.getDateTo());
            }
            if ("deak".equals(identifier)) {
                if (productSpecActivationMode.getPeriodAmount() != 0) {
                    return "";
                }
                switch (productSpecActivationMode.getDeactivationMode()) {
                    case 10: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043e\u043f\u043b\u0430\u0447\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430";
                    }
                    case 0: {
                        return "\u043c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u043e";
                    }
                    case 2: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0447\u0430\u0441\u0430";
                    }
                    case 3: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u0434\u043d\u044f";
                    }
                    case 4: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043d\u0435\u0434\u0435\u043b\u0438";
                    }
                    case 5: {
                        return "\u0434\u043e \u043a\u043e\u043d\u0446\u0430 \u043c\u0435\u0441\u044f\u0446\u0430";
                    }
                }
                return null;
            }
            if ("reak".equals(identifier)) {
                if (productSpecActivationMode.getPeriodAmount() != 0) {
                    return "";
                }
                switch (productSpecActivationMode.getReactivationMode()) {
                    case 0: {
                        return "\u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430";
                    }
                    case 1: {
                        return "\u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430";
                    }
                }
                return null;
            }
            return super.getValue(productSpecActivationMode, column);
        }
    }

    private class EditorDialog
    extends BGEditorDialog<ProductSpecActivationMode> {
        private boolean newMode;
        private List<IdTitle> modeData;
        private BGUComboBox<IdTitle> modes;
        private BGControlPanelPeriodNoB period;

        public EditorDialog(String title, ProductSpecActivationMode data, boolean newMode) {
            super(title, data);
            this.newMode = false;
            this.modeData = new ArrayList<IdTitle>();
            this.modes = new BGUComboBox();
            this.period = new BGControlPanelPeriodNoB();
            this.newMode = newMode;
        }

        @Override
        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add(this.modes, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.period, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
            try {
                this.modeData = ((ClientContext)ProductSpecActivationModePanel.this.getContext()).getWebService(ProductService.class, 0).productSpecActivationModeList().stream().filter(a -> a.getModuleId() == ((ProductSpecActivationMode)this.data).getModuleId() || a.getModuleId() == 0).map(IdTitle::toIdTitle).toList();
                this.modes.setData(this.modeData);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
            if (this.modeData.size() > 0) {
                this.modes.setSelectedItem(this.modeData.stream().filter(a -> a.getId() == ((ProductSpecActivationMode)this.data).getId()).findFirst().orElse(this.modeData.get(0)));
            }
            this.period.setLocalDateFrom(TimeUtils.convertDateToLocalDate(((ProductSpecActivationMode)this.data).getDateFrom()));
            this.period.setLocalDateTo(TimeUtils.convertDateToLocalDate(((ProductSpecActivationMode)this.data).getDateTo()));
        }

        @Override
        public boolean doApply() throws Exception {
            if (this.modes.getData().isEmpty()) {
                return false;
            }
            ((ProductSpecActivationMode)this.data).setId(((IdTitle)this.modes.getSelectedItem()).getId());
            ((ProductSpecActivationMode)this.data).setTitle(((IdTitle)this.modes.getSelectedItem()).getTitle());
            ((ProductSpecActivationMode)this.data).setDateFrom(TimeUtils.convertLocalDateToDate(this.period.getLocalDateFrom()));
            ((ProductSpecActivationMode)this.data).setDateTo(TimeUtils.convertLocalDateToDate(this.period.getLocalDateTo()));
            if (this.newMode) {
                ProductSpecActivationModePanel.this.model.getRows().add((ProductSpecActivationMode)this.data);
            }
            ProductSpecActivationModePanel.this.model.fireTableDataChanged();
            return true;
        }
    }
}

