/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.ActionConType;
import bitel.billing.server.admin.action.base.ActionBase;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;

@ActionConType(value=2)
public class ActionWebQueryLogTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        StringBuffer query;
        Period period = this.getPeriod();
        String cidList = this.getParameter("contracts");
        String queryFilter = "%" + this.getParameter("query_filter", "") + "%";
        StringBuffer filterString = new StringBuffer();
        filterString.append(" WHERE dtime>='");
        filterString.append(TimeUtils.formatSQLDate((Date)period.getDateFrom()));
        filterString.append("' AND dtime<'");
        filterString.append(TimeUtils.formatSQLDate((Calendar)TimeUtils.getNextDay((Calendar)TimeUtils.convertDateToCalendar((Date)period.getDateTo()))));
        filterString.append("' ");
        filterString.append(" AND query LIKE ?");
        if (Utils.notEmptyString((String)cidList)) {
            filterString.append(" AND cid IN ( ");
            filterString.append(cidList);
            filterString.append(" ) ");
        }
        Page page = this.getPage();
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        Object tableName = "web_query_log_" + TimeUtils.format((Date)period.getDateFrom(), (String)"MMyyyy");
        String tableName2 = ServerUtils.getMonthTableName("web_query_log", period.getDateFrom());
        boolean ok = false;
        ResultSet rs = null;
        Statement ps = null;
        if (ServerUtils.tableExists(this.conSlave, (String)tableName)) {
            query = new StringBuffer();
            query.setLength(0);
            query.append("SELECT log.dtime, contract.title, log.ip, ");
            query.append("module.title, log.query ");
            query.append("FROM ");
            query.append((String)tableName);
            query.append(" AS log ");
            query.append(" LEFT JOIN contract ON log.cid=contract.id ");
            query.append(" LEFT JOIN module ON log.mid=module.id ");
            query.append(filterString);
            query.append(" ORDER BY dtime ");
            query.append(" LIMIT ? OFFSET ?");
            ps = this.conSlave.prepareStatement(query.toString());
            ps.setString(1, queryFilter);
            ps.setInt(2, page.getPageSize());
            ps.setInt(3, (page.getPageIndex() - 1) * page.getPageSize());
            rs = ps.executeQuery();
            ps.close();
            ok = true;
        } else if (ServerUtils.tableExists(this.conSlave, tableName2)) {
            query = new StringBuffer();
            query.setLength(0);
            query.append("SELECT dtime, c_title, ip, ");
            query.append("m_title, query ");
            query.append("FROM ");
            query.append(tableName2);
            query.append(" ");
            query.append(filterString);
            query.append(" ORDER BY dtime ");
            query.append(" LIMIT ? OFFSET ?");
            ps = this.conSlave.prepareStatement(query.toString());
            ps.setString(1, queryFilter);
            ps.setInt(2, page.getPageSize());
            ps.setInt(3, (page.getPageIndex() - 1) * page.getPageSize());
            rs = ps.executeQuery();
            ok = true;
            tableName = tableName2;
        }
        if (ok) {
            while (rs.next()) {
                Element row = this.createElement(data, "row");
                String requestQuery = this.getStringValue(rs.getString(5), "");
                row.setAttribute("dtime", TimeUtils.formatFullDate((Date)rs.getTimestamp(1)));
                row.setAttribute("contract", this.getStringValue(rs.getString(2), ""));
                row.setAttribute("ip", rs.getString(3));
                row.setAttribute("module", this.getStringValue(rs.getString(4), "???"));
                row.setAttribute("query", requestQuery.replaceAll("\n", "; "));
            }
            rs.close();
            ps.close();
            query = new StringBuffer(400);
            query.append("SELECT COUNT(*) FROM ");
            query.append((String)tableName);
            query.append(filterString);
            int records = 0;
            ps = this.conSlave.prepareStatement(query.toString());
            ps.setString(1, queryFilter);
            rs = ps.executeQuery();
            if (rs.next()) {
                records = rs.getInt(1);
            }
            ps.close();
            page.setRecordCount(records);
            table.setAttribute("allRecord", String.valueOf(records));
            this.setPageAttribute(table, page);
        }
    }

    protected String getStringValue(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }
}

