/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.call.action.web;

import bitel.billing.server.call.action.base.ActionBase;
import bitel.billing.server.call.bean.ReportUtils;
import bitel.billing.server.call.bean.VoiceUtils;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionLoginDirect
extends ActionBase {
    private List<Map<String, Object>> listMaps = new ArrayList<Map<String, Object>>();
    private String login = null;
    private int _count = 0;
    private int _time = 0;
    private int _roundTime = 0;
    private BigDecimal _money = BigDecimal.ZERO;
    private Period period = null;

    @Override
    public void doAction() throws SQLException, BGException {
        this.period = this.getPeriodByYearsAndDays();
        ReportUtils lu = this.getReportUtils();
        this.login = this.getParameter("login", null);
        if (this.login != null) {
            String whatSelect = " dest_code, SUM(session_time), SUM(round_session_time), SUM(session_cost), COUNT(id) ";
            String group = " GROUP BY dest_code";
            VoiceUtils vu = this.getVoiceUtils();
            int lid = Integer.parseInt(this.login);
            PreparedStatement ps = lu.selectSomethingFromSessions(lid, this.period, whatSelect, null, group, null, null);
            if (ps != null) {
                ResultSet rs = ps.executeQuery();
                try {
                    while (rs.next()) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        int time = rs.getInt(2);
                        int roundTime = rs.getInt(3);
                        BigDecimal money = rs.getBigDecimal(4);
                        int count = rs.getInt(5);
                        this._count += count;
                        this._roundTime += roundTime;
                        this._time += time;
                        this._money = this._money.add(money);
                        map.put("dest", vu.getDestTitle(rs.getInt(1)));
                        map.put("col", String.valueOf(count));
                        map.put("time", Utils.formatSessionTime((int)time));
                        map.put("round_time", Utils.formatSessionTime((int)roundTime));
                        map.put("sum", money.toPlainString());
                        this.listMaps.add(map);
                    }
                    rs.close();
                    ps.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.setData();
    }

    @Override
    protected void setDataForXslt() {
        Element directs = this.createElement(this.rootNode, "directs");
        Element logins = this.createElement(this.rootNode, "logins");
        this.getLoginManager().loginsList(logins, this.cid);
        if (this.login != null) {
            for (Map<String, Object> map : this.listMaps) {
                Element row = this.createElement(directs, "row");
                row.setAttribute("dest", map.get("dest").toString());
                row.setAttribute("col", map.get("col").toString());
                row.setAttribute("time", map.get("time").toString());
                row.setAttribute("round_time", map.get("round_time").toString());
                row.setAttribute("sum", map.get("sum").toString());
            }
            directs.setAttribute("count_amount", String.valueOf(this._count));
            directs.setAttribute("time_amount", Utils.formatSessionTime((int)this._time));
            directs.setAttribute("round_time_amount", Utils.formatSessionTime((int)this._roundTime));
            directs.setAttribute("money_amount", Utils.formatCost((BigDecimal)this._money));
            logins.setAttribute("id", this.login);
        }
    }

    @Override
    protected void setDataToRequest() {
        GregorianCalendar nowDate = new GregorianCalendar();
        int year = nowDate.get(1);
        ArrayList<Integer> yearList = new ArrayList<Integer>();
        for (int i = this.period.getDateFromCalendar().get(1); i > year - 4; --i) {
            yearList.add(i);
        }
        this.dataMap.put("per", this.period);
        this.dataMap.put("module", this.module);
        this.dataMap.put("mid", this.mid);
        this.dataMap.put("loginList", this.getLoginManager().getContractLogins(this.cid));
        this.dataMap.put("yearList", yearList);
        if (this.login != null) {
            this.dataMap.put("listMaps", this.listMaps);
            this.dataMap.put("count_amount", String.valueOf(this._count));
            this.dataMap.put("time_amount", Utils.formatSessionTime((int)this._time));
            this.dataMap.put("round_time_amount", Utils.formatSessionTime((int)this._roundTime));
            this.dataMap.put("money_amount", Utils.formatCost((BigDecimal)this._money));
            this.dataMap.put("loginId", this.login);
        }
    }
}

