/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.common.Utils;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrContract;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrDate;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class ActionCopyContractParameters
extends ActionBase {
    private static final String MODE_REPLACE = "replace";

    @Override
    public void doAction() throws SQLException, BGException {
        int fromContractId = Utils.parseInt((String)this.getParameter("fromContractId"), (int)-1);
        String mode = this.getParameter("mode", MODE_REPLACE);
        Set pids = Utils.toIntegerSet((String)this.getParameter("pids"));
        try (ContractDao contractDao = new ContractDao(this.con, 0);
             ContractParameterManager parameterManager = new ContractParameterManager(this.con);){
            Map<Integer, EntityAttr> toParamMap = null;
            Map<Integer, MultiListParamValues> multiListParamMap = null;
            if (!MODE_REPLACE.equals(mode)) {
                toParamMap = contractDao.getContractParameters(this.cid, pids);
                multiListParamMap = parameterManager.getMultiListParamValueMap(this.cid, pids);
            }
            Map<Integer, EntityAttr> fromParamMap = contractDao.getContractParameters(fromContractId, pids);
            for (Map.Entry<Integer, EntityAttr> entry : fromParamMap.entrySet()) {
                EntityAttr entityAttrPhone;
                EntityAttr entityAttr;
                boolean update;
                boolean bl = update = MODE_REPLACE.equals(mode) || !toParamMap.containsKey(entry.getKey());
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrText) {
                    EntityAttrText attrText = (EntityAttrText)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrText(this.cid, entry.getKey().intValue(), attrText.getValue()));
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrPhone) {
                    EntityAttrPhone attrPhone = (EntityAttrPhone)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    entityAttrPhone = new EntityAttrPhone(this.cid, entry.getKey().intValue());
                    entityAttrPhone.setContactList(attrPhone.getContactList());
                    contractDao.updateContractParameter(this.cid, entityAttrPhone);
                    continue;
                }
                if (update && (entityAttrPhone = entry.getValue()) instanceof EntityAttrEmail) {
                    EntityAttrEmail attrEmail = (EntityAttrEmail)entityAttrPhone;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    EntityAttrEmail entityAttrEmail = new EntityAttrEmail(this.cid, entry.getKey().intValue());
                    entityAttrEmail.setContactList(attrEmail.getContactList());
                    contractDao.updateContractParameter(this.cid, (EntityAttr)entityAttrEmail);
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrDate) {
                    EntityAttrDate attrDate = (EntityAttrDate)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrDate(this.cid, entry.getKey().intValue(), attrDate.getValue()));
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrBoolean) {
                    EntityAttrBoolean attrBoolean = (EntityAttrBoolean)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrBoolean(this.cid, entry.getKey().intValue(), attrBoolean.getValue()));
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrList) {
                    EntityAttrList attrList = (EntityAttrList)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrList(this.cid, entry.getKey().intValue(), attrList.getValue(), attrList.getTitle()));
                    continue;
                }
                if (update && (entityAttr = entry.getValue()) instanceof EntityAttrAddress) {
                    EntityAttrAddress attrAddress = (EntityAttrAddress)entityAttr;
                    if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                    contractDao.updateContractParameter(this.cid, (EntityAttr)EntityAttrAddress.builder((int)this.cid, (int)entry.getKey()).setHouseId(attrAddress.getHouseId()).setPod(attrAddress.getPod()).setFloor(attrAddress.getFloor()).setFlat(attrAddress.getFlat()).setRoom(attrAddress.getRoom()).setComment(attrAddress.getComment()).setFormatKey(attrAddress.getFormatKey()).setTitle(attrAddress.getTitle()).build());
                    continue;
                }
                if (!update || !((entityAttr = entry.getValue()) instanceof EntityAttrContract)) continue;
                EntityAttrContract attrContract = (EntityAttrContract)entityAttr;
                if (!PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                contractDao.updateContractParameter(this.cid, (EntityAttr)new EntityAttrContract(this.cid, entry.getKey().intValue(), attrContract.getValue(), attrContract.getTitle()));
            }
            for (Map.Entry<Integer, Object> entry : parameterManager.getMultiListParamValueMap(fromContractId, pids).entrySet()) {
                if (!MODE_REPLACE.equals(mode) && multiListParamMap.containsKey(entry.getKey()) || !PermissionOfRoles.checkWriteContractParameter(entry.getKey(), this.userId)) continue;
                parameterManager.updateMultiListParameterAndItems(this.cid, entry.getKey(), (MultiListParamValues)entry.getValue(), this.userId);
            }
        }
        new CommentPatternManager(this.con).updateContractComment(this.cid);
    }
}

