/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.service.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Node;
import ru.bitel.oss.systems.inventory.service.common.bean.Service;
import ru.bitel.oss.systems.inventory.service.common.bean.ServiceSpec;
import ru.bitel.oss.systems.inventory.service.common.service.ServiceService;
import ru.bitel.oss.systems.inventory.service.server.bean.ServiceDao;
import ru.bitel.oss.systems.inventory.service.server.bean.ServiceSpecDao;

@WebService(endpointInterface="ru.bitel.oss.systems.inventory.service.common.service.ServiceService")
public class ServiceServiceImpl
extends AbstractService
implements ServiceService {
    private ServiceDao serviceDao;
    private Directory<ServiceSpec> serviceSpecDir;

    private ServiceDao getServiceDao() {
        if (this.serviceDao == null) {
            this.serviceDao = new ServiceDao(this.getConnection());
        }
        return this.serviceDao;
    }

    @PostConstruct
    void init() throws BGException {
        this.serviceSpecDir = this.context.getDirectory(ServiceSpec.class, 0);
    }

    public List<ServiceSpec> serviceSpecList(Integer moduleId, Date dateFrom, Date dateTo, String title) throws BGException {
        if (moduleId == null && this.moduleId > 0) {
            moduleId = this.moduleId;
        }
        if ((moduleId == null || moduleId < 0) && dateFrom == null && dateTo == null && Utils.isBlankString((String)title)) {
            return this.serviceSpecDir.list();
        }
        return new ServiceSpecDao(this.getConnection(), 0).list(moduleId, dateFrom, dateTo, title, null);
    }

    public ServiceSpec serviceSpecTree(Integer moduleId, Date dateFrom, Date dateTo, String title) throws BGException {
        List<ServiceSpec> list = this.serviceSpecList(moduleId, dateFrom, dateTo, title);
        ServiceSpec root = new ServiceSpec();
        root.setTitle("\u0421\u0435\u0440\u0432\u0438\u0441\u044b");
        return (ServiceSpec)TreeUtils.tree(list, (Node)root);
    }

    public ServiceSpec serviceSpecGet(int id) throws BGException {
        return this.serviceSpecDir.get(id);
    }

    public int serviceSpecUpdate(ServiceSpec serviceSpec) throws BGException {
        this.serviceSpecDir.update(serviceSpec);
        return serviceSpec.getId();
    }

    public void serviceSpecDelete(int id) throws BGException {
        this.serviceSpecDir.delete(id);
    }

    public void serviceSpecMove(int id, Set<Integer> ids) throws BGException {
        new ServiceSpecDao(this.getConnection(), 0).move(id, ids);
    }

    public List<Service> serviceList(int contractId, int productId) throws BGException {
        return this.getServiceDao().list(contractId, productId);
    }

    public int serviceUpdate(Service service) throws BGException {
        this.getServiceDao().update(service);
        return service.getId();
    }

    public void serviceDelete(int contractId, int id) throws BGException {
        this.getServiceDao().delete(contractId, id);
    }

    public void serviceDeleteByProduct(int contractId, int productId) throws BGException {
        this.getServiceDao().deleteByProduct(contractId, productId);
    }
}

