/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mangooffice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.mangooffice.common.bean.MangoAccountProduct;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class MangoAccountProductDao
extends AbstractIdDao<MangoAccountProduct> {
    public MangoAccountProductDao(Connection con, int moduleId) {
        super(con, moduleId, "mango_account_product");
    }

    public List<MangoAccountProduct> getList(int accountId) throws BGException {
        return this.list("accountId=?", "id", new Object[]{accountId});
    }

    protected MangoAccountProduct getFromRS(ResultSet rs) throws SQLException, BGException {
        MangoAccountProduct product = new MangoAccountProduct();
        product.setId(rs.getInt("id"));
        product.setAccountId(rs.getInt("accountId"));
        product.setPlanId(rs.getInt("planId"));
        product.setProductId(rs.getInt("productId"));
        product.setProductStatus(rs.getInt("productStatus"));
        product.setDateFrom(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateFrom")));
        product.setDateTo(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("dateTo")));
        return product;
    }

    protected void updateImpl(MangoAccountProduct product) throws BGException, SQLException {
        if (product == null) {
            return;
        }
        int index = 1;
        if (product.getId() < 1) {
            try (PreparedStatement ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " SET accountId=?, planId=?, productId=?, productStatus=?, dateFrom=?, dateTo=?", 1);){
                ps.setInt(index++, product.getAccountId());
                ps.setInt(index++, product.getPlanId());
                ps.setInt(index++, product.getProductId());
                ps.setInt(index++, product.getProductStatus());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)product.getDateFrom()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)product.getDateTo()));
                ps.executeUpdate();
                product.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        try (PreparedStatement ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET productStatus=?, dateTo=?");){
            ps.setInt(index++, product.getProductStatus());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)product.getDateTo()));
        }
    }
}

