/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.omega.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.omega.common.bean.Device;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class OmegaDao
extends AbstractIdDao<Device> {
    public OmegaDao(Connection con, int moduleId) {
        super(con, moduleId, "omega_device");
    }

    public Device getDevice(int contractId, String hash) throws BGException {
        Device device = null;
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE contractid=? AND hash=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setString(2, hash);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                device = this.getFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return device;
    }

    public List<Device> getContractDeviceList(int contractId) throws BGException {
        return this.list("contract_id=?", "date_from", new Object[]{contractId});
    }

    public int getContractId(String hash) throws BGException {
        int contractId = 0;
        try {
            String query = "SELECT contract_id FROM " + this.tableName + " WHERE hash=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setString(1, hash);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                contractId = rs.getInt(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return contractId;
    }

    protected Device getFromRS(ResultSet rs) throws SQLException, BGException {
        Device device = new Device();
        device.setId(rs.getInt("id"));
        device.setContractId(rs.getInt("contract_id"));
        device.setKey(rs.getString("key"));
        device.setHash(rs.getString("hash"));
        device.setPeriod(new Period((Date)rs.getTimestamp("date_from"), (Date)rs.getTimestamp("date_to")));
        return device;
    }

    protected void updateImpl(Device device) throws BGException, SQLException {
        String query = "UPDATE " + this.tableName + " SET `key`='?', date_from=?, date_to=?, hash='?'" + (device.getId() > 0 ? "WHERE id=?" : "");
        int parameterIndex = 1;
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setString(parameterIndex++, device.getKey());
        Period period = device.getPeriod();
        if (period != null) {
            ps.setTimestamp(parameterIndex++, period.getDateFrom() != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()) : null);
            ps.setTimestamp(parameterIndex++, period.getDateTo() != null ? TimeUtils.convertDateToTimestamp((Date)period.getDateTo()) : null);
        } else {
            ps.setTimestamp(parameterIndex++, null);
            ps.setTimestamp(parameterIndex++, null);
        }
        ps.setString(parameterIndex++, device.getHash());
        ps.executeUpdate();
        ps.close();
    }
}

