/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.onpay.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.modules.onpay.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.onpay.common.service.OnPayService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionMonitor
extends AbstractTransactionPanel {
    private BGTextField onpayIdField = null;

    public TransactionMonitor() {
        this.transactionModel = new TransactionTableModel(TransactionMonitor.class.getName());
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected void initListeners() {
        super.initListeners();
        super.initPopupListener();
    }

    protected void initPopupMenu() {
        this.getTable().getPopupMenu().add(this.getOpenContractMenuItem());
    }

    protected JPanel getExtraFilterPanel() {
        this.onpayIdField = new BGTextField(10);
        this.onpayIdField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    TransactionMonitor.this.pagePanel.setPageIndex(1);
                    TransactionMonitor.this.performAction("refresh");
                }
            }
        });
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)new JLabel("OnPay ID:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.onpayIdField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        return filterPanel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            int onpayId = Utils.parseInt((String)this.onpayIdField.getText(), (int)0);
            this.onpayIdField.setText(String.valueOf(onpayId));
            SearchResult searchResult = ((OnPayService)((ClientContext)this.getContext()).getPort(OnPayService.class)).searchTransactionList(onpayId, -1, this.periodPanel.getPeriod(), this.pagePanel.getPage());
            ((TransactionTableModel)this.transactionModel).setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(Utils.getDecimalFormatSumma().format(searchResult.getSum()));
        });
    }

    class TransactionTableModel
    extends ru.bitel.bgbilling.modules.onpay.client.TransactionTableModel {
        public TransactionTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumnContractTitle();
            this.addColumnTransactionId();
            this.addColumnTransactionDate();
            this.addColumnStatus();
            this.addColumnSum();
        }
    }
}

