/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.dialup;

import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtils;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class Report_Dolphin_1
extends BGJasperReport {
    public Report_Dolphin_1() {
        this.id = "dialup_dolphin_1";
    }

    @Override
    public void fillReportToStream(OutputStream out) {
        BGReportFilter filter = this.createBGReportFilter();
        try {
            Calendar date = TimeUtils.parseCalendar((String)filter.getStringParam("date"), (String)"dd.MM.yyyy");
            String nases = filter.getStringParam("nases");
            int mid = Utils.parseInt((String)filter.getStringParam("mid"), (int)-1);
            int step = Utils.parseInt((String)filter.getStringParam("step"), (int)60);
            BGDataSource data = new BGDataSource();
            data.addRow(new HashMap<String, Object>());
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (date != null && Utils.notEmptyString((String)nases) && mid > 0) {
                String tableName = ServerUtils.getModuleMonthTableName((String)"log_session", (Date)date.getTime(), (int)mid);
                if (ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                    String query = "SELECT COUNT(*) FROM " + tableName + " WHERE nas_id=? AND session_start<=? AND session_stop>=?";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ArrayList<Calendar> timeList = new ArrayList<Calendar>(24);
                    Calendar start = (Calendar)date.clone();
                    Calendar stop = (Calendar)date.clone();
                    stop.set(11, stop.getActualMaximum(11));
                    stop.set(12, stop.getActualMaximum(12));
                    while (!start.after(stop)) {
                        timeList.add((Calendar)start.clone());
                        start.add(12, step);
                    }
                    String[] columns = new String[timeList.size()];
                    int size = columns.length;
                    for (int i = 0; i < size; ++i) {
                        columns[i] = TimeUtils.format((Calendar)((Calendar)timeList.get(i)), (String)"HH:mm");
                    }
                    List nasList = Utils.toList((String)nases);
                    String[] rows = new String[nasList.size()];
                    size = rows.length;
                    for (int i = 0; i < size; ++i) {
                        rows[i] = this.getNasTitle(this.con, mid, Utils.parseInt((String)((String)nasList.get(i)).trim(), (int)0));
                    }
                    double[][] values = new double[rows.length][columns.length];
                    int nasID = 0;
                    int row = 0;
                    int column = 0;
                    ResultSet rs = null;
                    for (String nas : nasList) {
                        nasID = Utils.parseInt((String)nas.trim(), (int)-1);
                        if (nasID > 0) {
                            column = 0;
                            ps.setInt(1, nasID);
                            start = (Calendar)date.clone();
                            for (Calendar time : timeList) {
                                ps.setTimestamp(2, TimeUtils.convertCalendarToTimestamp((Calendar)time));
                                ps.setTimestamp(3, TimeUtils.convertCalendarToTimestamp((Calendar)time));
                                rs = ps.executeQuery();
                                if (rs.next()) {
                                    values[row][column] = rs.getDouble(1);
                                }
                                rs.close();
                                ++column;
                            }
                        }
                        ++row;
                    }
                    ps.close();
                    CategoryDataset dataSet = DatasetUtils.createCategoryDataset((Comparable[])rows, (Comparable[])columns, (double[][])values);
                    StringBuilder addInfo = new StringBuilder(150);
                    addInfo.append("\u0427\u0438\u0441\u043b\u043e ");
                    addInfo.append(TimeUtils.formatDate((Calendar)date));
                    addInfo.append(" \u0448\u0430\u0433 ");
                    addInfo.append(step);
                    addInfo.append(" \u043c\u0438\u043d\u0443\u0442");
                    params.put("addInfo", addInfo.toString());
                    params.put("image", this.createVarWidthAreaChart(dataSet, "\u0412\u0440\u0435\u043c\u044f", "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0439", "", 400));
                }
                this.fillReportToStream("dialup_dolphin_1", out, params, data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String getNasTitle(Connection con, int mid, int id) {
        String result = "";
        try {
            String query = "SELECT identifier FROM nas_" + mid + " WHERE id=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

