/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.map.HashedMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageOption;
import ru.bitel.common.dao.AbstractDao;

public class SmartHousePackageOptionDao
extends AbstractDao<SmartHousePackageOption> {
    public SmartHousePackageOptionDao(Connection con, int moduleId) {
        super(con, moduleId, "smarthouse_package_option");
    }

    public List<SmartHousePackageOption> list() throws BGException {
        return this.list();
    }

    public Map<String, SmartHousePackageOption> getOptionMap() throws BGException {
        HashedMap optionMap = new HashedMap();
        try (Statement st = this.con.createStatement();){
            ResultSet rs = st.executeQuery("SELECT * FROM " + this.tableName);
            while (rs.next()) {
                SmartHousePackageOption packageOption = this.getFromRS(rs);
                optionMap.put(packageOption.getName(), packageOption);
            }
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        return optionMap;
    }

    protected SmartHousePackageOption getFromRS(ResultSet rs) throws SQLException, BGException {
        SmartHousePackageOption packageOption = new SmartHousePackageOption();
        packageOption.setName(rs.getString("name"));
        packageOption.setTitle(rs.getString("title"));
        packageOption.setServiceId(rs.getInt("service_id"));
        return packageOption;
    }

    public void update(SmartHousePackageOption packageOption) throws BGException {
        super.update((Object)packageOption);
    }

    protected void updateImpl(SmartHousePackageOption packageOption) throws BGException, SQLException {
        if (packageOption == null) {
            throw new BGException("packageOption is null");
        }
        String query = "INSERT INTO " + this.tableName + " SET name=?, title=?, service_id=? ON DUPLICATE KEY UPDATE title=?, service_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int parameterIndex = 1;
            ps.setString(parameterIndex++, packageOption.getName());
            ps.setString(parameterIndex++, packageOption.getTitle());
            ps.setInt(parameterIndex++, packageOption.getServiceId());
            ps.setString(parameterIndex++, packageOption.getTitle());
            ps.setInt(parameterIndex++, packageOption.getServiceId());
            ps.executeUpdate();
        }
    }
}

