/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.RandomAccessFile;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.Utils;

public class BinaryPatch
extends JFrame {
    byte[] MAGICHEAD = new byte[]{116, 114, 97, 121, 105, 110, 102, 111, 116, 97, 98, 108, 101, 114, 101, 115};
    private JTextField tfFilename = new JTextField(30);
    private JButton bOpenFile = new JButton("\u2026");
    private JTextField tfUrlSender = new JTextField();
    private JTextField tfUrlStat = new JTextField();
    private JTextField tfMid = new JTextField(10);
    private JTextField tfPin1 = new JTextField(10);
    private JTextField tfPin2 = new JTextField(10);
    private JTextField tfTimeout = new JTextField(10);
    private JButton bSave = new JButton("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
    private File currentFile = null;
    public int headeroffset = -1;

    public BinaryPatch() {
        super("TrayInfo binary patch");
        this.setDefaultCloseOperation(2);
        this.setLayout(new GridBagLayout());
        this.tfFilename.setEditable(false);
        this.add((Component)new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfFilename, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bOpenFile, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("URL \u0441\u0435\u043d\u0434\u0435\u0440:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfUrlSender, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("URL \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0438:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfUrlStat, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("mid:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfMid, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("timeout:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfTimeout, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("pin1:"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfPin1, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new JLabel("pin2:"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfPin2, new GridBagConstraints(1, 6, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bSave, new GridBagConstraints(0, 7, 3, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.bOpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                if (fc.showOpenDialog(BinaryPatch.this) == 0) {
                    BinaryPatch.this.currentFile = fc.getSelectedFile();
                    BinaryPatch.this.tfFilename.setText(BinaryPatch.this.currentFile.getAbsolutePath());
                    try {
                        BinaryPatch.this.fillBinaryInfo(BinaryPatch.this.loadFile(BinaryPatch.this.currentFile));
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                        BinaryPatch.this.resetGui();
                    }
                }
            }
        });
        this.bSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BinaryPatch.this.currentFile != null) {
                    try {
                        BinaryPatch.this.saveFile(BinaryPatch.this.currentFile, BinaryPatch.this.makeBinaryInfo());
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0417\u0430\u043f\u0438\u0441\u0430\u043d\u043e \u0443\u0441\u043f\u0435\u0448\u043d\u043e");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.resetGui();
    }

    private BinaryInfo loadFile(File file) throws Exception {
        byte[] rafile = null;
        try (FileInputStream fis = new FileInputStream(file);){
            rafile = Utils.readByBlock((InputStream)fis);
            int headeroffset = BinaryPatch.indexOf(rafile, 0, rafile.length, this.MAGICHEAD, 0, this.MAGICHEAD.length, 0);
            if (headeroffset > -1) {
                BinaryInfo bi = new BinaryInfo();
                bi.urlSender = new String(rafile, headeroffset + 16, 128).trim();
                bi.urlStat = new String(rafile, headeroffset + 16 + 128, 128).trim();
                bi.mid = new String(rafile, headeroffset + 16 + 128 + 128, 16).trim();
                bi.pin1 = new String(rafile, headeroffset + 16 + 128 + 128 + 16, 16).trim();
                bi.pin2 = new String(rafile, headeroffset + 16 + 128 + 128 + 16 + 16, 16).trim();
                bi.timeout = rafile[headeroffset + 16 + 128 + 128 + 16 + 16 + 16];
                this.headeroffset = headeroffset;
                BinaryInfo binaryInfo = bi;
                return binaryInfo;
            }
            throw new Exception("\u041d\u0435\u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0444\u0430\u0439\u043b");
        }
        finally {
            rafile = null;
        }
    }

    private void saveFile(File file, BinaryInfo bi) throws Exception {
        byte[] b_urlSender = new byte[128];
        byte[] b_urlStat = new byte[128];
        byte[] b_mid = new byte[16];
        byte[] b_pin1 = new byte[16];
        byte[] b_pin2 = new byte[16];
        int b_timeout = 0;
        System.arraycopy(bi.urlSender.getBytes(), 0, b_urlSender, 0, bi.urlSender.getBytes().length);
        System.arraycopy(bi.urlStat.getBytes(), 0, b_urlStat, 0, bi.urlStat.getBytes().length);
        System.arraycopy(bi.mid.getBytes(), 0, b_mid, 0, bi.mid.getBytes().length);
        System.arraycopy(bi.pin1.getBytes(), 0, b_pin1, 0, bi.pin1.getBytes().length);
        System.arraycopy(bi.pin2.getBytes(), 0, b_pin2, 0, bi.pin2.getBytes().length);
        b_timeout = bi.timeout & 0xFF;
        RandomAccessFile rafile = new RandomAccessFile(file, "rw");
        rafile.seek(this.headeroffset + 16);
        rafile.write(b_urlSender);
        rafile.write(b_urlStat);
        rafile.write(b_mid);
        rafile.write(b_pin1);
        rafile.write(b_pin2);
        rafile.write(b_timeout);
        rafile.close();
    }

    private void fillBinaryInfo(BinaryInfo bi) {
        this.tfUrlSender.setText(bi.urlSender == null ? "" : bi.urlSender);
        this.tfUrlStat.setText(bi.urlStat == null ? "" : bi.urlStat);
        this.tfMid.setText(bi.mid == null ? "" : bi.mid);
        this.tfPin1.setText(bi.pin1 == null ? "" : bi.pin1);
        this.tfPin2.setText(bi.pin2 == null ? "" : bi.pin2);
        this.tfTimeout.setText(String.valueOf(bi.timeout));
    }

    private void resetGui() {
        this.tfUrlSender.setText("");
        this.tfUrlStat.setText("");
        this.tfMid.setText("");
        this.tfPin1.setText("");
        this.tfPin2.setText("");
        this.tfTimeout.setText("");
        this.currentFile = null;
        this.headeroffset = -1;
        this.tfFilename.setText("\u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b");
    }

    private BinaryInfo makeBinaryInfo() throws Exception {
        BinaryInfo bi = new BinaryInfo();
        bi.urlSender = this.tfUrlSender.getText().trim();
        bi.urlStat = this.tfUrlStat.getText().trim();
        if (bi.urlSender.length() > 127 || bi.urlStat.length() > 127) {
            throw new Exception("url \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043d\u0435\u0435 127 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        bi.mid = this.tfMid.getText().trim();
        if (bi.mid.length() > 15) {
            throw new Exception("mid \u043d\u0435 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043d\u0435\u0435 15 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        bi.pin1 = this.tfPin1.getText().trim();
        bi.pin2 = this.tfPin2.getText().trim();
        if (bi.pin1.length() > 15 || bi.pin2.length() > 15) {
            throw new Exception("pin \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043d\u0435\u0435 15 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
        }
        bi.timeout = Integer.valueOf(this.tfTimeout.getText());
        return bi;
    }

    static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    public static void main(String[] args) {
        new BinaryPatch();
    }

    public static class BinaryInfo {
        public String urlSender;
        public String urlStat;
        public String mid;
        public String pin1;
        public String pin2;
        public int timeout;
    }
}

