/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.access.om;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.access.om.OrderManagerDeviceWorker;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceDevicesReloadEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.bootstrap.Shutdown;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerTask;

public class AccessDeviceManager
implements EventListener<Event> {
    private static final Logger logger = LogManager.getLogger();
    private final VoiceApplication application;
    private final ScheduledExecutorService scheduledExecutorService;
    private final ConcurrentMap<Integer, OrderManagerDeviceWorker> omDeviceWorkerMap;

    public AccessDeviceManager(final VoiceApplication application) throws BGException {
        this.application = application;
        this.omDeviceWorkerMap = new ConcurrentHashMap<Integer, OrderManagerDeviceWorker>(application.getDeviceIds().size());
        this.scheduledExecutorService = WorkerTask.newScheduledThreadPool((String)"om", (String)"connection", (ThreadContextFactory)new ThreadContextFactory<EventListenerContext>(){

            public EventListenerContext newThreadContext() {
                return new EventListenerContext(application.getSetup(), application.getModuleId(), SetupParam.getApplicationName());
            }
        }, (int)Integer.valueOf(application.getSetup().get("orderManagementCount", "10")));
        for (Integer deviceId : application.getDeviceIds()) {
            this.omDeviceWorkerMap.put(deviceId, new OrderManagerDeviceWorker(application, this.scheduledExecutorService, deviceId));
        }
        Shutdown.addShutdownHook((Runnable)new Runnable(){

            @Override
            public void run() {
                for (OrderManagerDeviceWorker worker : AccessDeviceManager.this.omDeviceWorkerMap.values()) {
                    try {
                        worker.shutdown();
                    }
                    catch (BGException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    AccessDeviceManager.this.scheduledExecutorService.shutdown();
                    AccessDeviceManager.this.scheduledExecutorService.awaitTermination(20L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        EventProcessor.getInstance().addListener((EventListener)this, VoiceDevicesReloadEvent.class, application.getModuleId(), null);
    }

    public void notify(Event e, EventListenerContext ctx) throws BGException {
        for (Integer deviceId : this.application.getDeviceIds()) {
            if (this.omDeviceWorkerMap.get(deviceId) != null) continue;
            this.omDeviceWorkerMap.put(deviceId, new OrderManagerDeviceWorker(this.application, this.scheduledExecutorService, deviceId));
        }
    }
}

