/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime;

import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffModuleTreeSet;
import ru.bitel.bgbilling.modules.voice.common.bean.AbtractVoiceAccount;
import ru.bitel.common.TimeUtils;

public abstract class VoiceAbtractAccountRuntime<T extends AbtractVoiceAccount> {
    protected T account;
    long dateFromMillis;
    long dateToMillis;
    private volatile TariffModuleTreeSet tariffTreeSet;
    protected int contractId;

    public VoiceAbtractAccountRuntime(T account) {
        this.account = account;
        this.setMillis(account);
    }

    public TariffModuleTreeSet getTariffTreeSet() {
        return this.tariffTreeSet;
    }

    public void setTariffTreeSet(TariffModuleTreeSet tariffTreeSet) {
        this.tariffTreeSet = tariffTreeSet;
    }

    public int getContractId() {
        return this.account.getContractId();
    }

    public T getAccount() {
        return this.account;
    }

    public int getAccountId() {
        return this.account.getId();
    }

    public String getTitle() {
        return this.account.getTitle();
    }

    public long getDateFromMillis() {
        return this.dateFromMillis;
    }

    public long getDateToMillis() {
        return this.dateToMillis;
    }

    protected void setMillis(T account) {
        this.dateFromMillis = this.getStartOfDay(account.getDateFrom());
        this.dateToMillis = this.getEndOfDay(account.getDateTo());
    }

    public void setAccount(T account) {
        this.account = account;
        this.setMillis(account);
    }

    private long getEndOfDay(Date date) {
        if (date == null) {
            return 0L;
        }
        Calendar dateTo = TimeUtils.convertDateToCalendar((Date)TimeUtils.getNextDay((Date)date));
        dateTo.add(14, -1);
        return dateTo.getTimeInMillis();
    }

    private long getStartOfDay(Date date) {
        if (date == null) {
            return 0L;
        }
        return TimeUtils.clear_HOUR_MIN_MIL_SEC((Date)date).getTime();
    }
}

