package ru.bitel.bgbilling.modules.voice.dyn.mediator.md110;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import ru.bitel.bgbilling.apps.voice.accounting.mediation.AbstractMediator;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecord;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecordProcessor;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

//
// #!/bin/sh
// cd ${0%${0##*/}}.
// stty -F /dev/ttyUSB0 ispeed 9600 -parenb cs8 -cstopb clocal crtscts
// разбор строки пришедшей со станции, разбиваем поток по символу \n и пишем в 10 минутные файлики
// фильтруем пустые строки
// FO=`date +%Y%m%d%H%M`
// FO=${FO:0:11}
// while IFS='\n' read a < /dev/ttyUSB0
// do
//    if [[ ${#a} != 0 ]]
//    then
//      F=`date +%Y%m%d%H%M`
//      F=${F:0:11}
//      if [[ "$F" != "${FO}" ]]
//      then
//          mv ${FO}000 /home/ATS/md110/inbox/${FO}000
//          FO=$F
//      fi
//      echo "$a" >> "${F}000"
//    fi
// done &

public class MD110_ASB501_Mediator
extends AbstractMediator
{
    protected VoiceRecord processLine( final VoiceRecordProcessor processor, final String[] params )
    throws InterruptedException
    {
        VoiceRecord record = processor.next();
        record.sessionStart = TimeUtils.parseDate( params[0], "dd.MM.yyyy HH:mm:ss" );
        record.connectionDuration = Utils.parseInt( params[1], 0 );
        record.duration = Utils.parseInt( params[1], 0 );
        record.callingStationId = params[2];
        record.e164CallingStationId = callingStationIdToE164( params[2] );
        record.calledStationId = params[3];
        record.e164CalledStationId = calledStationIdToE164( params[3] );
        record.trunkIncoming = "";
        record.trunkOutgoing = "";
        return record;
    }

    @Override
    protected void parseLog( Path path, Map<String, List<String>> cdrs )
    {
        String logTimeStr = path.getFileName().toString().replaceAll(".*(\\d{14}).*", "$1");
        LocalDateTime logTime = TimeUtils.parseLocalDateTime(logTimeStr, "yyyyMMddHHmmss");
        int year = logTime.getYear();

        DateTimeFormatter keyFormatter = DateTimeFormatter.ofPattern("yyyyMMddHH");
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");

        ByteBuffer buffer = null;
        try
        {
            buffer = ByteBuffer.wrap(Files.readAllBytes(path));
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }

        while (buffer != null && buffer.hasRemaining())
        {
            int pos = buffer.position();
            if (buffer.limit() < pos + 109)
            {
                break; // недостаёт байтов до полной записи
            }

            byte[] bytes;

            // 3–10: End Date + End Time (ddMMyyHHmm)
            bytes = new byte[8];
            buffer.get(pos + 3, bytes);
            String endDateTimeStr = new String(bytes);
            int month = Utils.parseInt(endDateTimeStr.substring(0, 2));
            int day = Utils.parseInt(endDateTimeStr.substring(2, 4));
            int hour = Utils.parseInt(endDateTimeStr.substring(4, 6));
            int minute = Utils.parseInt(endDateTimeStr.substring(6, 8));
            LocalDateTime endTime = LocalDateTime.of(year, month, day, hour, minute);

            // 12–16: Duration
            bytes = new byte[5];
            buffer.get(pos + 12, bytes);
            int duration = Utils.parseInt(new String(bytes).trim());

            // Начало вызова
            LocalDateTime startTime = endTime.minusSeconds(duration);

            // 17–18: Pulses
            bytes = new byte[2];
            buffer.get(pos + 17, bytes);
            String pulses = new String(bytes).trim();

            // 19–20: Condition Code (например, I, O, J, и т.д.)
            bytes = new byte[2];
            buffer.get(pos + 19, bytes);
            String conditionCode = new String(bytes).trim();

            // 21–24: Access Code 1 (внутренний номер вызывающего)
            bytes = new byte[4];
            buffer.get(pos + 21, bytes);
            String accessCode1 = new String(bytes).trim();

            // 25–28: Access Code 2 (внутренний номер вызываемого)
            bytes = new byte[4];
            buffer.get(pos + 25, bytes);
            String accessCode2 = new String(bytes).trim();

            // 29–36: External Line ID
            bytes = new byte[8];
            buffer.get(pos + 29, bytes);
            String externalLineId = new String(bytes).trim();

            // 37–56: Dialled number
            bytes = new byte[20];
            buffer.get(pos + 37, bytes);
            String dialledNumber = new String(bytes).trim();

            // 58–67: Calling number
            bytes = new byte[10];
            buffer.get(pos + 58, bytes);
            String callingNumber = new String(bytes).trim();

            // 68–77: Account Code
            bytes = new byte[10];
            buffer.get(pos + 68, bytes);
            String accountCode = new String(bytes).trim();

            // 78–87: Authorization Code
            bytes = new byte[10];
            buffer.get(pos + 78, bytes);
            String authCode = new String(bytes).trim();

            // 88–89: Queue Time
            bytes = new byte[2];
            buffer.get(pos + 88, bytes);
            String queueTime = new String(bytes).trim();

            // 90–109: Extended Field
            bytes = new byte[19]; // 109 - 90 = 19, т.к. pos + 109 уже конец
            buffer.get(pos + 90, bytes);
            String extendedField = new String( bytes ).trim();

            // Сохранение данных
            String key = startTime.format(keyFormatter);
            List<String> list = cdrs.get(key);
            if (list == null)
            {
                list = new ArrayList<>();
                cdrs.put(key, list);
            }

            list.add(startTime.format(timeFormatter) + "\t" + duration + "\t" + callingNumber + "\t" + dialledNumber
                     + "\t" + pulses + "\t" + conditionCode + "\t" + accessCode1 + "\t" + accessCode2
                     + "\t" + externalLineId + "\t" + accountCode + "\t" + authCode + "\t" + queueTime
                     + "\t" + extendedField);

            // переход к следующей записи
            buffer.position(pos + 109);
        }

        super.parseLog(path, cdrs);
    }
}