/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.client.admin;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.FloatTextField;
import bitel.billing.module.common.IntTextField;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusPaymentType;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusProgram;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.table.BGTableModel;

public class BonusProgramManagerPanel
extends BGUPanel {
    private BGUTable programTable;
    private BonusProgramTableModel programTableModel;
    private CardLayout cardLayout = new CardLayout();
    private BGComboBox<ComboBoxItem> programTypeComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> timeLagComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> activeTimeComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> bonusTypePaymentComboBox = new BGComboBox();
    private BGTextField titleTextField = new BGTextField(15);
    private IntTextField timeLagTextField = new IntTextField(12);
    private IntTextField activeTimeTextField = new IntTextField(12);
    private JPanel programPanel = new JPanel(new GridBagLayout());
    private JPanel programTypePanel = new JPanel(new GridBagLayout());
    private BGControlPanelPeriodNoB period = new BGControlPanelPeriodNoB();
    private BGCalendarButton timeLagCalendarButton = new BGCalendarButton();
    private BGCalendarButton activeTimeCalendarButton = new BGCalendarButton();
    private BGButtonPanelRestoreOkCancelHelp okCancelHelp = new BGButtonPanelRestoreOkCancelHelp();
    private OperationProgramPanel operationProgramPanel = new OperationProgramPanel();
    private JPanel illusionPanel = new JPanel(new GridBagLayout());

    protected void jbInit() throws Exception {
        this.programTableModel = new BonusProgramTableModel();
        this.programTable = new BGUTable((TableModel)((Object)this.programTableModel));
        this.timeLagComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(new ComboBoxItem[]{new ComboBoxItem(1, "\u0414\u0435\u043d\u044c"), new ComboBoxItem(2, "\u041a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439"), new ComboBoxItem(3, "\u041d\u0430\u0447\u0430\u043b\u043e \u043d\u0435\u0434\u0435\u043b\u0438"), new ComboBoxItem(4, "\u041d\u0430\u0447\u0430\u043b\u043e \u043c\u0435\u0441\u044f\u0446\u0430"), new ComboBoxItem(5, "\u041d\u0430\u0447\u0430\u043b\u043e \u0433\u043e\u0434\u0430")}));
        this.activeTimeComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(new ComboBoxItem[]{new ComboBoxItem(1, "\u0414\u0435\u043d\u044c"), new ComboBoxItem(2, "\u041a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439"), new ComboBoxItem(3, "\u041a\u043e\u043d\u0435\u0446 \u043d\u0435\u0434\u0435\u043b\u0438"), new ComboBoxItem(4, "\u041a\u043e\u043d\u0435\u0446 \u043c\u0435\u0441\u044f\u0446\u0430"), new ComboBoxItem(5, "\u041a\u043e\u043d\u0435\u0446 \u0433\u043e\u0434\u0430")}));
        JPanel panel = new JPanel(this.cardLayout);
        panel.add("operationProgramPanel", this.operationProgramPanel);
        this.programTypePanel.setPreferredSize(new Dimension(100, 200));
        this.programTypePanel.setBorder(new TitledBorder("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b"));
        this.programTypePanel.add((Component)new JScrollPane(panel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.illusionPanel.add((Component)this.programTypePanel, new GridBagConstraints(4, 0, 1, 7, 0.7, 0.1, 10, 1, new Insets(0, 15, 0, 5), 0, 0));
        this.programPanel.setBorder(new TitledBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.programPanel.setVisible(false);
        this.programPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.titleTextField, new GridBagConstraints(1, 0, 2, 1, 0.3, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.illusionPanel, new GridBagConstraints(4, 0, 1, 7, 0.7, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.programTypeComboBox, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.period, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u0445\u043e\u0434\u0430"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.bonusTypePaymentComboBox, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u041c\u043e\u043c\u0435\u043d\u0442 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.timeLagComboBox, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.timeLagTextField, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.timeLagCalendarButton, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)new JLabel("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.activeTimeComboBox, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.activeTimeTextField, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.activeTimeCalendarButton, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 17, 17, new Insets(5, 5, 0, 0), 0, 0));
        this.programPanel.add((Component)this.okCancelHelp, new GridBagConstraints(0, 7, 5, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.programTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.programPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.cardLayout.show(panel, "operationProgramPanel");
        this.programTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && BonusProgramManagerPanel.this.programTable.isEnabled()) {
                    BonusProgramManagerPanel.this.performAction("edit");
                }
            }
        });
        this.timeLagComboBox.addActionListener(e -> this.setVisibleComboBox(this.timeLagComboBox, this.timeLagCalendarButton, this.timeLagTextField));
        this.activeTimeComboBox.addActionListener(e -> this.setVisibleComboBox(this.activeTimeComboBox, this.activeTimeCalendarButton, this.activeTimeTextField));
        this.programTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboBoxItem item = (ComboBoxItem)BonusProgramManagerPanel.this.programTypeComboBox.getSelectedItem();
                if (item == null) {
                    return;
                }
                String id = (String)item.getObject();
                if (Utils.parseInt((String)id, (int)-1) > -1) {
                    BonusProgramManagerPanel.this.programTypePanel.setVisible(true);
                } else {
                    BonusProgramManagerPanel.this.programTypePanel.setVisible(false);
                }
            }
        });
        this.okCancelHelp.addActionListener(arg0 -> {
            try {
                if (arg0.getActionCommand().equals("ok")) {
                    BonusProgram program = new BonusProgram();
                    if (this.programTableModel.getSelectedRow() != null) {
                        program = (BonusProgram)this.programTableModel.getSelectedRow();
                    }
                    if (this.period.getDateCalendar1() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0412\u044b\u0441\u0442\u0430\u0432\u0438\u0442\u0435 \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043f\u0440\u0438\u0445\u043e\u0434\u0430", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    if (this.period.getDateCalendar2() != null && this.period.getDateCalendar1() != null && this.period.getDateCalendar1().compareTo(this.period.getDateCalendar2()) > 0) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041f\u0435\u0440\u0432\u0430\u044f \u0434\u0430\u0442\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043c\u0435\u043d\u044c\u0448\u0435!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    if (Utils.isBlankString((String)this.titleTextField.getText())) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    if (Utils.parseInt((String)this.bonusTypePaymentComboBox.getSelectedId(), (int)-1) < 1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u0431\u043e\u043d\u0443\u0441\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    int timeLagItemId = Utils.parseInt((String)this.timeLagComboBox.getSelectedId(), (int)-1);
                    if (timeLagItemId == -1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    switch (timeLagItemId) {
                        case 1: {
                            if (this.timeLagCalendarButton.getCalendar() != null) {
                                program.setTimeLag(TimeUtils.format((Calendar)this.timeLagCalendarButton.getCalendar(), (String)"dd.MM.yyyy"));
                                break;
                            }
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                            return;
                        }
                        case 2: {
                            if (Utils.isBlankString((String)this.timeLagTextField.getText())) {
                                program.setTimeLag("0");
                                break;
                            }
                            program.setTimeLag(this.timeLagTextField.getText());
                            break;
                        }
                        case 3: {
                            program.setTimeLag("startWeek");
                            break;
                        }
                        case 4: {
                            program.setTimeLag("startMonth");
                            break;
                        }
                        case 5: {
                            program.setTimeLag("startYear");
                        }
                    }
                    int activeTimeItemId = Utils.parseInt((String)this.activeTimeComboBox.getSelectedId(), (int)-1);
                    if (activeTimeItemId == -1) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    switch (activeTimeItemId) {
                        case 1: {
                            if (this.activeTimeCalendarButton.getCalendar() != null) {
                                program.setActiveTime(TimeUtils.format((Calendar)this.activeTimeCalendarButton.getCalendar(), (String)"dd.MM.yyyy"));
                                break;
                            }
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                            return;
                        }
                        case 2: {
                            if (Utils.isBlankString((String)this.activeTimeTextField.getText())) {
                                program.setActiveTime("0");
                                break;
                            }
                            program.setActiveTime(this.activeTimeTextField.getText());
                            break;
                        }
                        case 3: {
                            program.setActiveTime("endWeek");
                            break;
                        }
                        case 4: {
                            program.setActiveTime("endMonth");
                            break;
                        }
                        case 5: {
                            program.setActiveTime("endYear");
                        }
                    }
                    program.setTitle(this.titleTextField.getText().trim());
                    program.setPeriod(this.period.getPeriod());
                    program.setPaymentTypeId(Utils.parseInt((String)this.bonusTypePaymentComboBox.getSelectedId()));
                    if (this.programTypeComboBox.getSelectedId().equals(Integer.toString(1))) {
                        if (!this.operationProgramPanel.isCorrectData()) {
                            return;
                        }
                        program.setParams(this.operationProgramPanel.getParams());
                        program.setProgramTypeId(1);
                    } else {
                        program.setNameForDynamicClass(this.programTypeComboBox.getSelectedId());
                        program.setProgramTypeId(2);
                    }
                    if (program.getId() > 0 && ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).checkProgramPeriodOnCrossing(program)) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0421\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043e\u0439 \u0443 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043f\u0435\u0440\u0438\u043e\u0434 \u0432\u044b\u0445\u043e\u0434\u0438\u0442 \u0437\u0430 \u0433\u0440\u0430\u043d\u0438\u0446\u044b \u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                        return;
                    }
                    ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programUpdate(program);
                    this.programPanel.setVisible(false);
                    this.programTable.setEnabled(true);
                    this.performAction("refresh");
                } else if (arg0.getActionCommand().equals("cancel")) {
                    this.programPanel.setVisible(false);
                    this.programTable.setEnabled(true);
                } else if (arg0.getActionCommand().equals("reset")) {
                    this.setDataProgramTypePanel();
                }
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.programTypeComboBox.setModel(new DefaultComboBoxModel(BonusProgram.getVectorTypes((Map)((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programTypeMap().getMap())));
            DefaultComboBoxModel<ComboBoxItem> boxModel = new DefaultComboBoxModel<ComboBoxItem>();
            for (BonusPaymentType type : ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).paymentTypeList(true)) {
                boxModel.addElement(new ComboBoxItem(type.getId(), type.getTitle()));
            }
            this.bonusTypePaymentComboBox.setModel(boxModel);
            this.programTableModel.setData(((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programList(null));
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
            this.performAction("refresh");
            this.programTable.setEnabled(false);
            this.programPanel.setVisible(true);
            this.period.setPeriod(null);
            this.programTypeComboBox.setSelectedIndex(-1);
            this.titleTextField.setText("");
            this.timeLagTextField.setText("");
            this.activeTimeTextField.setText("");
            this.setVisibleComboBox(this.timeLagComboBox, this.timeLagCalendarButton, this.timeLagTextField);
            this.setVisibleComboBox(this.activeTimeComboBox, this.activeTimeCalendarButton, this.activeTimeTextField);
        });
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> this.setDataProgramTypePanel());
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            if (this.programTableModel.getSelectedRow() != null) {
                int programId = ((BonusProgram)this.programTableModel.getSelectedRow()).getId();
                if (((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programInContractList(programId, null).size() == 0) {
                    try {
                        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0443?", "", 2) == 0) {
                            ((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programDelete(programId);
                        }
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((String)ex.getLocalizedMessage());
                    }
                    this.performAction("refresh");
                } else {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0435\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0442\u0430\u043a \u043a\u0430\u043a \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430 \u0443\u0436\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0443 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432!", "", 1);
                }
            } else {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u0430 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0430", "", 1);
            }
        });
    }

    private void setVisibleComboBox(BGComboBox<ComboBoxItem> comboBox, BGCalendarButton calendarButton, IntTextField textField) {
        if (comboBox.getSelectedId().equals("1")) {
            textField.setVisible(false);
            calendarButton.setVisible(true);
        } else if (comboBox.getSelectedId().equals("2")) {
            textField.setVisible(true);
            calendarButton.setVisible(false);
        } else {
            textField.setVisible(false);
            calendarButton.setVisible(false);
        }
    }

    private void setDataProgramTypePanel() {
        this.programTable.setEnabled(false);
        if (this.programTable.getSelectedRow() != -1) {
            String typeId;
            BonusProgram selectProgram;
            block25: {
                this.programPanel.setVisible(true);
                this.programTypePanel.setVisible(false);
                selectProgram = (BonusProgram)this.programTableModel.getSelectedRow();
                this.bonusTypePaymentComboBox.setSelectedId(Integer.toString(selectProgram.getPaymentTypeId()));
                this.period.setPeriod(selectProgram.getPeriod());
                typeId = null;
                if (selectProgram.getProgramTypeId() == 2) {
                    try {
                        if (((BonusService)((ClientContext)this.getContext()).getPort(BonusService.class)).programTypeMap().getMap().get(selectProgram.getNameForDynamicClass()) == null) {
                            ClientUtils.showErrorMessageDialog((String)("\u041f\u043e\u0432\u0440\u0435\u0436\u0434\u0435\u043d\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \n\u041a\u043b\u0430\u0441\u0441 " + selectProgram.getNameForDynamicClass() + " \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d! \u041f\u043e\u043f\u0440\u0430\u0432\u0442\u0435 \u0434\u0438\u043d. \u043a\u043b\u0430\u0441\u0441 \u0438/\u0438\u043b\u0438 \u043a\u043e\u043d\u0444\u0438\u0433. \u043f\u043b\u0430\u0433\u0438\u043d\u0430. \u0438\u043b\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u0435 \u0434\u0440\u0443\u0433\u043e\u0439 \u0442\u0438\u043f."));
                            break block25;
                        }
                        typeId = selectProgram.getNameForDynamicClass();
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                } else {
                    typeId = Integer.toString(selectProgram.getProgramTypeId());
                }
            }
            this.programTypeComboBox.setSelectedId(typeId);
            this.titleTextField.setText(selectProgram.getTitle());
            if (Utils.parseInt((String)selectProgram.getTimeLag(), (int)-1) != -1) {
                this.timeLagComboBox.setSelectedId("2");
                this.timeLagTextField.setText(selectProgram.getTimeLag());
            } else if (TimeUtils.parseDate((String)selectProgram.getTimeLag(), (String)"dd.MM.yyyy") != null) {
                this.timeLagComboBox.setSelectedId("1");
                this.timeLagCalendarButton.setLocalDate(TimeUtils.parseLocalDate((String)selectProgram.getTimeLag(), (String)"dd.MM.yyyy"));
            } else if (selectProgram.getTimeLag().equals("startWeek")) {
                this.timeLagComboBox.setSelectedId("3");
            } else if (selectProgram.getTimeLag().equals("startMonth")) {
                this.timeLagComboBox.setSelectedId("4");
            } else if (selectProgram.getTimeLag().equals("startYear")) {
                this.timeLagComboBox.setSelectedId("5");
            }
            if (Utils.parseInt((String)selectProgram.getActiveTime(), (int)-1) != -1) {
                this.activeTimeComboBox.setSelectedId("2");
                this.activeTimeTextField.setText(selectProgram.getActiveTime());
            } else if (TimeUtils.parseDate((String)selectProgram.getActiveTime(), (String)"dd.MM.yyyy") != null) {
                this.activeTimeComboBox.setSelectedId("1");
                this.activeTimeCalendarButton.setLocalDate(TimeUtils.parseLocalDate((String)selectProgram.getActiveTime(), (String)"dd.MM.yyyy"));
            } else if (selectProgram.getActiveTime().equals("endWeek")) {
                this.activeTimeComboBox.setSelectedId("3");
            } else if (selectProgram.getActiveTime().equals("endMonth")) {
                this.activeTimeComboBox.setSelectedId("4");
            } else if (selectProgram.getActiveTime().equals("endYear")) {
                this.activeTimeComboBox.setSelectedId("5");
            }
            if (selectProgram.getProgramTypeId() == 1) {
                this.operationProgramPanel.setData(selectProgram);
                this.programTypePanel.setVisible(true);
            }
        }
    }

    private class OperationProgramPanel
    extends JPanel {
        protected BGComboBox<ComboBoxItem> accrualPeriodComboBox = new BGComboBox();
        protected IntTextField accrualPeriodDayTextField = new IntTextField(12);
        protected BGComboBox<ComboBoxItem> typeOperationComboBox = new BGComboBox();
        protected FloatTextField minSumOperationTextField = new FloatTextField();
        protected FloatTextField minSumAllOperationTextField = new FloatTextField();
        protected BGComboBox<ComboBoxItem> typeCalculationComboBox = new BGComboBox();
        protected FloatTextField rateCalculationTextField = new FloatTextField();
        protected JTextField rankCalculationTextField = new JTextField(12);
        protected JTextField operationIdTextField = new JTextField(12);

        public OperationProgramPanel() {
            this.accrualPeriodComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(new ComboBoxItem[]{new ComboBoxItem(1, "\u0415\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u044b\u0439"), new ComboBoxItem(2, "\u041c\u0435\u0441\u044f\u0447\u043d\u044b\u0439"), new ComboBoxItem(3, "\u041f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0439"), new ComboBoxItem(4, "\u041c\u043e\u043c\u0435\u043d\u0442\u0430\u043b\u044c\u043d\u044b\u0439")}));
            this.typeOperationComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(new ComboBoxItem[]{new ComboBoxItem(1, "\u041f\u0440\u0438\u0445\u043e\u0434"), new ComboBoxItem(2, "\u0420\u0430\u0441\u0445\u043e\u0434"), new ComboBoxItem(3, "\u041d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0430")}));
            this.typeCalculationComboBox.setModel(new DefaultComboBoxModel<ComboBoxItem>(new ComboBoxItem[]{new ComboBoxItem(1, "\u041f\u0440\u043e\u0446\u0435\u043d\u0442\u043d\u044b\u0439"), new ComboBoxItem(2, "\u0410\u0431\u0441\u043e\u043b\u044e\u0442\u043d\u044b\u0439"), new ComboBoxItem(3, "\u041f\u043e\u0448\u0430\u0433\u043e\u0432\u044b\u0439"), new ComboBoxItem(4, "\u041f\u0440\u043e\u0438\u0437\u0432\u043e\u043b\u044c\u043d\u044b\u0439")}));
            this.accrualPeriodDayTextField.setEditable(false);
            this.rankCalculationTextField.setVisible(false);
            JPanel typePanel = new JPanel(new GridBagLayout());
            typePanel.setBackground(Color.WHITE);
            typePanel.add((Component)this.typeCalculationComboBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            typePanel.add((Component)this.rateCalculationTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            typePanel.add((Component)this.rankCalculationTextField, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            JPanel panel = new JPanel(new GridBagLayout());
            panel.setBackground(Color.WHITE);
            panel.add((Component)new JLabel("\u0422\u0438\u043f \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.typeOperationComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.accrualPeriodComboBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0414\u043d\u0438"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.accrualPeriodDayTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.minSumOperationTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)this.minSumAllOperationTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0422\u0438\u043f \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0431\u043e\u043d\u0443\u0441\u043e\u0432"), new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            panel.add((Component)typePanel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("ID \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439"), new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            panel.add((Component)this.operationIdTextField, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.setLayout(new GridBagLayout());
            this.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.typeOperationComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (OperationProgramPanel.this.typeOperationComboBox.getSelectedId().equals("3")) {
                        OperationProgramPanel.this.accrualPeriodComboBox.setSelectedId("2");
                        OperationProgramPanel.this.accrualPeriodComboBox.setEnabled(false);
                    } else {
                        OperationProgramPanel.this.accrualPeriodComboBox.setEnabled(true);
                    }
                }
            });
            this.accrualPeriodComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (OperationProgramPanel.this.accrualPeriodComboBox.getSelectedId().equals("3") || OperationProgramPanel.this.accrualPeriodComboBox.getSelectedId().equals("2")) {
                        OperationProgramPanel.this.accrualPeriodDayTextField.setEditable(true);
                    } else {
                        OperationProgramPanel.this.accrualPeriodDayTextField.setEditable(false);
                        OperationProgramPanel.this.accrualPeriodDayTextField.setText("");
                    }
                    if (OperationProgramPanel.this.accrualPeriodComboBox.getSelectedId().equals("4")) {
                        OperationProgramPanel.this.minSumAllOperationTextField.setEditable(false);
                        OperationProgramPanel.this.minSumAllOperationTextField.setText("");
                    } else {
                        OperationProgramPanel.this.minSumAllOperationTextField.setEditable(true);
                    }
                }
            });
            this.typeCalculationComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean fVisible = false;
                    if (OperationProgramPanel.this.typeCalculationComboBox.getSelectedId().equals("4")) {
                        fVisible = true;
                    }
                    OperationProgramPanel.this.rankCalculationTextField.setVisible(fVisible);
                    OperationProgramPanel.this.rateCalculationTextField.setVisible(!fVisible);
                }
            });
        }

        public void setData(BonusProgram program) {
            HashMap params = program.getParams();
            this.typeOperationComboBox.setSelectedId((String)params.get("typeOperation"));
            this.accrualPeriodComboBox.setSelectedId((String)params.get("accrualPeriod"));
            this.accrualPeriodDayTextField.setText("");
            if (params.get("accrualPeriod") != null && (((String)params.get("accrualPeriod")).equals("3") || ((String)params.get("accrualPeriod")).equals("2"))) {
                this.accrualPeriodDayTextField.setText((String)params.get("accrualPeriodDay"));
            }
            this.minSumOperationTextField.setText((String)params.get("minSumOperation"));
            this.minSumAllOperationTextField.setText((String)params.get("minSumOperationAll"));
            this.typeCalculationComboBox.setSelectedId((String)params.get("typeCalculation"));
            if (this.typeCalculationComboBox.getSelectedId().equals("4")) {
                this.rankCalculationTextField.setText((String)params.get("valueCalculation"));
            } else {
                this.rateCalculationTextField.setText((String)params.get("valueCalculation"));
            }
            this.operationIdTextField.setText((String)params.get("operationTypeId"));
        }

        public boolean isCorrectData() {
            Matcher m;
            Pattern p;
            if (this.accrualPeriodComboBox.getSelectedId().equals("2")) {
                if (Utils.parseInt((String)this.accrualPeriodDayTextField.getText(), (int)-1) < 1) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u0434\u0435\u043d\u044c \u043c\u0435\u0441\u044f\u0446\u0430!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                    return false;
                }
                if (Utils.parseInt((String)this.accrualPeriodDayTextField.getText(), (int)-1) > 28 && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412 \u043d\u0435\u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u0435\u0441\u044f\u0446\u0430\u0445 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u043e\u0438\u0441\u0445\u043e\u0434\u0438\u0442\u044c \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435! \u0412\u044b \u0432\u0441\u0435 \u0440\u0430\u0432\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u043f\u0440\u043e\u0434\u043e\u043b\u0436\u0438\u0442\u044c") != 0) {
                    return false;
                }
            }
            if (this.accrualPeriodComboBox.getSelectedId().equals("3") && Utils.parseInt((String)this.accrualPeriodDayTextField.getText(), (int)-1) < 1) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u043a\u043e\u043b-\u0432\u043e \u0434\u043d\u0435\u0439 \u043c\u0435\u0436\u0434\u0443 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f\u043c\u0438 \u0431\u043e\u043d\u0443\u0441\u043e\u0432!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                return false;
            }
            if (!this.typeCalculationComboBox.getSelectedId().equals("4")) {
                if (Utils.parseBigDecimal((String)this.rateCalculationTextField.getText(), (BigDecimal)new BigDecimal(-1)).compareTo(BigDecimal.ZERO) == -1) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - \"\u0422\u0438\u043f \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0431\u043e\u043d\u0443\u0441\u043e\u0432\"!", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                    return false;
                }
            } else {
                p = Pattern.compile("^(\\d+-\\d+)(,\\d+-\\d+)*");
                m = p.matcher(this.rankCalculationTextField.getText());
                if (!m.matches()) {
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - \"\u0422\u0438\u043f \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0431\u043e\u043d\u0443\u0441\u043e\u0432\"(\u041f\u0440\u0438\u043c\u0435\u0440: 50-5,100-12,200-17)", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                    return false;
                }
            }
            if (!Utils.isBlankString((String)this.operationIdTextField.getText()) && !(m = (p = Pattern.compile("^(\\d+)(,\\d+)*")).matcher(this.operationIdTextField.getText())).matches()) {
                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 - \"ID \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439\"(\u041f\u0440\u0438\u043c\u0435\u0440: \"50,3,6\" \u0438\u043b\u0438 \u043f\u0443\u0441\u0442\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430)", "\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", 1);
                return false;
            }
            return true;
        }

        public HashMap<String, String> getParams() {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("typeOperation", this.typeOperationComboBox.getSelectedId());
            params.put("accrualPeriod", this.accrualPeriodComboBox.getSelectedId());
            if (this.accrualPeriodComboBox.getSelectedId().equals("3") || this.accrualPeriodComboBox.getSelectedId().equals("2")) {
                params.put("accrualPeriodDay", this.accrualPeriodDayTextField.getText());
            }
            if (!Utils.isBlankString((String)this.minSumOperationTextField.getText())) {
                params.put("minSumOperation", this.minSumOperationTextField.getText());
            } else {
                params.put("minSumOperation", "0");
            }
            if (this.minSumAllOperationTextField.isEditable() && !Utils.isBlankString((String)this.minSumAllOperationTextField.getText())) {
                params.put("minSumOperationAll", this.minSumAllOperationTextField.getText());
            } else {
                params.put("minSumOperationAll", "0");
            }
            params.put("typeCalculation", this.typeCalculationComboBox.getSelectedId());
            if (this.typeCalculationComboBox.getSelectedId().equals("4")) {
                params.put("valueCalculation", this.rankCalculationTextField.getText());
            } else {
                params.put("valueCalculation", this.rateCalculationTextField.getText());
            }
            if (!Utils.isBlankString((String)this.operationIdTextField.getText())) {
                params.put("operationTypeId", this.operationIdTextField.getText());
            }
            return params;
        }
    }

    class BonusProgramTableModel
    extends BGTableModel<BonusProgram> {
        public BonusProgramTableModel() {
            super(BonusProgramTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", -1, 200, 200, "period", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b", -1, 350, 500, "specificationTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }
    }
}

