/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.task;

import java.sql.Connection;
import java.util.List;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.AutoprintProcessor;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class AutoprintReprintAsIsBatch
extends RunTask {
    private List<Payment> logPayments;

    public AutoprintReprintAsIsBatch(List<Payment> logPayments) {
        this.logPayments = logPayments;
    }

    public String getDescription() {
        return "\u041f\u043b\u0430\u0433\u0438\u043d CashCheck. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0440\u0435\u043f\u0435\u0447\u0430\u0442\u0438 \u0438\u0437 \u043b\u043e\u0433\u0430 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0445/\u043d\u043e\u0432\u044b\u0445 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u043a\u0430\u043a \u0435\u0441\u0442\u044c (" + this.logPayments.size() + "\u0448\u0442)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        Connection conSlave = this.setup.getDBSlaveConnectionFromPool();
        try {
            this.processQueue(con, conSlave);
        }
        catch (Exception e) {
            this.getLogger().error("error AutoprintReprintAsIsBatch task", (Throwable)e);
        }
        finally {
            ServerUtils.closeConnection((Connection)con, (Connection)conSlave);
        }
    }

    private void processQueue(Connection con, Connection conSlave) throws BGException {
        try (PaymentDao pm = new PaymentDao(con);){
            this.getLogger().info("cashcheck autoprint: reprint error as is batch: queue size: " + this.logPayments.size() + "...");
            for (Payment p : this.logPayments) {
                AutoprintProcessor.processErroredAsIsPayment(p, this.setup, con, conSlave);
                try {
                    CashCheckUtils.sleepBatch();
                }
                catch (InterruptedException e) {
                    pm.close();
                    return;
                }
            }
        }
    }

    public String getUniqueKeyQueue() {
        List logids = this.logPayments.stream().map(p -> p.getLogId()).collect(Collectors.toList());
        return "cashcheck-reprint-" + Utils.toString(logids);
    }

    public String getUniqueKeyParallel() {
        return "cashcheck-reprint";
    }
}

