/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.client.tariff;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.Utils;

public class PacketCountFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private IntTextField packetCount;
    private BGComboBox<ComboBoxItem> compare;
    private JCheckBox excludeDiscountIgnore;
    private JCheckBox onlyCurrent;
    private JCheckBox onContractTotal;
    private JLabel viewLabel = new JLabel();
    private JPanel editor;

    public PacketCountFilterTariffTreeNode() {
        this.viewLabel.setIcon(ClientUtils.getIcon((String)"filter"));
    }

    protected JPanel getEditorPanel() {
        this.editor = new JPanel(new GridBagLayout());
        this.compare = new BGComboBox();
        this.compare.addItem((Object)new ComboBoxItem((Object)"<", "<"));
        this.compare.addItem((Object)new ComboBoxItem((Object)"<=", "<="));
        this.compare.addItem((Object)new ComboBoxItem((Object)"=", "="));
        this.compare.addItem((Object)new ComboBoxItem((Object)">=", ">="));
        this.compare.addItem((Object)new ComboBoxItem((Object)">", ">"));
        this.packetCount = new IntTextField();
        this.packetCount.setColumns(4);
        this.excludeDiscountIgnore = new JCheckBox("\u041d\u0435 \u0443\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \"\u043d\u0435 \u0443\u0447\u0430\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u0432 \u0441\u043a\u0438\u0434\u043a\u0435\"");
        this.onlyCurrent = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0443\u0449\u0438\u0445 \u043f\u0430\u043a\u0435\u0442\u043e\u0432");
        this.onContractTotal = new JCheckBox("\u041d\u0430 \u0432\u0441\u0451\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435");
        this.editor.add((Component)new JLabel("\u0415\u0441\u043b\u0438 \u043f\u0430\u043a\u0435\u0442\u043e\u0432 "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editor.add((Component)this.compare, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.packetCount, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.onContractTotal, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.onlyCurrent, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.editor.add((Component)this.excludeDiscountIgnore, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.onlyCurrent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PacketCountFilterTariffTreeNode.this.onlyCurrent.isSelected()) {
                    PacketCountFilterTariffTreeNode.this.onContractTotal.setSelected(true);
                    PacketCountFilterTariffTreeNode.this.onContractTotal.setEnabled(false);
                } else {
                    PacketCountFilterTariffTreeNode.this.onContractTotal.setEnabled(true);
                }
            }
        });
        return this.editor;
    }

    public Component getView() {
        Map data = this.getDataInHash();
        String compare = (String)data.get("compare");
        String packetCount = (String)data.get("packet_count");
        boolean exclude_discount_ignore = Utils.parseBoolean((String)((String)data.get("exclude_discount_ignore")));
        boolean only_current_packet = Utils.parseBoolean((String)((String)data.get("only_current_packet")));
        boolean on_contract_total = Utils.parseBoolean((String)((String)data.get("on_contract_total")));
        StringBuffer buf = new StringBuffer(150);
        buf.append("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e ");
        buf.append(on_contract_total ? "[\u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435] " : "[\u043d\u0430 \u043a\u0430\u0440\u0442\u0435] ");
        buf.append(only_current_packet ? "[\u0442\u0435\u043a\u0443\u0449\u0438\u0445] " : "[\u043b\u044e\u0431\u044b\u0445] ");
        buf.append("\u043f\u0430\u043a\u0435\u0442\u043e\u0432 ");
        if (compare != null) {
            buf.append(compare);
            buf.append(" ");
        }
        if (packetCount != null) {
            buf.append(packetCount);
        }
        if (exclude_discount_ignore) {
            buf.append(" (\u0431\u0435\u0437 \u0443\u0447\u0451\u0442\u0430 \"\u043d\u0435 \u0443\u0447\u0430\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0445 \u0432 \u0441\u043a\u0438\u0434\u043a\u0435\")");
        }
        this.viewLabel.setText(buf.toString());
        return this.viewLabel;
    }

    protected void loadData() {
        Map data = this.getDataInHash();
        String compare = (String)data.get("compare");
        if (compare != null) {
            ClientUtils.setComboBoxSelection(this.compare, (Object)compare);
        }
        String packetCount = (String)data.get("packet_count");
        this.packetCount.setText(packetCount);
        boolean exclude_discount_ignore = Utils.parseBoolean((String)((String)data.get("exclude_discount_ignore")));
        this.excludeDiscountIgnore.setSelected(exclude_discount_ignore);
        boolean only_current_packet = Utils.parseBoolean((String)((String)data.get("only_current_packet")));
        this.onlyCurrent.setSelected(only_current_packet);
        boolean on_contract_total = Utils.parseBoolean((String)((String)data.get("on_contract_total")));
        this.onContractTotal.setSelected(on_contract_total);
    }

    protected void serializeData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        ComboBoxItem compare = (ComboBoxItem)this.compare.getSelectedItem();
        data.put("compare", compare.getObject());
        data.put("packet_count", this.packetCount.getText());
        data.put("exclude_discount_ignore", this.excludeDiscountIgnore.isSelected());
        data.put("only_current_packet", this.onlyCurrent.isSelected());
        data.put("on_contract_total", this.onContractTotal.isSelected());
        this.setDataInHash(data);
    }

    public void setModuleTitle(String value) {
        this.viewLabel.setText(value);
    }
}

