/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.action;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractUtils;
import bitel.billing.server.tariff.TariffModuleTree;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.hd.server.AgentAction;
import ru.bitel.bgbilling.modules.hd.server.AgentDriver;
import ru.bitel.bgbilling.modules.hd.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.hd.server.bean.CPDomain;
import ru.bitel.bgbilling.modules.hd.server.bean.CPDomainManager;
import ru.bitel.bgbilling.modules.hd.server.bean.CPEvent;
import ru.bitel.bgbilling.modules.hd.server.bean.CPEventManager;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHost;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHostManager;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHosting;
import ru.bitel.bgbilling.modules.hd.server.bean.CPHostingManager;
import ru.bitel.bgbilling.modules.hd.server.bean.CPNs;
import ru.bitel.bgbilling.modules.hd.server.bean.CPNsManager;
import ru.bitel.bgbilling.modules.hd.server.bean.ContractPackage;
import ru.bitel.bgbilling.modules.hd.server.bean.ContractPackageManager;
import ru.bitel.bgbilling.modules.hd.server.bean.HdPackage;
import ru.bitel.bgbilling.modules.hd.server.bean.HdPackageManager;
import ru.bitel.bgbilling.modules.hd.server.bean.PeriodManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionContractPackageUpdate
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        try (BalanceUtils bu = new BalanceUtils(this.con);){
            ContractPackage cp;
            ContractPackageManager cpManager;
            HdPackage hdPackage;
            boolean deactivate;
            boolean update;
            boolean prolongate;
            boolean activate;
            int periodId;
            Float cost;
            GregorianCalendar now;
            PeriodManager pm;
            CPEventManager eventManager;
            block56: {
                Set<AgentDriver> agents;
                List<AgentAction> actions;
                int id = this.getIntParameter("id", 0);
                int pid = this.getIntParameter("pid", -1);
                String hdAction = this.getParameter("hd_action");
                if (this.mid <= 0 || this.cid <= 0 || Utils.isBlankString((String)hdAction)) {
                    throw new BGIllegalArgumentException();
                }
                ContractManager cm = new ContractManager(this.con);
                Contract contract = cm.getContractById(this.cid);
                eventManager = new CPEventManager(this.con, this.mid);
                pm = new PeriodManager(this.con, this.mid);
                ContractUtils cu = new ContractUtils(this.con);
                now = new GregorianCalendar();
                cost = null;
                periodId = 0;
                activate = hdAction.startsWith("activate");
                prolongate = hdAction.startsWith("prolongate");
                update = hdAction.equals("update");
                deactivate = hdAction.equals("unactivate");
                HdPackageManager packageManager = new HdPackageManager(this.con, this.mid);
                hdPackage = packageManager.getPackage(pid);
                if (activate || prolongate) {
                    int pos = hdAction.indexOf(95);
                    if (pos < 0) {
                        throw new BGMessageException("Error hd_action param");
                    }
                    periodId = Utils.parseInt((String)hdAction.substring(pos + 1));
                    TariffTreeSet treeSet = cm.getTariffTreeSetForDay(this.cid, (Calendar)now, "hd", this.mid, true);
                    if (treeSet.getTreeList().size() == 0) {
                        throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0430\u0440\u0438\u0444\u043d\u044b\u0439 \u043f\u043b\u0430\u043d \u043d\u0430 \u0434\u0430\u0442\u0443: " + TimeUtils.formatDate((Calendar)now));
                    }
                    TariffModuleTree tree = (TariffModuleTree)treeSet.getTreeList().get(0);
                    TariffRequest req = new TariffRequest();
                    req.setRequestParam("time", (Object)now);
                    if (activate) {
                        req.setRequestParam("type", (Object)1);
                    } else {
                        req.setRequestParam("type", (Object)2);
                    }
                    req.setRequestParam("package", (Object)hdPackage.getId());
                    req.setRequestParam("period", (Object)periodId);
                    tree.processRequest(req);
                    cost = (Float)req.getResponseParam("cost");
                    if (!req.wasAccepted() || cost == null) {
                        throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0446\u0435\u043d\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444\u043d\u043e\u043c \u043f\u043b\u0430\u043d\u0435!");
                    }
                    if (contract.getBalanceMode() == 1 && bu.getBalance(LocalDate.now(), this.cid).floatValue() < contract.getBalanceLimit().floatValue()) {
                        throw new BGMessageException("\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u0435\u043d\u0435\u0433 \u043d\u0430 \u0441\u0447\u0435\u0442\u0435 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438/\u043f\u0440\u043e\u0434\u043b\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u0443\u0433\u0438!");
                    }
                }
                cpManager = new ContractPackageManager(this.con, this.mid);
                CPDomainManager domainManager = new CPDomainManager(this.con, this.mid);
                CPNsManager nsManager = new CPNsManager(this.con, this.mid);
                CPHostManager hostManager = new CPHostManager(this.con, this.mid);
                CPHostingManager hostingManager = new CPHostingManager(this.con, this.mid);
                cp = null;
                if (id > 0) {
                    cp = cpManager.getContractPackage(id);
                } else {
                    cp = new ContractPackage();
                    cp.setContractId(this.cid);
                    cp.setStatus(0);
                }
                cp.setPackageId(pid);
                cp.setNsDomain(this.getParameter("ns_domain", ""));
                cpManager.updateContractPackage(cp);
                this.rootNode.setAttribute("id", String.valueOf(cp.getId()));
                if (hdPackage.isDomainEnable()) {
                    CPDomain domain = new CPDomain();
                    domain.setContractPackageId(cp.getId());
                    domain.setDomain(this.getParameter("domain"));
                    domain.setAdminMail(this.getParameter("admin_mail"));
                    if (Utils.isBlankString((String)domain.getDomain())) {
                        throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u0434\u043e\u043c\u0435\u043d\u0430!");
                    }
                    if (Utils.isBlankString((String)domain.getAdminMail())) {
                        throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d E-Mail \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430 \u0434\u043e\u043c\u0435\u043d\u0430!");
                    }
                    if (!this.checkName(domain.getDomain())) {
                        throw new BGMessageException("\u0418\u043c\u044f \u0434\u043e\u043c\u0435\u043d\u0430 '" + domain.getDomain() + "' \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b!");
                    }
                    domainManager.updateDomain(domain);
                }
                if (hdPackage.isNsEnable()) {
                    ArrayList<CPNs> nsList = new ArrayList<CPNs>();
                    if (Utils.isBlankString((String)cp.getNsDomain())) {
                        throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0438\u043c\u044f \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0433\u043e \u043d\u0430 NS \u0434\u043e\u043c\u0435\u043d\u0430!");
                    }
                    nsManager.updatePackageNs(cp.getId(), nsList);
                }
                if (hdPackage.isHostEnable()) {
                    ArrayList<CPHost> hostList = new ArrayList<CPHost>();
                    String packages = null;
                    if (hdPackage.getHostDomain() > 0) {
                        packages = packageManager.getTypesWithHostsInZone(hdPackage.getHostDomain());
                    }
                    List hosts = Utils.stringToPairs((String)this.getParameter("host_list", ""), (String)",", (String)":");
                    for (String[] pair : hosts) {
                        int conflictCid;
                        CPHost host = new CPHost();
                        host.setHost(pair[0]);
                        host.setAddr(pair[1]);
                        if (Utils.notBlankString((String)packages) && (conflictCid = hostManager.checkHost(packages, cp.getId(), host.getHost())) > 0) {
                            throw new BGMessageException("\u0425\u043e\u0441\u0442 " + host.getHost() + " \u0443\u0436\u0435 \u0437\u0430\u0432\u0435\u0434\u0435\u043d \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 " + cu.getContractTitle(conflictCid, true));
                        }
                        if (!this.checkName(host.getHost())) {
                            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0445\u043e\u0441\u0442\u0430 '" + host.getHost() + "'!");
                        }
                        hostList.add(host);
                    }
                    hostManager.updateHost(cp.getId(), hostList);
                }
                if (hdPackage.isHostingEnable()) {
                    CPHosting hosting = new CPHosting();
                    hosting.setContractPackageId(cp.getId());
                    hosting.setHostList(Utils.toList((String)this.getParameter("hosting_host")));
                    hosting.setData("");
                    hostingManager.updateHosting(hosting);
                }
                if (activate || update) {
                    try {
                        actions = this.getActions(hdPackage, cp);
                        agents = this.checkAgents(actions);
                        this.tryDo(actions);
                        Object lastDriver = null;
                        try {
                            for (AgentDriver driver : agents) {
                                lastDriver = driver;
                                try {
                                    driver.connect();
                                    driver.reload();
                                }
                                catch (Exception ex) {
                                    throw ex;
                                }
                                finally {
                                    driver.disconnect();
                                }
                            }
                            break block56;
                        }
                        catch (Exception e) {
                            this.rollback(actions, actions.size() - 1);
                            try {
                                ((AgentDriver)lastDriver).connect();
                                ((AgentDriver)lastDriver).reload();
                                ((AgentDriver)lastDriver).disconnect();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            throw new BGException(e.toString());
                        }
                    }
                    catch (Exception e) {
                        throw new BGException(e.toString());
                    }
                }
                if (deactivate) {
                    try {
                        actions = this.getActions(hdPackage, cp);
                        agents = this.checkAgents(actions);
                        this.rollback(actions, actions.size() - 1);
                        for (AgentDriver driver : agents) {
                            driver.connect();
                            driver.reload();
                            driver.disconnect();
                        }
                    }
                    catch (Exception e) {
                        throw new BGException(e.toString());
                    }
                }
            }
            if (!update) {
                CPEvent event = new CPEvent();
                event.setContractId(cp.getContractId());
                event.setPackageId(cp.getId());
                event.setServiceId(hdPackage.getServiceId());
                if (activate) {
                    event.setType(1);
                    event.setPeriodId(periodId);
                    event.setSumma(cost.floatValue());
                } else if (prolongate) {
                    event.setType(2);
                    event.setPeriodId(periodId);
                    event.setSumma(cost.floatValue());
                } else if (deactivate) {
                    event.setType(3);
                }
                event.setTime(now);
                eventManager.addEvent(event);
                if (activate) {
                    period = pm.getPeriod(event.getPeriodId());
                    GregorianCalendar date1 = new GregorianCalendar();
                    Calendar date2 = period.getEndDate(date1);
                    cp.setDate1(date1);
                    cp.setDate2(date2);
                    cp.setStatus(1);
                    cpManager.updateContractPackage(cp);
                } else if (deactivate) {
                    GregorianCalendar date2 = new GregorianCalendar();
                    cp.setDate2(date2);
                    cp.setStatus(0);
                    cpManager.updateContractPackage(cp);
                } else if (prolongate) {
                    period = pm.getPeriod(event.getPeriodId());
                    Calendar date2 = cp.getDate2();
                    date2 = period.getEndDate(date2);
                    cpManager.updateContractPackage(cp);
                }
                if (prolongate || activate) {
                    eventManager.setContractAccountFromEvent(this.cid, now);
                    bu.setBalanceFromAccount(this.cid, (Calendar)now);
                }
            }
        }
    }
}

