/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.action;

import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.hd.common.bean.Zone;
import ru.bitel.bgbilling.modules.hd.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.hd.server.bean.ZoneDAO;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ActionGetContractZoneTable
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (Zone zone : new ZoneDAO(this.con, this.mid).getZoneList(this.cid)) {
            StringBuffer zoneBuffer = new StringBuffer();
            zoneBuffer.append(zone.getZone());
            if (!zone.getZone().equals(zone.getZonePunycode())) {
                zoneBuffer.append(" (");
                zoneBuffer.append(zone.getZonePunycode());
                zoneBuffer.append(")");
            }
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(zone.getId()));
            row.setAttribute("zone", zoneBuffer.toString());
            row.setAttribute("period", TimeUtils.formatPeriod((Period)zone.getPeriod()));
            row.setAttribute("comment", zone.getComment());
            row.setAttribute("whois", String.valueOf(zone.isLoadWhois()));
            row.setAttribute("avto", String.valueOf(zone.isAvto()));
        }
    }
}

