/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.server.task;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Message;
import ru.bitel.bgbilling.plugins.helpdesk.common.bean.Topic;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.ParamManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicListFilter;
import ru.bitel.bgbilling.plugins.helpdesk.server.bean.TopicManager;
import ru.bitel.bgbilling.plugins.helpdesk.server.mail.MailTaskTopicAvtoClosed;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Preferences;

public class TopicAvtoClosedTask
extends TaskBase {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.helpdesk");

    public String getDescription() {
        return this.defaultDescription + "\u041f\u043b\u0430\u0433\u0438\u043d HelpDesk. \u0417\u0430\u0434\u0430\u0447\u0430 \u0430\u0432\u0442\u043e\u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u0442\u0435\u043c.";
    }

    protected boolean initTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            StringBuilder report = new StringBuilder();
            int topicAvtoClosedPeriod = this.taskSetup.getInt("topic.avto.closed.period", 0);
            if (topicAvtoClosedPeriod > 0) {
                String email;
                GregorianCalendar now = new GregorianCalendar();
                TopicManager topicManager = new TopicManager(con, this.plugin);
                TopicListFilter tf = new TopicListFilter();
                tf.setAllMessage(true);
                tf.setNewUserMessage(true);
                tf.setNewManagerMessage(true);
                ParamManager paramManager = new ParamManager(con, this.plugin);
                List<Topic> topicList = topicManager.getTopicList(tf);
                ArrayList<Topic> topicMaybeClosed = new ArrayList<Topic>();
                for (Topic topic : topicList) {
                    Message message;
                    if (!topic.isAutoClose()) continue;
                    topicManager.loadMessages(topic);
                    List messageList = topic.getMessages();
                    if (messageList == null || messageList.size() <= 0 || topic.getMessageNewManagerCount() != 0 || topic.getMessageNewUserCount() != 0 || (message = (Message)messageList.get(messageList.size() - 1)).getUserIdFrom() <= 0 || message.getUserIdTo() != 0) continue;
                    GregorianCalendar dateTo = new GregorianCalendar();
                    dateTo.setTime(message.getDateTo());
                    ((Calendar)dateTo).add(5, topicAvtoClosedPeriod);
                    if (!dateTo.before(now)) continue;
                    if (topic.getStatus() == 0) {
                        topicMaybeClosed.add(topic);
                        continue;
                    }
                    Properties properties = paramManager.getProperties(topic.getContractId());
                    String currentId = properties.getProperty("mode.id", this.plugin.getSetup().get("mode.default.id", "off"));
                    topicManager.setTopicClosed(topic.getId(), true, currentId.equals("package"), 0);
                    report.append(topic.getContract());
                    report.append(" => \u0422\u0435\u043c\u0430: [" + topic.getId() + "] ");
                    report.append(topic.getTitle() + "; ");
                    report.append("\u0441\u0442\u0430\u0442\u0443\u0441: ");
                    report.append(topicManager.getStatusName(topic.getStatus()) + "; ");
                    report.append("\u0432\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0432 \u043f\u0430\u043a\u0435\u0442: ");
                    if (topic.getContractPackageId() > 0) {
                        report.append("\u0434\u0430");
                    } else {
                        report.append("\u043d\u0435\u0442");
                    }
                    report.append("\n");
                }
                if (topicMaybeClosed.size() > 0) {
                    report.append("\n");
                    report.append("\u0422\u0435\u043c\u044b \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044c, \u043d\u043e \u0443 \u043d\u0438\u0445 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u0442\u0430\u0442\u0443\u0441:\n");
                    for (Topic t : topicMaybeClosed) {
                        report.append(t.getContract());
                        report.append(" => \u0422\u0435\u043c\u0430: [" + t.getId() + "] ");
                        report.append(t.getTitle() + "; ");
                        report.append("\u0432\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u0432 \u043f\u0430\u043a\u0435\u0442: ");
                        if (t.getContractPackageId() > 0) {
                            report.append("\u0434\u0430 \n");
                            continue;
                        }
                        report.append("\u043d\u0435\u0442 \n");
                    }
                }
                if ((email = this.taskSetup.get("mail.to", null)) != null && !email.isEmpty() && report.length() > 0) {
                    new MailMsg((Preferences)this.setup).sendMessage(new MailTaskTopicAvtoClosed().setRecipients(email).setSubject(this.taskSetup.get("mail.subject", "HelpDesk => \u043e\u0442\u0447\u0435\u0442 \u043e \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u0445 \u0442\u0435\u043c\u0430\u0445")).addTextPart("text", report.toString()));
                }
            } else {
                this.getLogger().warn("Not set valid param => topic.avto.closed.period");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection((Connection)con);
        }
    }
}

