/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.helpdesk.client.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.plugins.helpdesk.common.service.HelpdeskService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;

public class HelpDeskTableTabInDirectory
extends BGPanel {
    private BGUTable table = null;
    private BGTableModel<IdTitle> tableModel;
    private BGControlPanelPages controlPanelPages = new BGControlPanelPages();
    private JLabel label = new JLabel();
    String title;
    String titleN;
    String getAction;
    String setAction;
    String deleteAction;

    public HelpDeskTableTabInDirectory(String titleBorder, String titleName, String getAction, String setAction, String deleteAction) {
        this.title = titleBorder;
        this.titleN = titleName;
        this.module = "ru.bitel.bgbilling.plugins.helpdesk";
        this.getAction = getAction;
        this.setAction = setAction;
        this.deleteAction = deleteAction;
        this.controlPanelPages.setKey(titleName);
        this.controlPanelPages.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.setData();
            }
        });
        this.tableModel = new BGTableModel<IdTitle>(this.titleN){

            protected void initColumns() {
                this.addColumnId();
                this.addColumn(HelpDeskTableTabInDirectory.this.titleN, String.class, -1, 150, -1, "title", true, true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            }
        };
        this.table = new BGUTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.setDefaultEditor(this.table.getColumnClass(1), (TableCellEditor)new HelpDeskCellEditor());
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    HelpDeskCellEditor editor = (HelpDeskCellEditor)HelpDeskTableTabInDirectory.this.table.getDefaultEditor(String.class);
                    editor.stopCellEditorForEnter();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(this.getFilterPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.003, 12, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.getTablejScrollPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0424\u0438\u043b\u044c\u0442\u0440"));
        panel.add((Component)this.label, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.controlPanelPages, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JScrollPane getTablejScrollPane() {
        JScrollPane ScrollPane = new JScrollPane();
        ScrollPane.getViewport().add((Component)this.table);
        ScrollPane.setBorder(new TitledBorder(this.title));
        return ScrollPane;
    }

    public void newItem() {
        boolean flag = true;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            if (!this.tableModel.getValueAt(i, 1).equals("\u041d\u043e\u0432\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430")) continue;
            flag = false;
        }
        if (flag) {
            this.tableModel.addRow((Object)new IdTitle(0, "\u041d\u043e\u0432\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430"));
            this.table.repaint();
        }
    }

    public void deleteItem() {
        if (this.tableModel.getSelectedRow() != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0441\u0442\u0440\u043e\u043a\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Element tableElement;
            Document doc;
            String id = (String)this.tableModel.getValueAt(this.table.getSelectedRow(), 0);
            Request request = new Request();
            if (this.getAction.equals("GetGroupList")) {
                request.setModule(this.module);
                request.setAction("InspectionGroupContract");
                request.setAttribute("groupId", id);
                doc = this.getDocument(request);
                if (ClientUtils.checkStatus((Document)doc)) {
                    tableElement = XMLUtils.selectElement((Node)doc, (String)"//table/data/row");
                    int countGroup = Utils.parseInt((String)tableElement.getAttribute("countGroup"), (int)-1);
                    int countPattern = Utils.parseInt((String)tableElement.getAttribute("countPattern"), (int)-1);
                    Object stringPattern = "";
                    if (countPattern > 0) {
                        stringPattern = ", \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 " + countPattern;
                    }
                    if ((countGroup > 0 || countPattern > 0) && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432 \u0433\u0440\u0443\u043f\u043f\u0435 " + countGroup + (String)stringPattern + ". \u0412\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                        request = new Request();
                        request.setModule(this.module);
                        request.setAction(this.deleteAction);
                        request.setAttribute("id", id);
                        request.setAttribute("countPattern", countPattern);
                        if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                            this.setData();
                            this.updateUI();
                            this.repaint();
                        }
                    }
                    if (countGroup == 0 && countPattern == 0) {
                        request = new Request();
                        request.setModule(this.module);
                        request.setAction(this.deleteAction);
                        request.setAttribute("id", id);
                        request.setAttribute("countPattern", countPattern);
                        if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                            this.setData();
                            this.updateUI();
                            this.repaint();
                        }
                    }
                }
            }
            if (this.getAction.equals("GetCategoryList")) {
                if (!"0".equals(id)) {
                    request.setModule(this.module);
                    request.setAction("InspectionCategory");
                    request.setAttribute("categoryId", id);
                    doc = this.getDocument(request);
                    if (ClientUtils.checkStatus((Document)doc)) {
                        tableElement = XMLUtils.selectElement((Node)doc, (String)"//table/data/row");
                        int countCategory = Utils.parseInt((String)tableElement.getAttribute("countCategory"));
                        if (countCategory > 0) {
                            ClientUtils.showErrorMessageDialog((String)("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e. \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0435\u043c \u0441 \u0442\u0430\u043a\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0435\u0439 " + countCategory + ".  \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u0435 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043f\u0435\u0440\u0435\u0434 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c."));
                        } else {
                            request = new Request();
                            request.setModule(this.module);
                            request.setAction(this.deleteAction);
                            request.setAttribute("id", id);
                            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                                this.setData();
                                this.updateUI();
                                this.repaint();
                            }
                        }
                    }
                } else {
                    this.setData();
                }
            }
            if (this.getAction.equals("GetSubCategoryList")) {
                if (!"0".equals(id)) {
                    request.setModule(this.module);
                    request.setAction("InspectionSubcategory");
                    request.setAttribute("subcategoryId", id);
                    doc = this.getDocument(request);
                    if (ClientUtils.checkStatus((Document)doc)) {
                        tableElement = XMLUtils.selectElement((Node)doc, (String)"//table/data/row");
                        int countSubcategory = Utils.parseInt((String)tableElement.getAttribute("countSubcategory"));
                        if (countSubcategory > 0) {
                            ClientUtils.showErrorMessageDialog((String)("\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e. \u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0442\u0435\u043c \u0441 \u0442\u0430\u043a\u043e\u0439 \u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0435\u0439 " + countSubcategory + ".  \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u0435 \u043f\u043e\u0434\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e \u043f\u0435\u0440\u0435\u0434 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c."));
                        } else {
                            request = new Request();
                            request.setModule(this.module);
                            request.setAction(this.deleteAction);
                            request.setAttribute("id", id);
                            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                                this.setData();
                                this.updateUI();
                                this.repaint();
                            }
                        }
                    }
                } else {
                    this.setData();
                }
            }
        }
    }

    public void update(IdTitle idTitle) {
        try {
            ClientContext clientContext = this.getContext();
            if ("SetGroupTitle".equals(this.setAction)) {
                ((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).updateGroup(idTitle);
            } else if ("SetCategoryTitle".equals(this.setAction)) {
                ((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).updateCategory(idTitle);
            } else if ("SetSubCategoryTitle".equals(this.setAction)) {
                ((HelpdeskService)clientContext.getWebService(HelpdeskService.class)).updateSubCategory(idTitle);
            }
            this.setData();
            this.updateUI();
            this.repaint();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void setData() {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction(this.getAction);
        request.setPageIndex(this.controlPanelPages.getPageIndex());
        request.setPageSize(this.controlPanelPages.getPageSize());
        this.setDocument(this.getDocument(request));
    }

    public void setDocument(Document doc) {
        if (ClientUtils.checkStatus((Document)doc)) {
            Element tableElement = XMLUtils.selectElement((Node)doc, (String)"//table/data");
            ArrayList<IdTitle> list = new ArrayList<IdTitle>();
            NodeList listCategory = tableElement.getChildNodes();
            for (Element row : XMLUtils.elements((NodeList)listCategory)) {
                list.add(new IdTitle(Utils.parseInt((String)row.getAttribute("id")), row.getAttribute("title")));
            }
            this.tableModel.setData(list);
            this.controlPanelPages.setPageInfo(tableElement);
            this.label.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + Page.getRecordCount((Element)tableElement));
        }
    }

    private class HelpDeskCellEditor
    implements TableCellEditor {
        JTextField tf = new JTextField();
        DefaultCellEditor textFieldEditor;
        JPanel editor = new JPanel(new GridBagLayout());
        int selectRow = -1;

        public HelpDeskCellEditor() {
            this.tf.setBorder(new LineBorder(Color.darkGray));
            this.textFieldEditor = new DefaultCellEditor(this.tf);
            this.editor.add(this.tf);
            this.tf.setFont(new Font("myfont", 0, 15));
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.textFieldEditor.addCellEditorListener(l);
        }

        @Override
        public void cancelCellEditing() {
            this.textFieldEditor.cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.textFieldEditor.getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            this.selectRow = HelpDeskTableTabInDirectory.this.table.getSelectedRow();
            return this.textFieldEditor.isCellEditable(anEvent);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.textFieldEditor.removeCellEditorListener(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return this.textFieldEditor.isCellEditable(anEvent);
        }

        @Override
        public boolean stopCellEditing() {
            if (this.selectRow == -1) {
                return this.textFieldEditor.stopCellEditing();
            }
            IdTitle row = (IdTitle)HelpDeskTableTabInDirectory.this.tableModel.getSelectedRow();
            if (row != null && !this.tf.getText().equals("\u041d\u043e\u0432\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430") && !row.getTitle().equals(this.tf.getText())) {
                HelpDeskTableTabInDirectory.this.update(row);
            }
            return this.textFieldEditor.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return this.textFieldEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public void stopCellEditorForEnter() {
            if (this.selectRow == -1) {
                return;
            }
            IdTitle row = (IdTitle)HelpDeskTableTabInDirectory.this.tableModel.getSelectedRow();
            if (row != null && !row.getTitle().equals("\u041d\u043e\u0432\u0430\u044f \u0441\u0442\u0440\u043e\u043a\u0430")) {
                HelpDeskTableTabInDirectory.this.update(row);
            }
        }
    }
}

