/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.im.client;

import bitel.billing.module.common.BGComboBoxFixed;
import bitel.billing.module.common.ClosableTabbedPaneUI;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import javax.swing.plaf.TabbedPaneUI;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGUTabPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.im.client.AddContactDialog;
import ru.bitel.bgbilling.plugins.im.client.IMManagerChatTab;
import ru.bitel.bgbilling.plugins.im.client.IMTabPane;
import ru.bitel.bgbilling.plugins.im.client.PluginClientListener;
import ru.bitel.bgbilling.plugins.im.client.RosterTree;
import ru.bitel.bgbilling.plugins.im.client.RosterTreeNodeEntry;
import ru.bitel.bgbilling.plugins.im.common.IMConstants;
import ru.bitel.bgbilling.plugins.im.common.IMMessage;
import ru.bitel.bgbilling.plugins.im.common.IMService;
import ru.bitel.bgbilling.plugins.im.common.IMUtils;
import ru.bitel.bgbilling.plugins.im.common.ProcessCheckStatus;
import ru.bitel.bgbilling.plugins.im.common.RosterChange;
import ru.bitel.bgbilling.plugins.im.common.RosterEntryItem;
import ru.bitel.bgbilling.plugins.im.common.RosterRootItem;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;

public class IMManager
extends BGUTabPanel
implements Runnable {
    public static final String TAB_ID = "IMManager";
    private BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.im");
    private IMTabPane tabbedPaneChat = new IMTabPane();
    private RosterTree tree;
    private BGComboBoxFixed statusCB = new BGComboBoxFixed();
    private Thread imCheckStatusThread = null;
    boolean disableEventsStatusCB = false;
    private Set<String> messagedEntrys = new HashSet<String>();
    boolean messageFlashOn = false;
    private Map<String, Integer> countNewMessagesMap = new HashMap<String, Integer>();

    public IMManager() {
        this(new ClientContext("ru.bitel.bgbilling.plugins.im", 0, 0, ""));
    }

    public IMManager(ClientContext ctx) {
        super(ctx, TAB_ID, "IM");
        this.tree = new RosterTree();
        this.setLayout(new GridBagLayout());
        JPanel panelTop = new JPanel();
        panelTop.add((Component)this.statusCB, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add(panelTop, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panelRoster = new JPanel();
        panelRoster.setLayout(new GridBagLayout());
        panelRoster.add((Component)new JScrollPane(this.tree.getViewableTree(), 20, 31), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JSplitPane mainSplit = new JSplitPane();
        this.add(mainSplit, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mainSplit.add((Component)panelRoster, "left");
        mainSplit.add((Component)((Object)this.tabbedPaneChat), "right");
        mainSplit.setBorder(null);
        mainSplit.setDividerSize(5);
        mainSplit.setDividerLocation(300);
        this.tabbedPaneChat.setUI((TabbedPaneUI)new ClosableTabbedPaneUI(ClosableTabbedPaneUI.TabCloseButtonAlign.RIGHT));
        this.statusCB.addItem((Object)IMConstants.STATUS.ONLINE, "Online", PluginClientListener.statusIcon.get(IMConstants.STATUS.ONLINE));
        this.statusCB.addItem((Object)IMConstants.STATUS.AWAY, "Away", PluginClientListener.statusIcon.get(IMConstants.STATUS.AWAY));
        this.statusCB.addItem((Object)IMConstants.STATUS.DND, "Dnd", PluginClientListener.statusIcon.get(IMConstants.STATUS.DND));
        this.statusCB.addItem((Object)IMConstants.STATUS.OFFLINE, "Offline", PluginClientListener.statusIcon.get(IMConstants.STATUS.OFFLINE));
        this.statusCB.setSelectedId((Object)IMConstants.STATUS.OFFLINE);
        this.statusCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!IMManager.this.disableEventsStatusCB) {
                    IMManager.this.setStatus(IMManager.this.getComboBoxStatus());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                IMManagerChatTab selTab = (IMManagerChatTab)((Object)IMManager.this.tabbedPaneChat.getSelectedComponent());
                if (selTab != null) {
                    selTab.setVisible(false);
                    selTab.setVisible(true);
                }
            }
        });
        Timer messagedFlashTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IMManager.this.refreshMessagedEntry();
            }
        });
        messagedFlashTimer.start();
    }

    protected void jbInit() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMessagedEntry() {
        if (this.messageFlashOn) {
            for (String jid : this.messagedEntrys) {
                IMManagerChatTab tab;
                RosterTreeNodeEntry entryNode = this.tree.getEntryMap().get(jid);
                if (entryNode != null) {
                    entryNode.setMessaged(false);
                }
                if ((tab = (IMManagerChatTab)this.tabbedPaneChat.getTab(jid)) == null) continue;
                tab.setMessaged(false);
            }
            this.messagedEntrys.clear();
        } else {
            Map<String, Integer> map = this.countNewMessagesMap;
            synchronized (map) {
                for (String jid : this.countNewMessagesMap.keySet()) {
                    IMManagerChatTab tab;
                    this.messagedEntrys.add(jid);
                    RosterTreeNodeEntry entryNode = this.tree.getEntryMap().get(jid);
                    if (entryNode != null) {
                        entryNode.setMessaged(true);
                    }
                    if ((tab = (IMManagerChatTab)this.tabbedPaneChat.getTab(jid)) == null) continue;
                    tab.setMessaged(true);
                }
            }
        }
        this.messageFlashOn = !this.messageFlashOn;
        this.tree.getViewableTree().repaint();
    }

    private void setStatus(IMConstants.STATUS status) {
        try {
            ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).setStatus(status);
            switch (status) {
                case OFFLINE: {
                    this.stopThread();
                    this.tree.setOfflinedTree();
                    break;
                }
                case AWAY: 
                case DND: 
                case ONLINE: {
                    this.setDataRoster();
                    this.startThread();
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog((Component)BGClient.getFrame(), ex.getMessage());
            this.setComboBoxStatus(IMConstants.STATUS.OFFLINE);
            this.stopThread();
            this.tree.setOfflinedTree();
        }
        if (PluginClientListener.toolbarIMButton != null) {
            PluginClientListener.toolbarIMButton.refreshStatusIcon();
        }
        this.setStatusedTabs();
    }

    private void startThread() {
        if (this.imCheckStatusThread == null) {
            this.imCheckStatusThread = new Thread((Runnable)this, "IM CheckStatus Thread");
            this.imCheckStatusThread.start();
        }
    }

    private void stopThread() {
        if (this.imCheckStatusThread != null && this.imCheckStatusThread.isAlive()) {
            this.imCheckStatusThread.interrupt();
        }
    }

    public IMConstants.STATUS getComboBoxStatus() {
        ComboBoxItem statusItem = (ComboBoxItem)this.statusCB.getSelectedItem();
        return statusItem != null ? (IMConstants.STATUS)statusItem.getObject() : null;
    }

    public void setComboBoxStatus(final IMConstants.STATUS status) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                IMManager.this.disableEventsStatusCB = true;
                IMManager.this.statusCB.setSelectedId((Object)status);
                IMManager.this.disableEventsStatusCB = false;
            }
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                IMManager.this.setDataRoster();
            }
        };
    }

    public void setDataRoster() throws BGException {
        RosterRootItem result = ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).getRoster();
        this.tree.loadTree(result);
    }

    public IMManagerChatTab openChat(String jid, boolean openit) {
        IMManagerChatTab imChatTab = (IMManagerChatTab)this.tabbedPaneChat.getTab(jid, openit);
        if (imChatTab == null) {
            imChatTab = (IMManagerChatTab)this.tabbedPaneChat.getTab(IMUtils.getPureJID((String)jid), openit);
            String name = this.getNameFromJid(jid);
            Icon icon = PluginClientListener.statusIcon.get(this.getStatusFromJid(jid));
            if (imChatTab == null) {
                imChatTab = new IMManagerChatTab(jid, name, this.plugin, icon);
                this.tabbedPaneChat.addTab(imChatTab, openit);
            } else {
                imChatTab.renameTab(jid, name, icon);
            }
        }
        return imChatTab;
    }

    @Override
    public void run() {
        int timeout = Utils.parseInt((String)this.plugin.getResourceString("IM.client.check.status.timeout"), (int)0);
        System.out.println("IM.client.check.status.timeout=" + timeout);
        if (timeout == 0) {
            System.out.println("=>disable checking IM status");
            return;
        }
        try {
            System.out.println("IM thread start");
            while (true) {
                try {
                    ProcessCheckStatus result = ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).checkStatus();
                    this.setDocumentCheckStatus(result);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog((Component)BGClient.getFrame(), ex.getMessage());
                    this.setComboBoxStatus(IMConstants.STATUS.OFFLINE);
                    this.tree.setOfflinedTree();
                    this.setStatusedTabs();
                    if (PluginClientListener.toolbarIMButton != null) {
                        PluginClientListener.toolbarIMButton.refreshStatusIcon();
                    }
                    throw new InterruptedException("checkStatus false return - exit thread");
                }
                Thread.sleep((long)timeout * 1000L);
            }
        }
        catch (InterruptedException exception) {
            System.out.println("IM thread InterruptedException (normal): " + exception.getMessage());
            System.out.println("IM thread stop");
            this.imCheckStatusThread = null;
        }
        catch (Throwable exception) {
            try {
                System.out.println("IM thread Exception (anormal!): " + exception);
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                System.out.println("IM thread stop");
                this.imCheckStatusThread = null;
            }
        }
    }

    public void setDocumentCheckStatus(ProcessCheckStatus doc) {
        List messageList;
        List rosterChangesList = doc.getRosterChanges();
        if (rosterChangesList != null) {
            for (RosterChange el : rosterChangesList) {
                IMConstants.RosterListenerMode mode = el.mode;
                if (mode == IMConstants.RosterListenerMode.CHANGE) {
                    for (RosterEntryItem el2 : el.getRosterEntryItems()) {
                        this.tree.changeEntryUser(el2);
                    }
                    continue;
                }
                if (mode != IMConstants.RosterListenerMode.DELETE) continue;
                String user = el.user;
                this.tree.deleteEntryUser(user);
            }
        }
        if ((messageList = doc.getMessageList()) != null) {
            for (IMMessage msg : messageList) {
                IMManagerChatTab tab = null;
                if (msg.isIncoming()) {
                    tab = this.openChat(msg.getFrom(), false);
                    this.incNewMessages4jid(msg.getFrom());
                } else {
                    tab = this.openChat(msg.getTo(), false);
                }
                tab.putMessage(msg);
            }
        }
        if (PluginClientListener.toolbarIMButton != null) {
            PluginClientListener.toolbarIMButton.refreshNewMessagesCount();
        }
        if (rosterChangesList != null && !rosterChangesList.isEmpty()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IMManager.this.tree.getViewableTree().updateUI();
                }
            });
        }
        this.setStatusedTabs();
    }

    public String getNameFromJid(String jid) {
        Object nName = this.tree.getEntry2nameMap().get(IMUtils.getPureJID((String)jid));
        if (nName != null) {
            String jidres = IMUtils.getJIDResource((String)jid);
            if (jidres != null) {
                nName = (String)nName + "/" + jidres;
            }
            return nName;
        }
        return jid;
    }

    private IMConstants.STATUS getStatusFromJid(String jid) {
        RosterTreeNodeEntry nodeEntry = this.tree.getEntryMap().get(jid);
        if (nodeEntry != null) {
            return nodeEntry.getStatus();
        }
        return IMConstants.STATUS.OFFLINE;
    }

    public void tryConnect(IMConstants.STATUS status) {
        if (status != this.getComboBoxStatus()) {
            this.setComboBoxStatus(status);
            this.setStatus(status);
        }
    }

    public void setRosterJson(String jsonString) {
        this.tree.setRosterJson(jsonString);
    }

    public String getRosterJson() {
        return this.tree.getRosterJson();
    }

    public Map<String, Integer> getCountNewMessagesMap() {
        return this.countNewMessagesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eraseNewMessages4jid(String jid) {
        Map<String, Integer> map = this.countNewMessagesMap;
        synchronized (map) {
            this.countNewMessagesMap.remove(jid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incNewMessages4jid(String jid) {
        String selJid;
        IMManagerChatTab selTab = (IMManagerChatTab)((Object)this.tabbedPaneChat.getSelectedComponent());
        String string = selJid = selTab != null ? selTab.getTabId() : null;
        if (!this.isShowing() || this.isShowing() && (selJid == null || !selJid.equals(jid))) {
            Map<String, Integer> map = this.countNewMessagesMap;
            synchronized (map) {
                this.countNewMessagesMap.put(jid, this.countNewMessagesMap.containsKey(jid) ? this.countNewMessagesMap.get(jid) + 1 : 1);
            }
        }
    }

    private void setStatusedTabs() {
        int cc = this.tabbedPaneChat.getComponentCount();
        for (int i = 0; i < cc; ++i) {
            IMManagerChatTab tab = (IMManagerChatTab)((Object)this.tabbedPaneChat.getComponentAt(i));
            tab.renameTab(null, null, PluginClientListener.statusIcon.get(this.getStatusFromJid(tab.getTabId())));
        }
    }

    public void addContactDialog() {
        AddContactDialog addContactDialog = new AddContactDialog(this.tree.getGroupMap().values());
        if ("ok".equals(addContactDialog.showDialog())) {
            try {
                ProcessCheckStatus pcs = ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).rosterAddContact(addContactDialog.getJid(), addContactDialog.getName(), addContactDialog.getGroup());
                this.setDocumentCheckStatus(pcs);
            }
            catch (BGException e) {
                this.processException(e);
            }
        }
    }

    public void renameGroupDialog(String groupName) {
        String newGroupName = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u0438\u043c\u044f \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f\u044b '" + groupName + "'", "\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443", 3, null, null, groupName);
        if (newGroupName != null) {
            try {
                ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).rosterRenameGroup(groupName, newGroupName);
                this.setDataRoster();
            }
            catch (BGException e) {
                this.processException(e);
            }
        }
    }

    public void removeGroupDialog(String groupName) {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0433\u0440\u0443\u043f\u043f\u0443 '" + groupName + "' (\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u044b \u043f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u044f\u0442\u0441\u044f \u0432 'General')?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b", 0) == 0) {
            try {
                ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).rosterRemoveGroup(groupName);
                this.setDataRoster();
            }
            catch (BGException e) {
                this.processException(e);
            }
        }
    }

    public void renameContactDialog(String jid, String name) {
        jid = IMUtils.getPureJID((String)jid);
        String newContactName = (String)JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u043e\u0432\u043e\u0435 \u0438\u043c\u044f \u0434\u043b\u044f \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430 '" + jid + "'", "\u041f\u0435\u0440\u0435\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442", 3, null, null, name);
        if (newContactName != null) {
            try {
                ProcessCheckStatus pcs = ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).rosterRenameContact(jid, newContactName);
                this.setDocumentCheckStatus(pcs);
            }
            catch (BGException e) {
                this.processException(e);
            }
        }
    }

    public void removeContactDialog(String jid) {
        jid = IMUtils.getPureJID((String)jid);
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442 '" + jid + "'?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", 0) == 0) {
            try {
                ProcessCheckStatus pcs = ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).rosterRemoveContact(jid);
                this.setDocumentCheckStatus(pcs);
            }
            catch (BGException e) {
                this.processException(e);
            }
        }
    }

    public void openChatContactDialog(String jid) {
        this.openChat(jid, true);
    }

    public void newGroupAndMoveContactDialog(String jid) {
        String newGroupName = JOptionPane.showInputDialog(JOptionPane.getRootFrame(), "\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0438\u043c\u044f \u0433\u0440\u0443\u043f\u043f\u044b", "\u041d\u043e\u0432\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430", 3);
        if (newGroupName != null) {
            this.moveContactToGroupDialog(jid, newGroupName);
        }
    }

    public void moveContactToGroupDialog(String jid, String groupName) {
        jid = IMUtils.getPureJID((String)jid);
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u041f\u0435\u0440\u0435\u043c\u0435\u0441\u0442\u0438\u0442\u044c \u043a\u043e\u043d\u0442\u0430\u043a\u0442 '" + jid + "' \u0432 \u0433\u0440\u0443\u043f\u043f\u0443 '" + groupName + "'?", "\u041f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0442\u0430\u043a\u0442\u0430", 0) == 0) {
            try {
                ProcessCheckStatus pcs = ((IMService)((ClientContext)this.getContext()).getPort(IMService.class)).rosterMoveContact(jid, groupName);
                this.setDocumentCheckStatus(pcs);
            }
            catch (BGException e) {
                this.processException(e);
            }
        }
    }
}

