/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.inet.common.bean.InetOption;
import ru.bitel.bgbilling.modules.inet.common.event.InetOptionModifiedEvent;
import ru.bitel.bgbilling.modules.inet.server.bean.InetOptionDao;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetOptionRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class InetOptionRuntimeMap
implements EventListener<InetOptionModifiedEvent> {
    private static final Logger logger = LogManager.getLogger();
    private static final ConcurrentMap<Integer, InetOptionRuntimeMap> moduleMap = new ConcurrentHashMap<Integer, InetOptionRuntimeMap>();
    private final int moduleId;
    private volatile Map<Integer, InetOptionRuntime> idMap;
    private final ParameterMap emptyConfig = new Preferences();

    @Deprecated
    public static InetOptionRuntimeMap getInstance(Connection con, int moduleId) throws BGException {
        InetOptionRuntimeMap result = (InetOptionRuntimeMap)moduleMap.get(moduleId);
        if (result == null) {
            EventProcessor ep = EventProcessor.getInstance();
            InetOptionRuntimeMap newResult = new InetOptionRuntimeMap(moduleId);
            ep.addListener((EventListener)newResult, InetOptionModifiedEvent.class, moduleId, null);
            newResult.idMap = newResult.load(con);
            result = moduleMap.putIfAbsent(moduleId, newResult);
            if (result == null) {
                result = newResult;
            } else {
                ep.removeListener((EventListener)newResult);
            }
        }
        return result;
    }

    public static InetOptionRuntimeMap getInstance(ConnectionSet connectionSet, int moduleId) throws BGException {
        InetOptionRuntimeMap result = (InetOptionRuntimeMap)moduleMap.get(moduleId);
        if (result == null) {
            EventProcessor ep = EventProcessor.getInstance();
            InetOptionRuntimeMap newResult = new InetOptionRuntimeMap(moduleId);
            ep.addListener((EventListener)newResult, InetOptionModifiedEvent.class, moduleId, null);
            newResult.idMap = newResult.load(connectionSet.getConnection());
            result = moduleMap.putIfAbsent(moduleId, newResult);
            if (result == null) {
                result = newResult;
            } else {
                ep.removeListener((EventListener)newResult);
            }
        }
        return result;
    }

    @Deprecated
    public static InetOptionRuntimeMap getInstance() throws BGException {
        ServerContext context = (ServerContext)ThreadContext.get(ServerContext.class);
        return InetOptionRuntimeMap.getInstance(context.getConnectionSet(), context.getModuleId());
    }

    public static InetOptionRuntimeMap getInstance(int moduleId) throws BGException {
        ServerContext context = (ServerContext)ThreadContext.get(ServerContext.class);
        return InetOptionRuntimeMap.getInstance(context.getConnectionSet(), moduleId);
    }

    private InetOptionRuntimeMap(int moduleId) {
        this.moduleId = moduleId;
    }

    public void notify(InetOptionModifiedEvent e, EventListenerContext ctx) throws BGException {
        this.idMap = this.load();
    }

    public InetOptionRuntime get(int id) {
        return this.idMap.get(id);
    }

    public Map<Integer, InetOptionRuntime> getMap() {
        return this.idMap;
    }

    private Map<Integer, InetOptionRuntime> load() throws BGException {
        ServerContext context = (ServerContext)ThreadContext.get(ServerContext.class);
        return this.load(context.getConnection());
    }

    private Map<Integer, InetOptionRuntime> load(Connection con) throws BGException {
        HashMap<Integer, InetOptionRuntime> idMap = new HashMap<Integer, InetOptionRuntime>();
        logger.info("Loading inetOptionRuntimeMap for moduleId:" + this.moduleId);
        InetOption root = new InetOptionDao(con, this.moduleId).tree();
        this.load(idMap, root, this.emptyConfig);
        return idMap;
    }

    private List<InetOptionRuntime> load(Map<Integer, InetOptionRuntime> map, InetOption parent, ParameterMap parentConfig) throws BGException {
        ArrayList<InetOptionRuntime> result = new ArrayList<InetOptionRuntime>();
        if (parent.getChildren() != null) {
            Set siblingIds = Id.newIdSet((List)parent.getChildren());
            for (InetOption option : parent.getChildren()) {
                String configString = option.getConfig();
                Preferences vars = new Preferences(false, false);
                vars.set("optionTitle", String.valueOf(option.getTitle()));
                Preferences config = new Preferences((ParameterMap)vars, configString, "\n", false, false);
                Preferences inheritedConfig = new Preferences(parentConfig.inherit((ParameterMap)vars), configString, "\n", false, false);
                List<InetOptionRuntime> childrenOptionRuntime = this.load(map, option, (ParameterMap)inheritedConfig);
                HashSet<Integer> replaceIds = parent.isGroupIntersection() ? null : new HashSet<Integer>(siblingIds);
                InetOptionRuntime optionRuntime = new InetOptionRuntime(parent.getId(), option, (ParameterMap)config, (ParameterMap)inheritedConfig, siblingIds, replaceIds);
                for (InetOptionRuntime childOptionRuntime : childrenOptionRuntime) {
                    childOptionRuntime.parent = optionRuntime;
                    optionRuntime.descendantIds0.add(childOptionRuntime.id);
                    optionRuntime.descendantIds0.addAll(childOptionRuntime.descendantIds0);
                }
                map.put(option.getId(), optionRuntime);
                result.add(optionRuntime);
            }
        }
        return result;
    }
}

